package io.strimzi.api.kafka.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class JbodStorageBuilder extends JbodStorageFluent<JbodStorageBuilder> implements VisitableBuilder<JbodStorage,JbodStorageBuilder>{
  public JbodStorageBuilder() {
    this(false);
  }
  public JbodStorageBuilder(Boolean validationEnabled) {
    this(new JbodStorage(), validationEnabled);
  }
  public JbodStorageBuilder(JbodStorageFluent<?> fluent) {
    this(fluent, false);
  }
  public JbodStorageBuilder(JbodStorageFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new JbodStorage(), validationEnabled);
  }
  public JbodStorageBuilder(JbodStorageFluent<?> fluent,JbodStorage instance) {
    this(fluent, instance, false);
  }
  public JbodStorageBuilder(JbodStorageFluent<?> fluent,JbodStorage instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new JbodStorage());

    if (instance != null) {
      fluent.withVolumes(instance.getVolumes());
    }
    this.validationEnabled = validationEnabled; 
  }
  public JbodStorageBuilder(JbodStorage instance) {
    this(instance,false);
  }
  public JbodStorageBuilder(JbodStorage instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new JbodStorage());

    if (instance != null) {
      this.withVolumes(instance.getVolumes());
    }
    this.validationEnabled = validationEnabled; 
  }
  JbodStorageFluent<?> fluent;
  Boolean validationEnabled;
  public JbodStorage build() {
    JbodStorage buildable = new JbodStorage();
    buildable.setVolumes(fluent.buildVolumes());
    return buildable;
  }
  
}