package io.strimzi.api.kafka.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class JbodStorageFluent<A extends JbodStorageFluent<A>> extends BaseFluent<A>{
  public JbodStorageFluent() {
  }
  public JbodStorageFluent(JbodStorage instance) {
    instance = (instance != null ? instance : new JbodStorage());

    if (instance != null) {
      this.withVolumes(instance.getVolumes());
    }
  }
  private ArrayList<VisitableBuilder<? extends SingleVolumeStorage,?>> volumes;
  public A addToVolumes(VisitableBuilder<? extends SingleVolumeStorage,?> builder) {
    if (this.volumes == null) {this.volumes = new ArrayList<VisitableBuilder<? extends SingleVolumeStorage,?>>();}
    _visitables.get("volumes").add(builder);this.volumes.add(builder); return (A)this;
  }
  public A addToVolumes(int index,VisitableBuilder<? extends SingleVolumeStorage,?> builder) {
    if (this.volumes == null) {this.volumes = new ArrayList<VisitableBuilder<? extends SingleVolumeStorage,?>>();}
    if (index < 0 || index >= volumes.size()) { _visitables.get("volumes").add(builder); volumes.add(builder); } else { _visitables.get("volumes").add(index, builder); volumes.add(index, builder);}
    return (A)this;
  }
  public A addToVolumes(int index,SingleVolumeStorage item) {
    if (this.volumes == null) {this.volumes = new ArrayList<VisitableBuilder<? extends SingleVolumeStorage,?>>();}
    VisitableBuilder<? extends SingleVolumeStorage,?> builder = builder(item);
    if (index < 0 || index >= volumes.size()) { _visitables.get("volumes").add(builder); volumes.add(builder); } else { _visitables.get("volumes").add(index, builder); volumes.add(index, builder);}
    return (A)this;
  }
  public A setToVolumes(int index,SingleVolumeStorage item) {
    if (this.volumes == null) {this.volumes = new ArrayList<VisitableBuilder<? extends SingleVolumeStorage,?>>();}
    VisitableBuilder<? extends SingleVolumeStorage,?> builder = builder(item);
    if (index < 0 || index >= volumes.size()) { _visitables.get("volumes").add(builder); volumes.add(builder); } else { _visitables.get("volumes").set(index, builder); volumes.set(index, builder);}
    return (A)this;
  }
  public A addToVolumes(io.strimzi.api.kafka.model.storage.SingleVolumeStorage... items) {
    if (this.volumes == null) {this.volumes = new ArrayList<VisitableBuilder<? extends SingleVolumeStorage,?>>();}
    for (SingleVolumeStorage item : items) { VisitableBuilder<? extends SingleVolumeStorage,?> builder = builder(item); _visitables.get("volumes").add(builder);this.volumes.add(builder); }
    return (A)this;
  }
  public A addAllToVolumes(Collection<SingleVolumeStorage> items) {
    if (this.volumes == null) {this.volumes = new ArrayList<VisitableBuilder<? extends SingleVolumeStorage,?>>();}
    for (SingleVolumeStorage item : items) { VisitableBuilder<? extends SingleVolumeStorage,?> builder = builder(item); _visitables.get("volumes").add(builder);this.volumes.add(builder); }
    return (A)this;
  }
  public A removeFromVolumes(VisitableBuilder<? extends SingleVolumeStorage,?> builder) {
    if (this.volumes == null) return (A)this;
    _visitables.get("volumes").remove(builder);this.volumes.remove(builder); return (A)this;
  }
  public A removeFromVolumes(io.strimzi.api.kafka.model.storage.SingleVolumeStorage... items) {
    if (this.volumes == null) return (A)this;
    for (SingleVolumeStorage item : items) {
    VisitableBuilder<? extends SingleVolumeStorage,?> builder = builder(item); _visitables.get("volumes").remove(builder);this.volumes.remove(builder);
    } return (A)this;
  }
  public A removeAllFromVolumes(Collection<SingleVolumeStorage> items) {
    if (this.volumes == null) return (A)this;
    for (SingleVolumeStorage item : items) {
    VisitableBuilder<? extends SingleVolumeStorage,?> builder = builder(item); _visitables.get("volumes").remove(builder);this.volumes.remove(builder);
    } return (A)this;
  }
  public A removeMatchingFromVolumes(Predicate<VisitableBuilder<? extends SingleVolumeStorage,?>> predicate) {
    if (volumes == null) return (A) this;
    final Iterator<VisitableBuilder<? extends SingleVolumeStorage,?>> each = volumes.iterator();
    final List visitables = _visitables.get("volumes");
    while (each.hasNext()) {
      VisitableBuilder<? extends SingleVolumeStorage,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<SingleVolumeStorage> buildVolumes() {
    return build(volumes);
  }
  public SingleVolumeStorage buildVolume(int index) {
    return this.volumes.get(index).build();
  }
  public SingleVolumeStorage buildFirstVolume() {
    return this.volumes.get(0).build();
  }
  public SingleVolumeStorage buildLastVolume() {
    return this.volumes.get(volumes.size() - 1).build();
  }
  public SingleVolumeStorage buildMatchingVolume(Predicate<VisitableBuilder<? extends SingleVolumeStorage,?>> predicate) {
    for (VisitableBuilder<? extends SingleVolumeStorage,?> item: volumes) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingVolume(Predicate<VisitableBuilder<? extends SingleVolumeStorage,?>> predicate) {
    for (VisitableBuilder<? extends SingleVolumeStorage,?> item: volumes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVolumes(List<SingleVolumeStorage> volumes) {
    if (volumes != null) {this.volumes = new ArrayList(); for (SingleVolumeStorage item : volumes){this.addToVolumes(item);}} else { this.volumes = null;} return (A) this;
  }
  public A withVolumes(io.strimzi.api.kafka.model.storage.SingleVolumeStorage... volumes) {
    if (this.volumes != null) {this.volumes.clear(); _visitables.remove("volumes"); }
    if (volumes != null) {for (SingleVolumeStorage item :volumes){ this.addToVolumes(item);}} return (A) this;
  }
  public boolean hasVolumes() {
    return volumes != null && !volumes.isEmpty();
  }
  public PersistentClaimStorageVolumesNested<A> addNewPersistentClaimStorageVolume() {
    return new PersistentClaimStorageVolumesNested(-1, null);
  }
  public PersistentClaimStorageVolumesNested<A> addNewPersistentClaimStorageVolumeLike(PersistentClaimStorage item) {
    return new PersistentClaimStorageVolumesNested(-1, item);
  }
  public PersistentClaimStorageVolumesNested<A> setNewPersistentClaimStorageVolumeLike(int index,PersistentClaimStorage item) {
    return new PersistentClaimStorageVolumesNested(index, item);
  }
  public EphemeralStorageVolumesNested<A> addNewEphemeralStorageVolume() {
    return new EphemeralStorageVolumesNested(-1, null);
  }
  public EphemeralStorageVolumesNested<A> addNewEphemeralStorageVolumeLike(EphemeralStorage item) {
    return new EphemeralStorageVolumesNested(-1, item);
  }
  public EphemeralStorageVolumesNested<A> setNewEphemeralStorageVolumeLike(int index,EphemeralStorage item) {
    return new EphemeralStorageVolumesNested(index, item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    JbodStorageFluent that = (JbodStorageFluent) o;
    if (!java.util.Objects.equals(volumes, that.volumes)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(volumes,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (volumes != null && !volumes.isEmpty()) { sb.append("volumes:"); sb.append(volumes); }
    sb.append("}");
    return sb.toString();
  }
  protected static <T>VisitableBuilder<T,?> builder(Object item) {
    switch (item.getClass().getName()) {
    case "io.strimzi.api.kafka.model.storage."+"PersistentClaimStorage": return (VisitableBuilder<T, ?>)new PersistentClaimStorageBuilder((PersistentClaimStorage) item);
    case "io.strimzi.api.kafka.model.storage."+"EphemeralStorage": return (VisitableBuilder<T, ?>)new EphemeralStorageBuilder((EphemeralStorage) item);
    }
 return (VisitableBuilder<T, ?>)builderOf(item);
  }
  public class PersistentClaimStorageVolumesNested<N> extends PersistentClaimStorageFluent<PersistentClaimStorageVolumesNested<N>> implements Nested<N>{
    PersistentClaimStorageVolumesNested(int index,PersistentClaimStorage item) {
      this.index = index;
      this.builder = new PersistentClaimStorageBuilder(this, item);
    }
    PersistentClaimStorageBuilder builder;
    int index;
    public N and() {
      return (N) JbodStorageFluent.this.setToVolumes(index,builder.build());
    }
    public N endPersistentClaimStorageVolume() {
      return and();
    }
    
  }
  public class EphemeralStorageVolumesNested<N> extends EphemeralStorageFluent<EphemeralStorageVolumesNested<N>> implements Nested<N>{
    EphemeralStorageVolumesNested(int index,EphemeralStorage item) {
      this.index = index;
      this.builder = new EphemeralStorageBuilder(this, item);
    }
    EphemeralStorageBuilder builder;
    int index;
    public N and() {
      return (N) JbodStorageFluent.this.setToVolumes(index,builder.build());
    }
    public N endEphemeralStorageVolume() {
      return and();
    }
    
  }
  
}