package io.strimzi.api.kafka.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PersistentClaimStorageBuilder extends PersistentClaimStorageFluent<PersistentClaimStorageBuilder> implements VisitableBuilder<PersistentClaimStorage,PersistentClaimStorageBuilder>{
  public PersistentClaimStorageBuilder() {
    this(false);
  }
  public PersistentClaimStorageBuilder(Boolean validationEnabled) {
    this(new PersistentClaimStorage(), validationEnabled);
  }
  public PersistentClaimStorageBuilder(PersistentClaimStorageFluent<?> fluent) {
    this(fluent, false);
  }
  public PersistentClaimStorageBuilder(PersistentClaimStorageFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PersistentClaimStorage(), validationEnabled);
  }
  public PersistentClaimStorageBuilder(PersistentClaimStorageFluent<?> fluent,PersistentClaimStorage instance) {
    this(fluent, instance, false);
  }
  public PersistentClaimStorageBuilder(PersistentClaimStorageFluent<?> fluent,PersistentClaimStorage instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PersistentClaimStorage());

    if (instance != null) {
      fluent.withSize(instance.getSize());
      fluent.withStorageClass(instance.getStorageClass());
      fluent.withSelector(instance.getSelector());
      fluent.withDeleteClaim(instance.isDeleteClaim());
      fluent.withOverrides(instance.getOverrides());
      fluent.withId(instance.getId());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PersistentClaimStorageBuilder(PersistentClaimStorage instance) {
    this(instance,false);
  }
  public PersistentClaimStorageBuilder(PersistentClaimStorage instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PersistentClaimStorage());

    if (instance != null) {
      this.withSize(instance.getSize());
      this.withStorageClass(instance.getStorageClass());
      this.withSelector(instance.getSelector());
      this.withDeleteClaim(instance.isDeleteClaim());
      this.withOverrides(instance.getOverrides());
      this.withId(instance.getId());
    }
    this.validationEnabled = validationEnabled; 
  }
  PersistentClaimStorageFluent<?> fluent;
  Boolean validationEnabled;
  public PersistentClaimStorage build() {
    PersistentClaimStorage buildable = new PersistentClaimStorage();
    buildable.setSize(fluent.getSize());
    buildable.setStorageClass(fluent.getStorageClass());
    buildable.setSelector(fluent.getSelector());
    buildable.setDeleteClaim(fluent.isDeleteClaim());
    buildable.setOverrides(fluent.buildOverrides());
    buildable.setId(fluent.getId());
    return buildable;
  }
  
}