package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BuildConfigTemplateBuilder extends BuildConfigTemplateFluent<BuildConfigTemplateBuilder> implements VisitableBuilder<BuildConfigTemplate,BuildConfigTemplateBuilder>{
  public BuildConfigTemplateBuilder() {
    this(false);
  }
  public BuildConfigTemplateBuilder(Boolean validationEnabled) {
    this(new BuildConfigTemplate(), validationEnabled);
  }
  public BuildConfigTemplateBuilder(BuildConfigTemplateFluent<?> fluent) {
    this(fluent, false);
  }
  public BuildConfigTemplateBuilder(BuildConfigTemplateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BuildConfigTemplate(), validationEnabled);
  }
  public BuildConfigTemplateBuilder(BuildConfigTemplateFluent<?> fluent,BuildConfigTemplate instance) {
    this(fluent, instance, false);
  }
  public BuildConfigTemplateBuilder(BuildConfigTemplateFluent<?> fluent,BuildConfigTemplate instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new BuildConfigTemplate());

    if (instance != null) {
      fluent.withMetadata(instance.getMetadata());
      fluent.withPullSecret(instance.getPullSecret());
    }
    this.validationEnabled = validationEnabled; 
  }
  public BuildConfigTemplateBuilder(BuildConfigTemplate instance) {
    this(instance,false);
  }
  public BuildConfigTemplateBuilder(BuildConfigTemplate instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new BuildConfigTemplate());

    if (instance != null) {
      this.withMetadata(instance.getMetadata());
      this.withPullSecret(instance.getPullSecret());
    }
    this.validationEnabled = validationEnabled; 
  }
  BuildConfigTemplateFluent<?> fluent;
  Boolean validationEnabled;
  public BuildConfigTemplate build() {
    BuildConfigTemplate buildable = new BuildConfigTemplate();
    buildable.setMetadata(fluent.buildMetadata());
    buildable.setPullSecret(fluent.getPullSecret());
    return buildable;
  }
  
}