package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ContainerTemplateBuilder extends ContainerTemplateFluent<ContainerTemplateBuilder> implements VisitableBuilder<ContainerTemplate,ContainerTemplateBuilder>{
  public ContainerTemplateBuilder() {
    this(false);
  }
  public ContainerTemplateBuilder(Boolean validationEnabled) {
    this(new ContainerTemplate(), validationEnabled);
  }
  public ContainerTemplateBuilder(ContainerTemplateFluent<?> fluent) {
    this(fluent, false);
  }
  public ContainerTemplateBuilder(ContainerTemplateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ContainerTemplate(), validationEnabled);
  }
  public ContainerTemplateBuilder(ContainerTemplateFluent<?> fluent,ContainerTemplate instance) {
    this(fluent, instance, false);
  }
  public ContainerTemplateBuilder(ContainerTemplateFluent<?> fluent,ContainerTemplate instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ContainerTemplate());

    if (instance != null) {
      fluent.withEnv(instance.getEnv());
      fluent.withSecurityContext(instance.getSecurityContext());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ContainerTemplateBuilder(ContainerTemplate instance) {
    this(instance,false);
  }
  public ContainerTemplateBuilder(ContainerTemplate instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ContainerTemplate());

    if (instance != null) {
      this.withEnv(instance.getEnv());
      this.withSecurityContext(instance.getSecurityContext());
    }
    this.validationEnabled = validationEnabled; 
  }
  ContainerTemplateFluent<?> fluent;
  Boolean validationEnabled;
  public ContainerTemplate build() {
    ContainerTemplate buildable = new ContainerTemplate();
    buildable.setEnv(fluent.buildEnv());
    buildable.setSecurityContext(fluent.getSecurityContext());
    return buildable;
  }
  
}