package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.strimzi.api.kafka.model.ContainerEnvVar;
import java.lang.String;
import java.util.function.Predicate;
import io.strimzi.api.kafka.model.ContainerEnvVarBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.SecurityContext;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import io.strimzi.api.kafka.model.ContainerEnvVarFluent;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ContainerTemplateFluent<A extends ContainerTemplateFluent<A>> extends BaseFluent<A>{
  public ContainerTemplateFluent() {
  }
  public ContainerTemplateFluent(ContainerTemplate instance) {
    instance = (instance != null ? instance : new ContainerTemplate());

    if (instance != null) {
      this.withEnv(instance.getEnv());
      this.withSecurityContext(instance.getSecurityContext());
    }
  }
  private ArrayList<ContainerEnvVarBuilder> env;
  private SecurityContext securityContext;
  public A addToEnv(int index,ContainerEnvVar item) {
    if (this.env == null) {this.env = new ArrayList<ContainerEnvVarBuilder>();}
    ContainerEnvVarBuilder builder = new ContainerEnvVarBuilder(item);
    if (index < 0 || index >= env.size()) { _visitables.get("env").add(builder); env.add(builder); } else { _visitables.get("env").add(index, builder); env.add(index, builder);}
    return (A)this;
  }
  public A setToEnv(int index,ContainerEnvVar item) {
    if (this.env == null) {this.env = new ArrayList<ContainerEnvVarBuilder>();}
    ContainerEnvVarBuilder builder = new ContainerEnvVarBuilder(item);
    if (index < 0 || index >= env.size()) { _visitables.get("env").add(builder); env.add(builder); } else { _visitables.get("env").set(index, builder); env.set(index, builder);}
    return (A)this;
  }
  public A addToEnv(io.strimzi.api.kafka.model.ContainerEnvVar... items) {
    if (this.env == null) {this.env = new ArrayList<ContainerEnvVarBuilder>();}
    for (ContainerEnvVar item : items) {ContainerEnvVarBuilder builder = new ContainerEnvVarBuilder(item);_visitables.get("env").add(builder);this.env.add(builder);} return (A)this;
  }
  public A addAllToEnv(Collection<ContainerEnvVar> items) {
    if (this.env == null) {this.env = new ArrayList<ContainerEnvVarBuilder>();}
    for (ContainerEnvVar item : items) {ContainerEnvVarBuilder builder = new ContainerEnvVarBuilder(item);_visitables.get("env").add(builder);this.env.add(builder);} return (A)this;
  }
  public A removeFromEnv(io.strimzi.api.kafka.model.ContainerEnvVar... items) {
    if (this.env == null) return (A)this;
    for (ContainerEnvVar item : items) {ContainerEnvVarBuilder builder = new ContainerEnvVarBuilder(item);_visitables.get("env").remove(builder); this.env.remove(builder);} return (A)this;
  }
  public A removeAllFromEnv(Collection<ContainerEnvVar> items) {
    if (this.env == null) return (A)this;
    for (ContainerEnvVar item : items) {ContainerEnvVarBuilder builder = new ContainerEnvVarBuilder(item);_visitables.get("env").remove(builder); this.env.remove(builder);} return (A)this;
  }
  public A removeMatchingFromEnv(Predicate<ContainerEnvVarBuilder> predicate) {
    if (env == null) return (A) this;
    final Iterator<ContainerEnvVarBuilder> each = env.iterator();
    final List visitables = _visitables.get("env");
    while (each.hasNext()) {
      ContainerEnvVarBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<ContainerEnvVar> buildEnv() {
    return env != null ? build(env) : null;
  }
  public ContainerEnvVar buildEnv(int index) {
    return this.env.get(index).build();
  }
  public ContainerEnvVar buildFirstEnv() {
    return this.env.get(0).build();
  }
  public ContainerEnvVar buildLastEnv() {
    return this.env.get(env.size() - 1).build();
  }
  public ContainerEnvVar buildMatchingEnv(Predicate<ContainerEnvVarBuilder> predicate) {
    for (ContainerEnvVarBuilder item: env) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingEnv(Predicate<ContainerEnvVarBuilder> predicate) {
    for (ContainerEnvVarBuilder item: env) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEnv(List<ContainerEnvVar> env) {
    if (this.env != null) { _visitables.get("env").clear();}
    if (env != null) {this.env = new ArrayList(); for (ContainerEnvVar item : env){this.addToEnv(item);}} else { this.env = null;} return (A) this;
  }
  public A withEnv(io.strimzi.api.kafka.model.ContainerEnvVar... env) {
    if (this.env != null) {this.env.clear(); _visitables.remove("env"); }
    if (env != null) {for (ContainerEnvVar item :env){ this.addToEnv(item);}} return (A) this;
  }
  public boolean hasEnv() {
    return env != null && !env.isEmpty();
  }
  public EnvNested<A> addNewEnv() {
    return new EnvNested(-1, null);
  }
  public EnvNested<A> addNewEnvLike(ContainerEnvVar item) {
    return new EnvNested(-1, item);
  }
  public EnvNested<A> setNewEnvLike(int index,ContainerEnvVar item) {
    return new EnvNested(index, item);
  }
  public EnvNested<A> editEnv(int index) {
    if (env.size() <= index) throw new RuntimeException("Can't edit env. Index exceeds size.");
    return setNewEnvLike(index, buildEnv(index));
  }
  public EnvNested<A> editFirstEnv() {
    if (env.size() == 0) throw new RuntimeException("Can't edit first env. The list is empty.");
    return setNewEnvLike(0, buildEnv(0));
  }
  public EnvNested<A> editLastEnv() {
    int index = env.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last env. The list is empty.");
    return setNewEnvLike(index, buildEnv(index));
  }
  public EnvNested<A> editMatchingEnv(Predicate<ContainerEnvVarBuilder> predicate) {
    int index = -1;
    for (int i=0;i<env.size();i++) { 
    if (predicate.test(env.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching env. No match found.");
    return setNewEnvLike(index, buildEnv(index));
  }
  public SecurityContext getSecurityContext() {
    return this.securityContext;
  }
  public A withSecurityContext(SecurityContext securityContext) {
    this.securityContext=securityContext; return (A) this;
  }
  public boolean hasSecurityContext() {
    return this.securityContext != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ContainerTemplateFluent that = (ContainerTemplateFluent) o;
    if (!java.util.Objects.equals(env, that.env)) return false;

    if (!java.util.Objects.equals(securityContext, that.securityContext)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(env,  securityContext,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (env != null && !env.isEmpty()) { sb.append("env:"); sb.append(env + ","); }
    if (securityContext != null) { sb.append("securityContext:"); sb.append(securityContext); }
    sb.append("}");
    return sb.toString();
  }
  public class EnvNested<N> extends ContainerEnvVarFluent<EnvNested<N>> implements Nested<N>{
    EnvNested(int index,ContainerEnvVar item) {
      this.index = index;
      this.builder = new ContainerEnvVarBuilder(this, item);
    }
    ContainerEnvVarBuilder builder;
    int index;
    public N and() {
      return (N) ContainerTemplateFluent.this.setToEnv(index,builder.build());
    }
    public N endEnv() {
      return and();
    }
    
  }
  
}