package io.strimzi.api.kafka.model.template;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CruiseControlTemplateFluent<A extends CruiseControlTemplateFluent<A>> extends BaseFluent<A>{
  public CruiseControlTemplateFluent() {
  }
  public CruiseControlTemplateFluent(CruiseControlTemplate instance) {
    instance = (instance != null ? instance : new CruiseControlTemplate());

    if (instance != null) {
      this.withDeployment(instance.getDeployment());
      this.withPod(instance.getPod());
      this.withApiService(instance.getApiService());
      this.withPodDisruptionBudget(instance.getPodDisruptionBudget());
      this.withCruiseControlContainer(instance.getCruiseControlContainer());
      this.withTlsSidecarContainer(instance.getTlsSidecarContainer());
      this.withServiceAccount(instance.getServiceAccount());
    }
  }
  private DeploymentTemplateBuilder deployment;
  private PodTemplateBuilder pod;
  private InternalServiceTemplateBuilder apiService;
  private PodDisruptionBudgetTemplateBuilder podDisruptionBudget;
  private ContainerTemplateBuilder cruiseControlContainer;
  private ContainerTemplateBuilder tlsSidecarContainer;
  private ResourceTemplateBuilder serviceAccount;
  public DeploymentTemplate buildDeployment() {
    return this.deployment!=null ?this.deployment.build():null;
  }
  public A withDeployment(DeploymentTemplate deployment) {
    _visitables.get("deployment").remove(this.deployment);
    if (deployment!=null){ this.deployment= new DeploymentTemplateBuilder(deployment); _visitables.get("deployment").add(this.deployment);} else { this.deployment = null; _visitables.get("deployment").remove(this.deployment); } return (A) this;
  }
  public boolean hasDeployment() {
    return this.deployment != null;
  }
  public DeploymentNested<A> withNewDeployment() {
    return new DeploymentNested(null);
  }
  public DeploymentNested<A> withNewDeploymentLike(DeploymentTemplate item) {
    return new DeploymentNested(item);
  }
  public DeploymentNested<A> editDeployment() {
    return withNewDeploymentLike(java.util.Optional.ofNullable(buildDeployment()).orElse(null));
  }
  public DeploymentNested<A> editOrNewDeployment() {
    return withNewDeploymentLike(java.util.Optional.ofNullable(buildDeployment()).orElse(new DeploymentTemplateBuilder().build()));
  }
  public DeploymentNested<A> editOrNewDeploymentLike(DeploymentTemplate item) {
    return withNewDeploymentLike(java.util.Optional.ofNullable(buildDeployment()).orElse(item));
  }
  public PodTemplate buildPod() {
    return this.pod!=null ?this.pod.build():null;
  }
  public A withPod(PodTemplate pod) {
    _visitables.get("pod").remove(this.pod);
    if (pod!=null){ this.pod= new PodTemplateBuilder(pod); _visitables.get("pod").add(this.pod);} else { this.pod = null; _visitables.get("pod").remove(this.pod); } return (A) this;
  }
  public boolean hasPod() {
    return this.pod != null;
  }
  public PodNested<A> withNewPod() {
    return new PodNested(null);
  }
  public PodNested<A> withNewPodLike(PodTemplate item) {
    return new PodNested(item);
  }
  public PodNested<A> editPod() {
    return withNewPodLike(java.util.Optional.ofNullable(buildPod()).orElse(null));
  }
  public PodNested<A> editOrNewPod() {
    return withNewPodLike(java.util.Optional.ofNullable(buildPod()).orElse(new PodTemplateBuilder().build()));
  }
  public PodNested<A> editOrNewPodLike(PodTemplate item) {
    return withNewPodLike(java.util.Optional.ofNullable(buildPod()).orElse(item));
  }
  public InternalServiceTemplate buildApiService() {
    return this.apiService!=null ?this.apiService.build():null;
  }
  public A withApiService(InternalServiceTemplate apiService) {
    _visitables.get("apiService").remove(this.apiService);
    if (apiService!=null){ this.apiService= new InternalServiceTemplateBuilder(apiService); _visitables.get("apiService").add(this.apiService);} else { this.apiService = null; _visitables.get("apiService").remove(this.apiService); } return (A) this;
  }
  public boolean hasApiService() {
    return this.apiService != null;
  }
  public ApiServiceNested<A> withNewApiService() {
    return new ApiServiceNested(null);
  }
  public ApiServiceNested<A> withNewApiServiceLike(InternalServiceTemplate item) {
    return new ApiServiceNested(item);
  }
  public ApiServiceNested<A> editApiService() {
    return withNewApiServiceLike(java.util.Optional.ofNullable(buildApiService()).orElse(null));
  }
  public ApiServiceNested<A> editOrNewApiService() {
    return withNewApiServiceLike(java.util.Optional.ofNullable(buildApiService()).orElse(new InternalServiceTemplateBuilder().build()));
  }
  public ApiServiceNested<A> editOrNewApiServiceLike(InternalServiceTemplate item) {
    return withNewApiServiceLike(java.util.Optional.ofNullable(buildApiService()).orElse(item));
  }
  public PodDisruptionBudgetTemplate buildPodDisruptionBudget() {
    return this.podDisruptionBudget!=null ?this.podDisruptionBudget.build():null;
  }
  public A withPodDisruptionBudget(PodDisruptionBudgetTemplate podDisruptionBudget) {
    _visitables.get("podDisruptionBudget").remove(this.podDisruptionBudget);
    if (podDisruptionBudget!=null){ this.podDisruptionBudget= new PodDisruptionBudgetTemplateBuilder(podDisruptionBudget); _visitables.get("podDisruptionBudget").add(this.podDisruptionBudget);} else { this.podDisruptionBudget = null; _visitables.get("podDisruptionBudget").remove(this.podDisruptionBudget); } return (A) this;
  }
  public boolean hasPodDisruptionBudget() {
    return this.podDisruptionBudget != null;
  }
  public PodDisruptionBudgetNested<A> withNewPodDisruptionBudget() {
    return new PodDisruptionBudgetNested(null);
  }
  public PodDisruptionBudgetNested<A> withNewPodDisruptionBudgetLike(PodDisruptionBudgetTemplate item) {
    return new PodDisruptionBudgetNested(item);
  }
  public PodDisruptionBudgetNested<A> editPodDisruptionBudget() {
    return withNewPodDisruptionBudgetLike(java.util.Optional.ofNullable(buildPodDisruptionBudget()).orElse(null));
  }
  public PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudget() {
    return withNewPodDisruptionBudgetLike(java.util.Optional.ofNullable(buildPodDisruptionBudget()).orElse(new PodDisruptionBudgetTemplateBuilder().build()));
  }
  public PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudgetLike(PodDisruptionBudgetTemplate item) {
    return withNewPodDisruptionBudgetLike(java.util.Optional.ofNullable(buildPodDisruptionBudget()).orElse(item));
  }
  public ContainerTemplate buildCruiseControlContainer() {
    return this.cruiseControlContainer!=null ?this.cruiseControlContainer.build():null;
  }
  public A withCruiseControlContainer(ContainerTemplate cruiseControlContainer) {
    _visitables.get("cruiseControlContainer").remove(this.cruiseControlContainer);
    if (cruiseControlContainer!=null){ this.cruiseControlContainer= new ContainerTemplateBuilder(cruiseControlContainer); _visitables.get("cruiseControlContainer").add(this.cruiseControlContainer);} else { this.cruiseControlContainer = null; _visitables.get("cruiseControlContainer").remove(this.cruiseControlContainer); } return (A) this;
  }
  public boolean hasCruiseControlContainer() {
    return this.cruiseControlContainer != null;
  }
  public CruiseControlContainerNested<A> withNewCruiseControlContainer() {
    return new CruiseControlContainerNested(null);
  }
  public CruiseControlContainerNested<A> withNewCruiseControlContainerLike(ContainerTemplate item) {
    return new CruiseControlContainerNested(item);
  }
  public CruiseControlContainerNested<A> editCruiseControlContainer() {
    return withNewCruiseControlContainerLike(java.util.Optional.ofNullable(buildCruiseControlContainer()).orElse(null));
  }
  public CruiseControlContainerNested<A> editOrNewCruiseControlContainer() {
    return withNewCruiseControlContainerLike(java.util.Optional.ofNullable(buildCruiseControlContainer()).orElse(new ContainerTemplateBuilder().build()));
  }
  public CruiseControlContainerNested<A> editOrNewCruiseControlContainerLike(ContainerTemplate item) {
    return withNewCruiseControlContainerLike(java.util.Optional.ofNullable(buildCruiseControlContainer()).orElse(item));
  }
  public ContainerTemplate buildTlsSidecarContainer() {
    return this.tlsSidecarContainer!=null ?this.tlsSidecarContainer.build():null;
  }
  public A withTlsSidecarContainer(ContainerTemplate tlsSidecarContainer) {
    _visitables.get("tlsSidecarContainer").remove(this.tlsSidecarContainer);
    if (tlsSidecarContainer!=null){ this.tlsSidecarContainer= new ContainerTemplateBuilder(tlsSidecarContainer); _visitables.get("tlsSidecarContainer").add(this.tlsSidecarContainer);} else { this.tlsSidecarContainer = null; _visitables.get("tlsSidecarContainer").remove(this.tlsSidecarContainer); } return (A) this;
  }
  public boolean hasTlsSidecarContainer() {
    return this.tlsSidecarContainer != null;
  }
  public TlsSidecarContainerNested<A> withNewTlsSidecarContainer() {
    return new TlsSidecarContainerNested(null);
  }
  public TlsSidecarContainerNested<A> withNewTlsSidecarContainerLike(ContainerTemplate item) {
    return new TlsSidecarContainerNested(item);
  }
  public TlsSidecarContainerNested<A> editTlsSidecarContainer() {
    return withNewTlsSidecarContainerLike(java.util.Optional.ofNullable(buildTlsSidecarContainer()).orElse(null));
  }
  public TlsSidecarContainerNested<A> editOrNewTlsSidecarContainer() {
    return withNewTlsSidecarContainerLike(java.util.Optional.ofNullable(buildTlsSidecarContainer()).orElse(new ContainerTemplateBuilder().build()));
  }
  public TlsSidecarContainerNested<A> editOrNewTlsSidecarContainerLike(ContainerTemplate item) {
    return withNewTlsSidecarContainerLike(java.util.Optional.ofNullable(buildTlsSidecarContainer()).orElse(item));
  }
  public ResourceTemplate buildServiceAccount() {
    return this.serviceAccount!=null ?this.serviceAccount.build():null;
  }
  public A withServiceAccount(ResourceTemplate serviceAccount) {
    _visitables.get("serviceAccount").remove(this.serviceAccount);
    if (serviceAccount!=null){ this.serviceAccount= new ResourceTemplateBuilder(serviceAccount); _visitables.get("serviceAccount").add(this.serviceAccount);} else { this.serviceAccount = null; _visitables.get("serviceAccount").remove(this.serviceAccount); } return (A) this;
  }
  public boolean hasServiceAccount() {
    return this.serviceAccount != null;
  }
  public ServiceAccountNested<A> withNewServiceAccount() {
    return new ServiceAccountNested(null);
  }
  public ServiceAccountNested<A> withNewServiceAccountLike(ResourceTemplate item) {
    return new ServiceAccountNested(item);
  }
  public ServiceAccountNested<A> editServiceAccount() {
    return withNewServiceAccountLike(java.util.Optional.ofNullable(buildServiceAccount()).orElse(null));
  }
  public ServiceAccountNested<A> editOrNewServiceAccount() {
    return withNewServiceAccountLike(java.util.Optional.ofNullable(buildServiceAccount()).orElse(new ResourceTemplateBuilder().build()));
  }
  public ServiceAccountNested<A> editOrNewServiceAccountLike(ResourceTemplate item) {
    return withNewServiceAccountLike(java.util.Optional.ofNullable(buildServiceAccount()).orElse(item));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CruiseControlTemplateFluent that = (CruiseControlTemplateFluent) o;
    if (!java.util.Objects.equals(deployment, that.deployment)) return false;

    if (!java.util.Objects.equals(pod, that.pod)) return false;

    if (!java.util.Objects.equals(apiService, that.apiService)) return false;

    if (!java.util.Objects.equals(podDisruptionBudget, that.podDisruptionBudget)) return false;

    if (!java.util.Objects.equals(cruiseControlContainer, that.cruiseControlContainer)) return false;

    if (!java.util.Objects.equals(tlsSidecarContainer, that.tlsSidecarContainer)) return false;

    if (!java.util.Objects.equals(serviceAccount, that.serviceAccount)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(deployment,  pod,  apiService,  podDisruptionBudget,  cruiseControlContainer,  tlsSidecarContainer,  serviceAccount,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (deployment != null) { sb.append("deployment:"); sb.append(deployment + ","); }
    if (pod != null) { sb.append("pod:"); sb.append(pod + ","); }
    if (apiService != null) { sb.append("apiService:"); sb.append(apiService + ","); }
    if (podDisruptionBudget != null) { sb.append("podDisruptionBudget:"); sb.append(podDisruptionBudget + ","); }
    if (cruiseControlContainer != null) { sb.append("cruiseControlContainer:"); sb.append(cruiseControlContainer + ","); }
    if (tlsSidecarContainer != null) { sb.append("tlsSidecarContainer:"); sb.append(tlsSidecarContainer + ","); }
    if (serviceAccount != null) { sb.append("serviceAccount:"); sb.append(serviceAccount); }
    sb.append("}");
    return sb.toString();
  }
  public class DeploymentNested<N> extends DeploymentTemplateFluent<DeploymentNested<N>> implements Nested<N>{
    DeploymentNested(DeploymentTemplate item) {
      this.builder = new DeploymentTemplateBuilder(this, item);
    }
    DeploymentTemplateBuilder builder;
    public N and() {
      return (N) CruiseControlTemplateFluent.this.withDeployment(builder.build());
    }
    public N endDeployment() {
      return and();
    }
    
  }
  public class PodNested<N> extends PodTemplateFluent<PodNested<N>> implements Nested<N>{
    PodNested(PodTemplate item) {
      this.builder = new PodTemplateBuilder(this, item);
    }
    PodTemplateBuilder builder;
    public N and() {
      return (N) CruiseControlTemplateFluent.this.withPod(builder.build());
    }
    public N endPod() {
      return and();
    }
    
  }
  public class ApiServiceNested<N> extends InternalServiceTemplateFluent<ApiServiceNested<N>> implements Nested<N>{
    ApiServiceNested(InternalServiceTemplate item) {
      this.builder = new InternalServiceTemplateBuilder(this, item);
    }
    InternalServiceTemplateBuilder builder;
    public N and() {
      return (N) CruiseControlTemplateFluent.this.withApiService(builder.build());
    }
    public N endApiService() {
      return and();
    }
    
  }
  public class PodDisruptionBudgetNested<N> extends PodDisruptionBudgetTemplateFluent<PodDisruptionBudgetNested<N>> implements Nested<N>{
    PodDisruptionBudgetNested(PodDisruptionBudgetTemplate item) {
      this.builder = new PodDisruptionBudgetTemplateBuilder(this, item);
    }
    PodDisruptionBudgetTemplateBuilder builder;
    public N and() {
      return (N) CruiseControlTemplateFluent.this.withPodDisruptionBudget(builder.build());
    }
    public N endPodDisruptionBudget() {
      return and();
    }
    
  }
  public class CruiseControlContainerNested<N> extends ContainerTemplateFluent<CruiseControlContainerNested<N>> implements Nested<N>{
    CruiseControlContainerNested(ContainerTemplate item) {
      this.builder = new ContainerTemplateBuilder(this, item);
    }
    ContainerTemplateBuilder builder;
    public N and() {
      return (N) CruiseControlTemplateFluent.this.withCruiseControlContainer(builder.build());
    }
    public N endCruiseControlContainer() {
      return and();
    }
    
  }
  public class TlsSidecarContainerNested<N> extends ContainerTemplateFluent<TlsSidecarContainerNested<N>> implements Nested<N>{
    TlsSidecarContainerNested(ContainerTemplate item) {
      this.builder = new ContainerTemplateBuilder(this, item);
    }
    ContainerTemplateBuilder builder;
    public N and() {
      return (N) CruiseControlTemplateFluent.this.withTlsSidecarContainer(builder.build());
    }
    public N endTlsSidecarContainer() {
      return and();
    }
    
  }
  public class ServiceAccountNested<N> extends ResourceTemplateFluent<ServiceAccountNested<N>> implements Nested<N>{
    ServiceAccountNested(ResourceTemplate item) {
      this.builder = new ResourceTemplateBuilder(this, item);
    }
    ResourceTemplateBuilder builder;
    public N and() {
      return (N) CruiseControlTemplateFluent.this.withServiceAccount(builder.build());
    }
    public N endServiceAccount() {
      return and();
    }
    
  }
  
}