package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EntityOperatorTemplateBuilder extends EntityOperatorTemplateFluent<EntityOperatorTemplateBuilder> implements VisitableBuilder<EntityOperatorTemplate,EntityOperatorTemplateBuilder>{
  public EntityOperatorTemplateBuilder() {
    this(false);
  }
  public EntityOperatorTemplateBuilder(Boolean validationEnabled) {
    this(new EntityOperatorTemplate(), validationEnabled);
  }
  public EntityOperatorTemplateBuilder(EntityOperatorTemplateFluent<?> fluent) {
    this(fluent, false);
  }
  public EntityOperatorTemplateBuilder(EntityOperatorTemplateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EntityOperatorTemplate(), validationEnabled);
  }
  public EntityOperatorTemplateBuilder(EntityOperatorTemplateFluent<?> fluent,EntityOperatorTemplate instance) {
    this(fluent, instance, false);
  }
  public EntityOperatorTemplateBuilder(EntityOperatorTemplateFluent<?> fluent,EntityOperatorTemplate instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new EntityOperatorTemplate());

    if (instance != null) {
      fluent.withDeployment(instance.getDeployment());
      fluent.withPod(instance.getPod());
      fluent.withEntityOperatorRole(instance.getEntityOperatorRole());
      fluent.withTopicOperatorRoleBinding(instance.getTopicOperatorRoleBinding());
      fluent.withUserOperatorRoleBinding(instance.getUserOperatorRoleBinding());
      fluent.withTopicOperatorContainer(instance.getTopicOperatorContainer());
      fluent.withUserOperatorContainer(instance.getUserOperatorContainer());
      fluent.withTlsSidecarContainer(instance.getTlsSidecarContainer());
      fluent.withServiceAccount(instance.getServiceAccount());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EntityOperatorTemplateBuilder(EntityOperatorTemplate instance) {
    this(instance,false);
  }
  public EntityOperatorTemplateBuilder(EntityOperatorTemplate instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new EntityOperatorTemplate());

    if (instance != null) {
      this.withDeployment(instance.getDeployment());
      this.withPod(instance.getPod());
      this.withEntityOperatorRole(instance.getEntityOperatorRole());
      this.withTopicOperatorRoleBinding(instance.getTopicOperatorRoleBinding());
      this.withUserOperatorRoleBinding(instance.getUserOperatorRoleBinding());
      this.withTopicOperatorContainer(instance.getTopicOperatorContainer());
      this.withUserOperatorContainer(instance.getUserOperatorContainer());
      this.withTlsSidecarContainer(instance.getTlsSidecarContainer());
      this.withServiceAccount(instance.getServiceAccount());
    }
    this.validationEnabled = validationEnabled; 
  }
  EntityOperatorTemplateFluent<?> fluent;
  Boolean validationEnabled;
  public EntityOperatorTemplate build() {
    EntityOperatorTemplate buildable = new EntityOperatorTemplate();
    buildable.setDeployment(fluent.buildDeployment());
    buildable.setPod(fluent.buildPod());
    buildable.setEntityOperatorRole(fluent.buildEntityOperatorRole());
    buildable.setTopicOperatorRoleBinding(fluent.buildTopicOperatorRoleBinding());
    buildable.setUserOperatorRoleBinding(fluent.buildUserOperatorRoleBinding());
    buildable.setTopicOperatorContainer(fluent.buildTopicOperatorContainer());
    buildable.setUserOperatorContainer(fluent.buildUserOperatorContainer());
    buildable.setTlsSidecarContainer(fluent.buildTlsSidecarContainer());
    buildable.setServiceAccount(fluent.buildServiceAccount());
    return buildable;
  }
  
}