package io.strimzi.api.kafka.model.template;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class EntityOperatorTemplateFluent<A extends EntityOperatorTemplateFluent<A>> extends BaseFluent<A>{
  public EntityOperatorTemplateFluent() {
  }
  public EntityOperatorTemplateFluent(EntityOperatorTemplate instance) {
    instance = (instance != null ? instance : new EntityOperatorTemplate());

    if (instance != null) {
      this.withDeployment(instance.getDeployment());
      this.withPod(instance.getPod());
      this.withEntityOperatorRole(instance.getEntityOperatorRole());
      this.withTopicOperatorRoleBinding(instance.getTopicOperatorRoleBinding());
      this.withUserOperatorRoleBinding(instance.getUserOperatorRoleBinding());
      this.withTopicOperatorContainer(instance.getTopicOperatorContainer());
      this.withUserOperatorContainer(instance.getUserOperatorContainer());
      this.withTlsSidecarContainer(instance.getTlsSidecarContainer());
      this.withServiceAccount(instance.getServiceAccount());
    }
  }
  private DeploymentTemplateBuilder deployment;
  private PodTemplateBuilder pod;
  private ResourceTemplateBuilder entityOperatorRole;
  private ResourceTemplateBuilder topicOperatorRoleBinding;
  private ResourceTemplateBuilder userOperatorRoleBinding;
  private ContainerTemplateBuilder topicOperatorContainer;
  private ContainerTemplateBuilder userOperatorContainer;
  private ContainerTemplateBuilder tlsSidecarContainer;
  private ResourceTemplateBuilder serviceAccount;
  public DeploymentTemplate buildDeployment() {
    return this.deployment!=null ?this.deployment.build():null;
  }
  public A withDeployment(DeploymentTemplate deployment) {
    _visitables.get("deployment").remove(this.deployment);
    if (deployment!=null){ this.deployment= new DeploymentTemplateBuilder(deployment); _visitables.get("deployment").add(this.deployment);} else { this.deployment = null; _visitables.get("deployment").remove(this.deployment); } return (A) this;
  }
  public boolean hasDeployment() {
    return this.deployment != null;
  }
  public DeploymentNested<A> withNewDeployment() {
    return new DeploymentNested(null);
  }
  public DeploymentNested<A> withNewDeploymentLike(DeploymentTemplate item) {
    return new DeploymentNested(item);
  }
  public DeploymentNested<A> editDeployment() {
    return withNewDeploymentLike(java.util.Optional.ofNullable(buildDeployment()).orElse(null));
  }
  public DeploymentNested<A> editOrNewDeployment() {
    return withNewDeploymentLike(java.util.Optional.ofNullable(buildDeployment()).orElse(new DeploymentTemplateBuilder().build()));
  }
  public DeploymentNested<A> editOrNewDeploymentLike(DeploymentTemplate item) {
    return withNewDeploymentLike(java.util.Optional.ofNullable(buildDeployment()).orElse(item));
  }
  public PodTemplate buildPod() {
    return this.pod!=null ?this.pod.build():null;
  }
  public A withPod(PodTemplate pod) {
    _visitables.get("pod").remove(this.pod);
    if (pod!=null){ this.pod= new PodTemplateBuilder(pod); _visitables.get("pod").add(this.pod);} else { this.pod = null; _visitables.get("pod").remove(this.pod); } return (A) this;
  }
  public boolean hasPod() {
    return this.pod != null;
  }
  public PodNested<A> withNewPod() {
    return new PodNested(null);
  }
  public PodNested<A> withNewPodLike(PodTemplate item) {
    return new PodNested(item);
  }
  public PodNested<A> editPod() {
    return withNewPodLike(java.util.Optional.ofNullable(buildPod()).orElse(null));
  }
  public PodNested<A> editOrNewPod() {
    return withNewPodLike(java.util.Optional.ofNullable(buildPod()).orElse(new PodTemplateBuilder().build()));
  }
  public PodNested<A> editOrNewPodLike(PodTemplate item) {
    return withNewPodLike(java.util.Optional.ofNullable(buildPod()).orElse(item));
  }
  public ResourceTemplate buildEntityOperatorRole() {
    return this.entityOperatorRole!=null ?this.entityOperatorRole.build():null;
  }
  public A withEntityOperatorRole(ResourceTemplate entityOperatorRole) {
    _visitables.get("entityOperatorRole").remove(this.entityOperatorRole);
    if (entityOperatorRole!=null){ this.entityOperatorRole= new ResourceTemplateBuilder(entityOperatorRole); _visitables.get("entityOperatorRole").add(this.entityOperatorRole);} else { this.entityOperatorRole = null; _visitables.get("entityOperatorRole").remove(this.entityOperatorRole); } return (A) this;
  }
  public boolean hasEntityOperatorRole() {
    return this.entityOperatorRole != null;
  }
  public EntityOperatorRoleNested<A> withNewEntityOperatorRole() {
    return new EntityOperatorRoleNested(null);
  }
  public EntityOperatorRoleNested<A> withNewEntityOperatorRoleLike(ResourceTemplate item) {
    return new EntityOperatorRoleNested(item);
  }
  public EntityOperatorRoleNested<A> editEntityOperatorRole() {
    return withNewEntityOperatorRoleLike(java.util.Optional.ofNullable(buildEntityOperatorRole()).orElse(null));
  }
  public EntityOperatorRoleNested<A> editOrNewEntityOperatorRole() {
    return withNewEntityOperatorRoleLike(java.util.Optional.ofNullable(buildEntityOperatorRole()).orElse(new ResourceTemplateBuilder().build()));
  }
  public EntityOperatorRoleNested<A> editOrNewEntityOperatorRoleLike(ResourceTemplate item) {
    return withNewEntityOperatorRoleLike(java.util.Optional.ofNullable(buildEntityOperatorRole()).orElse(item));
  }
  public ResourceTemplate buildTopicOperatorRoleBinding() {
    return this.topicOperatorRoleBinding!=null ?this.topicOperatorRoleBinding.build():null;
  }
  public A withTopicOperatorRoleBinding(ResourceTemplate topicOperatorRoleBinding) {
    _visitables.get("topicOperatorRoleBinding").remove(this.topicOperatorRoleBinding);
    if (topicOperatorRoleBinding!=null){ this.topicOperatorRoleBinding= new ResourceTemplateBuilder(topicOperatorRoleBinding); _visitables.get("topicOperatorRoleBinding").add(this.topicOperatorRoleBinding);} else { this.topicOperatorRoleBinding = null; _visitables.get("topicOperatorRoleBinding").remove(this.topicOperatorRoleBinding); } return (A) this;
  }
  public boolean hasTopicOperatorRoleBinding() {
    return this.topicOperatorRoleBinding != null;
  }
  public TopicOperatorRoleBindingNested<A> withNewTopicOperatorRoleBinding() {
    return new TopicOperatorRoleBindingNested(null);
  }
  public TopicOperatorRoleBindingNested<A> withNewTopicOperatorRoleBindingLike(ResourceTemplate item) {
    return new TopicOperatorRoleBindingNested(item);
  }
  public TopicOperatorRoleBindingNested<A> editTopicOperatorRoleBinding() {
    return withNewTopicOperatorRoleBindingLike(java.util.Optional.ofNullable(buildTopicOperatorRoleBinding()).orElse(null));
  }
  public TopicOperatorRoleBindingNested<A> editOrNewTopicOperatorRoleBinding() {
    return withNewTopicOperatorRoleBindingLike(java.util.Optional.ofNullable(buildTopicOperatorRoleBinding()).orElse(new ResourceTemplateBuilder().build()));
  }
  public TopicOperatorRoleBindingNested<A> editOrNewTopicOperatorRoleBindingLike(ResourceTemplate item) {
    return withNewTopicOperatorRoleBindingLike(java.util.Optional.ofNullable(buildTopicOperatorRoleBinding()).orElse(item));
  }
  public ResourceTemplate buildUserOperatorRoleBinding() {
    return this.userOperatorRoleBinding!=null ?this.userOperatorRoleBinding.build():null;
  }
  public A withUserOperatorRoleBinding(ResourceTemplate userOperatorRoleBinding) {
    _visitables.get("userOperatorRoleBinding").remove(this.userOperatorRoleBinding);
    if (userOperatorRoleBinding!=null){ this.userOperatorRoleBinding= new ResourceTemplateBuilder(userOperatorRoleBinding); _visitables.get("userOperatorRoleBinding").add(this.userOperatorRoleBinding);} else { this.userOperatorRoleBinding = null; _visitables.get("userOperatorRoleBinding").remove(this.userOperatorRoleBinding); } return (A) this;
  }
  public boolean hasUserOperatorRoleBinding() {
    return this.userOperatorRoleBinding != null;
  }
  public UserOperatorRoleBindingNested<A> withNewUserOperatorRoleBinding() {
    return new UserOperatorRoleBindingNested(null);
  }
  public UserOperatorRoleBindingNested<A> withNewUserOperatorRoleBindingLike(ResourceTemplate item) {
    return new UserOperatorRoleBindingNested(item);
  }
  public UserOperatorRoleBindingNested<A> editUserOperatorRoleBinding() {
    return withNewUserOperatorRoleBindingLike(java.util.Optional.ofNullable(buildUserOperatorRoleBinding()).orElse(null));
  }
  public UserOperatorRoleBindingNested<A> editOrNewUserOperatorRoleBinding() {
    return withNewUserOperatorRoleBindingLike(java.util.Optional.ofNullable(buildUserOperatorRoleBinding()).orElse(new ResourceTemplateBuilder().build()));
  }
  public UserOperatorRoleBindingNested<A> editOrNewUserOperatorRoleBindingLike(ResourceTemplate item) {
    return withNewUserOperatorRoleBindingLike(java.util.Optional.ofNullable(buildUserOperatorRoleBinding()).orElse(item));
  }
  public ContainerTemplate buildTopicOperatorContainer() {
    return this.topicOperatorContainer!=null ?this.topicOperatorContainer.build():null;
  }
  public A withTopicOperatorContainer(ContainerTemplate topicOperatorContainer) {
    _visitables.get("topicOperatorContainer").remove(this.topicOperatorContainer);
    if (topicOperatorContainer!=null){ this.topicOperatorContainer= new ContainerTemplateBuilder(topicOperatorContainer); _visitables.get("topicOperatorContainer").add(this.topicOperatorContainer);} else { this.topicOperatorContainer = null; _visitables.get("topicOperatorContainer").remove(this.topicOperatorContainer); } return (A) this;
  }
  public boolean hasTopicOperatorContainer() {
    return this.topicOperatorContainer != null;
  }
  public TopicOperatorContainerNested<A> withNewTopicOperatorContainer() {
    return new TopicOperatorContainerNested(null);
  }
  public TopicOperatorContainerNested<A> withNewTopicOperatorContainerLike(ContainerTemplate item) {
    return new TopicOperatorContainerNested(item);
  }
  public TopicOperatorContainerNested<A> editTopicOperatorContainer() {
    return withNewTopicOperatorContainerLike(java.util.Optional.ofNullable(buildTopicOperatorContainer()).orElse(null));
  }
  public TopicOperatorContainerNested<A> editOrNewTopicOperatorContainer() {
    return withNewTopicOperatorContainerLike(java.util.Optional.ofNullable(buildTopicOperatorContainer()).orElse(new ContainerTemplateBuilder().build()));
  }
  public TopicOperatorContainerNested<A> editOrNewTopicOperatorContainerLike(ContainerTemplate item) {
    return withNewTopicOperatorContainerLike(java.util.Optional.ofNullable(buildTopicOperatorContainer()).orElse(item));
  }
  public ContainerTemplate buildUserOperatorContainer() {
    return this.userOperatorContainer!=null ?this.userOperatorContainer.build():null;
  }
  public A withUserOperatorContainer(ContainerTemplate userOperatorContainer) {
    _visitables.get("userOperatorContainer").remove(this.userOperatorContainer);
    if (userOperatorContainer!=null){ this.userOperatorContainer= new ContainerTemplateBuilder(userOperatorContainer); _visitables.get("userOperatorContainer").add(this.userOperatorContainer);} else { this.userOperatorContainer = null; _visitables.get("userOperatorContainer").remove(this.userOperatorContainer); } return (A) this;
  }
  public boolean hasUserOperatorContainer() {
    return this.userOperatorContainer != null;
  }
  public UserOperatorContainerNested<A> withNewUserOperatorContainer() {
    return new UserOperatorContainerNested(null);
  }
  public UserOperatorContainerNested<A> withNewUserOperatorContainerLike(ContainerTemplate item) {
    return new UserOperatorContainerNested(item);
  }
  public UserOperatorContainerNested<A> editUserOperatorContainer() {
    return withNewUserOperatorContainerLike(java.util.Optional.ofNullable(buildUserOperatorContainer()).orElse(null));
  }
  public UserOperatorContainerNested<A> editOrNewUserOperatorContainer() {
    return withNewUserOperatorContainerLike(java.util.Optional.ofNullable(buildUserOperatorContainer()).orElse(new ContainerTemplateBuilder().build()));
  }
  public UserOperatorContainerNested<A> editOrNewUserOperatorContainerLike(ContainerTemplate item) {
    return withNewUserOperatorContainerLike(java.util.Optional.ofNullable(buildUserOperatorContainer()).orElse(item));
  }
  public ContainerTemplate buildTlsSidecarContainer() {
    return this.tlsSidecarContainer!=null ?this.tlsSidecarContainer.build():null;
  }
  public A withTlsSidecarContainer(ContainerTemplate tlsSidecarContainer) {
    _visitables.get("tlsSidecarContainer").remove(this.tlsSidecarContainer);
    if (tlsSidecarContainer!=null){ this.tlsSidecarContainer= new ContainerTemplateBuilder(tlsSidecarContainer); _visitables.get("tlsSidecarContainer").add(this.tlsSidecarContainer);} else { this.tlsSidecarContainer = null; _visitables.get("tlsSidecarContainer").remove(this.tlsSidecarContainer); } return (A) this;
  }
  public boolean hasTlsSidecarContainer() {
    return this.tlsSidecarContainer != null;
  }
  public TlsSidecarContainerNested<A> withNewTlsSidecarContainer() {
    return new TlsSidecarContainerNested(null);
  }
  public TlsSidecarContainerNested<A> withNewTlsSidecarContainerLike(ContainerTemplate item) {
    return new TlsSidecarContainerNested(item);
  }
  public TlsSidecarContainerNested<A> editTlsSidecarContainer() {
    return withNewTlsSidecarContainerLike(java.util.Optional.ofNullable(buildTlsSidecarContainer()).orElse(null));
  }
  public TlsSidecarContainerNested<A> editOrNewTlsSidecarContainer() {
    return withNewTlsSidecarContainerLike(java.util.Optional.ofNullable(buildTlsSidecarContainer()).orElse(new ContainerTemplateBuilder().build()));
  }
  public TlsSidecarContainerNested<A> editOrNewTlsSidecarContainerLike(ContainerTemplate item) {
    return withNewTlsSidecarContainerLike(java.util.Optional.ofNullable(buildTlsSidecarContainer()).orElse(item));
  }
  public ResourceTemplate buildServiceAccount() {
    return this.serviceAccount!=null ?this.serviceAccount.build():null;
  }
  public A withServiceAccount(ResourceTemplate serviceAccount) {
    _visitables.get("serviceAccount").remove(this.serviceAccount);
    if (serviceAccount!=null){ this.serviceAccount= new ResourceTemplateBuilder(serviceAccount); _visitables.get("serviceAccount").add(this.serviceAccount);} else { this.serviceAccount = null; _visitables.get("serviceAccount").remove(this.serviceAccount); } return (A) this;
  }
  public boolean hasServiceAccount() {
    return this.serviceAccount != null;
  }
  public ServiceAccountNested<A> withNewServiceAccount() {
    return new ServiceAccountNested(null);
  }
  public ServiceAccountNested<A> withNewServiceAccountLike(ResourceTemplate item) {
    return new ServiceAccountNested(item);
  }
  public ServiceAccountNested<A> editServiceAccount() {
    return withNewServiceAccountLike(java.util.Optional.ofNullable(buildServiceAccount()).orElse(null));
  }
  public ServiceAccountNested<A> editOrNewServiceAccount() {
    return withNewServiceAccountLike(java.util.Optional.ofNullable(buildServiceAccount()).orElse(new ResourceTemplateBuilder().build()));
  }
  public ServiceAccountNested<A> editOrNewServiceAccountLike(ResourceTemplate item) {
    return withNewServiceAccountLike(java.util.Optional.ofNullable(buildServiceAccount()).orElse(item));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    EntityOperatorTemplateFluent that = (EntityOperatorTemplateFluent) o;
    if (!java.util.Objects.equals(deployment, that.deployment)) return false;

    if (!java.util.Objects.equals(pod, that.pod)) return false;

    if (!java.util.Objects.equals(entityOperatorRole, that.entityOperatorRole)) return false;

    if (!java.util.Objects.equals(topicOperatorRoleBinding, that.topicOperatorRoleBinding)) return false;

    if (!java.util.Objects.equals(userOperatorRoleBinding, that.userOperatorRoleBinding)) return false;

    if (!java.util.Objects.equals(topicOperatorContainer, that.topicOperatorContainer)) return false;

    if (!java.util.Objects.equals(userOperatorContainer, that.userOperatorContainer)) return false;

    if (!java.util.Objects.equals(tlsSidecarContainer, that.tlsSidecarContainer)) return false;

    if (!java.util.Objects.equals(serviceAccount, that.serviceAccount)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(deployment,  pod,  entityOperatorRole,  topicOperatorRoleBinding,  userOperatorRoleBinding,  topicOperatorContainer,  userOperatorContainer,  tlsSidecarContainer,  serviceAccount,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (deployment != null) { sb.append("deployment:"); sb.append(deployment + ","); }
    if (pod != null) { sb.append("pod:"); sb.append(pod + ","); }
    if (entityOperatorRole != null) { sb.append("entityOperatorRole:"); sb.append(entityOperatorRole + ","); }
    if (topicOperatorRoleBinding != null) { sb.append("topicOperatorRoleBinding:"); sb.append(topicOperatorRoleBinding + ","); }
    if (userOperatorRoleBinding != null) { sb.append("userOperatorRoleBinding:"); sb.append(userOperatorRoleBinding + ","); }
    if (topicOperatorContainer != null) { sb.append("topicOperatorContainer:"); sb.append(topicOperatorContainer + ","); }
    if (userOperatorContainer != null) { sb.append("userOperatorContainer:"); sb.append(userOperatorContainer + ","); }
    if (tlsSidecarContainer != null) { sb.append("tlsSidecarContainer:"); sb.append(tlsSidecarContainer + ","); }
    if (serviceAccount != null) { sb.append("serviceAccount:"); sb.append(serviceAccount); }
    sb.append("}");
    return sb.toString();
  }
  public class DeploymentNested<N> extends DeploymentTemplateFluent<DeploymentNested<N>> implements Nested<N>{
    DeploymentNested(DeploymentTemplate item) {
      this.builder = new DeploymentTemplateBuilder(this, item);
    }
    DeploymentTemplateBuilder builder;
    public N and() {
      return (N) EntityOperatorTemplateFluent.this.withDeployment(builder.build());
    }
    public N endDeployment() {
      return and();
    }
    
  }
  public class PodNested<N> extends PodTemplateFluent<PodNested<N>> implements Nested<N>{
    PodNested(PodTemplate item) {
      this.builder = new PodTemplateBuilder(this, item);
    }
    PodTemplateBuilder builder;
    public N and() {
      return (N) EntityOperatorTemplateFluent.this.withPod(builder.build());
    }
    public N endPod() {
      return and();
    }
    
  }
  public class EntityOperatorRoleNested<N> extends ResourceTemplateFluent<EntityOperatorRoleNested<N>> implements Nested<N>{
    EntityOperatorRoleNested(ResourceTemplate item) {
      this.builder = new ResourceTemplateBuilder(this, item);
    }
    ResourceTemplateBuilder builder;
    public N and() {
      return (N) EntityOperatorTemplateFluent.this.withEntityOperatorRole(builder.build());
    }
    public N endEntityOperatorRole() {
      return and();
    }
    
  }
  public class TopicOperatorRoleBindingNested<N> extends ResourceTemplateFluent<TopicOperatorRoleBindingNested<N>> implements Nested<N>{
    TopicOperatorRoleBindingNested(ResourceTemplate item) {
      this.builder = new ResourceTemplateBuilder(this, item);
    }
    ResourceTemplateBuilder builder;
    public N and() {
      return (N) EntityOperatorTemplateFluent.this.withTopicOperatorRoleBinding(builder.build());
    }
    public N endTopicOperatorRoleBinding() {
      return and();
    }
    
  }
  public class UserOperatorRoleBindingNested<N> extends ResourceTemplateFluent<UserOperatorRoleBindingNested<N>> implements Nested<N>{
    UserOperatorRoleBindingNested(ResourceTemplate item) {
      this.builder = new ResourceTemplateBuilder(this, item);
    }
    ResourceTemplateBuilder builder;
    public N and() {
      return (N) EntityOperatorTemplateFluent.this.withUserOperatorRoleBinding(builder.build());
    }
    public N endUserOperatorRoleBinding() {
      return and();
    }
    
  }
  public class TopicOperatorContainerNested<N> extends ContainerTemplateFluent<TopicOperatorContainerNested<N>> implements Nested<N>{
    TopicOperatorContainerNested(ContainerTemplate item) {
      this.builder = new ContainerTemplateBuilder(this, item);
    }
    ContainerTemplateBuilder builder;
    public N and() {
      return (N) EntityOperatorTemplateFluent.this.withTopicOperatorContainer(builder.build());
    }
    public N endTopicOperatorContainer() {
      return and();
    }
    
  }
  public class UserOperatorContainerNested<N> extends ContainerTemplateFluent<UserOperatorContainerNested<N>> implements Nested<N>{
    UserOperatorContainerNested(ContainerTemplate item) {
      this.builder = new ContainerTemplateBuilder(this, item);
    }
    ContainerTemplateBuilder builder;
    public N and() {
      return (N) EntityOperatorTemplateFluent.this.withUserOperatorContainer(builder.build());
    }
    public N endUserOperatorContainer() {
      return and();
    }
    
  }
  public class TlsSidecarContainerNested<N> extends ContainerTemplateFluent<TlsSidecarContainerNested<N>> implements Nested<N>{
    TlsSidecarContainerNested(ContainerTemplate item) {
      this.builder = new ContainerTemplateBuilder(this, item);
    }
    ContainerTemplateBuilder builder;
    public N and() {
      return (N) EntityOperatorTemplateFluent.this.withTlsSidecarContainer(builder.build());
    }
    public N endTlsSidecarContainer() {
      return and();
    }
    
  }
  public class ServiceAccountNested<N> extends ResourceTemplateFluent<ServiceAccountNested<N>> implements Nested<N>{
    ServiceAccountNested(ResourceTemplate item) {
      this.builder = new ResourceTemplateBuilder(this, item);
    }
    ResourceTemplateBuilder builder;
    public N and() {
      return (N) EntityOperatorTemplateFluent.this.withServiceAccount(builder.build());
    }
    public N endServiceAccount() {
      return and();
    }
    
  }
  
}