package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class InternalServiceTemplateBuilder extends InternalServiceTemplateFluent<InternalServiceTemplateBuilder> implements VisitableBuilder<InternalServiceTemplate,InternalServiceTemplateBuilder>{
  public InternalServiceTemplateBuilder() {
    this(false);
  }
  public InternalServiceTemplateBuilder(Boolean validationEnabled) {
    this(new InternalServiceTemplate(), validationEnabled);
  }
  public InternalServiceTemplateBuilder(InternalServiceTemplateFluent<?> fluent) {
    this(fluent, false);
  }
  public InternalServiceTemplateBuilder(InternalServiceTemplateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new InternalServiceTemplate(), validationEnabled);
  }
  public InternalServiceTemplateBuilder(InternalServiceTemplateFluent<?> fluent,InternalServiceTemplate instance) {
    this(fluent, instance, false);
  }
  public InternalServiceTemplateBuilder(InternalServiceTemplateFluent<?> fluent,InternalServiceTemplate instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new InternalServiceTemplate());

    if (instance != null) {
      fluent.withMetadata(instance.getMetadata());
      fluent.withIpFamilyPolicy(instance.getIpFamilyPolicy());
      fluent.withIpFamilies(instance.getIpFamilies());
    }
    this.validationEnabled = validationEnabled; 
  }
  public InternalServiceTemplateBuilder(InternalServiceTemplate instance) {
    this(instance,false);
  }
  public InternalServiceTemplateBuilder(InternalServiceTemplate instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new InternalServiceTemplate());

    if (instance != null) {
      this.withMetadata(instance.getMetadata());
      this.withIpFamilyPolicy(instance.getIpFamilyPolicy());
      this.withIpFamilies(instance.getIpFamilies());
    }
    this.validationEnabled = validationEnabled; 
  }
  InternalServiceTemplateFluent<?> fluent;
  Boolean validationEnabled;
  public InternalServiceTemplate build() {
    InternalServiceTemplate buildable = new InternalServiceTemplate();
    buildable.setMetadata(fluent.buildMetadata());
    buildable.setIpFamilyPolicy(fluent.getIpFamilyPolicy());
    buildable.setIpFamilies(fluent.getIpFamilies());
    return buildable;
  }
  
}