package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class JmxTransOutputDefinitionTemplateBuilder extends JmxTransOutputDefinitionTemplateFluent<JmxTransOutputDefinitionTemplateBuilder> implements VisitableBuilder<JmxTransOutputDefinitionTemplate,JmxTransOutputDefinitionTemplateBuilder>{
  public JmxTransOutputDefinitionTemplateBuilder() {
    this(false);
  }
  public JmxTransOutputDefinitionTemplateBuilder(Boolean validationEnabled) {
    this(new JmxTransOutputDefinitionTemplate(), validationEnabled);
  }
  public JmxTransOutputDefinitionTemplateBuilder(JmxTransOutputDefinitionTemplateFluent<?> fluent) {
    this(fluent, false);
  }
  public JmxTransOutputDefinitionTemplateBuilder(JmxTransOutputDefinitionTemplateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new JmxTransOutputDefinitionTemplate(), validationEnabled);
  }
  public JmxTransOutputDefinitionTemplateBuilder(JmxTransOutputDefinitionTemplateFluent<?> fluent,JmxTransOutputDefinitionTemplate instance) {
    this(fluent, instance, false);
  }
  public JmxTransOutputDefinitionTemplateBuilder(JmxTransOutputDefinitionTemplateFluent<?> fluent,JmxTransOutputDefinitionTemplate instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new JmxTransOutputDefinitionTemplate());

    if (instance != null) {
      fluent.withOutputType(instance.getOutputType());
      fluent.withHost(instance.getHost());
      fluent.withPort(instance.getPort());
      fluent.withFlushDelayInSeconds(instance.getFlushDelayInSeconds());
      fluent.withName(instance.getName());
      fluent.withTypeNames(instance.getTypeNames());
    }
    this.validationEnabled = validationEnabled; 
  }
  public JmxTransOutputDefinitionTemplateBuilder(JmxTransOutputDefinitionTemplate instance) {
    this(instance,false);
  }
  public JmxTransOutputDefinitionTemplateBuilder(JmxTransOutputDefinitionTemplate instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new JmxTransOutputDefinitionTemplate());

    if (instance != null) {
      this.withOutputType(instance.getOutputType());
      this.withHost(instance.getHost());
      this.withPort(instance.getPort());
      this.withFlushDelayInSeconds(instance.getFlushDelayInSeconds());
      this.withName(instance.getName());
      this.withTypeNames(instance.getTypeNames());
    }
    this.validationEnabled = validationEnabled; 
  }
  JmxTransOutputDefinitionTemplateFluent<?> fluent;
  Boolean validationEnabled;
  public JmxTransOutputDefinitionTemplate build() {
    JmxTransOutputDefinitionTemplate buildable = new JmxTransOutputDefinitionTemplate();
    buildable.setOutputType(fluent.getOutputType());
    buildable.setHost(fluent.getHost());
    buildable.setPort(fluent.getPort());
    buildable.setFlushDelayInSeconds(fluent.getFlushDelayInSeconds());
    buildable.setName(fluent.getName());
    buildable.setTypeNames(fluent.getTypeNames());
    return buildable;
  }
  
}