package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class JmxTransQueryTemplateBuilder extends JmxTransQueryTemplateFluent<JmxTransQueryTemplateBuilder> implements VisitableBuilder<JmxTransQueryTemplate,JmxTransQueryTemplateBuilder>{
  public JmxTransQueryTemplateBuilder() {
    this(false);
  }
  public JmxTransQueryTemplateBuilder(Boolean validationEnabled) {
    this(new JmxTransQueryTemplate(), validationEnabled);
  }
  public JmxTransQueryTemplateBuilder(JmxTransQueryTemplateFluent<?> fluent) {
    this(fluent, false);
  }
  public JmxTransQueryTemplateBuilder(JmxTransQueryTemplateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new JmxTransQueryTemplate(), validationEnabled);
  }
  public JmxTransQueryTemplateBuilder(JmxTransQueryTemplateFluent<?> fluent,JmxTransQueryTemplate instance) {
    this(fluent, instance, false);
  }
  public JmxTransQueryTemplateBuilder(JmxTransQueryTemplateFluent<?> fluent,JmxTransQueryTemplate instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new JmxTransQueryTemplate());

    if (instance != null) {
      fluent.withTargetMBean(instance.getTargetMBean());
      fluent.withAttributes(instance.getAttributes());
      fluent.withOutputs(instance.getOutputs());
    }
    this.validationEnabled = validationEnabled; 
  }
  public JmxTransQueryTemplateBuilder(JmxTransQueryTemplate instance) {
    this(instance,false);
  }
  public JmxTransQueryTemplateBuilder(JmxTransQueryTemplate instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new JmxTransQueryTemplate());

    if (instance != null) {
      this.withTargetMBean(instance.getTargetMBean());
      this.withAttributes(instance.getAttributes());
      this.withOutputs(instance.getOutputs());
    }
    this.validationEnabled = validationEnabled; 
  }
  JmxTransQueryTemplateFluent<?> fluent;
  Boolean validationEnabled;
  public JmxTransQueryTemplate build() {
    JmxTransQueryTemplate buildable = new JmxTransQueryTemplate();
    buildable.setTargetMBean(fluent.getTargetMBean());
    buildable.setAttributes(fluent.getAttributes());
    buildable.setOutputs(fluent.getOutputs());
    return buildable;
  }
  
}