package io.strimzi.api.kafka.model.template;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.function.Predicate;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class JmxTransQueryTemplateFluent<A extends JmxTransQueryTemplateFluent<A>> extends BaseFluent<A>{
  public JmxTransQueryTemplateFluent() {
  }
  public JmxTransQueryTemplateFluent(JmxTransQueryTemplate instance) {
    instance = (instance != null ? instance : new JmxTransQueryTemplate());

    if (instance != null) {
      this.withTargetMBean(instance.getTargetMBean());
      this.withAttributes(instance.getAttributes());
      this.withOutputs(instance.getOutputs());
    }
  }
  private String targetMBean;
  private List<String> attributes;
  private List<String> outputs;
  public String getTargetMBean() {
    return this.targetMBean;
  }
  public A withTargetMBean(String targetMBean) {
    this.targetMBean=targetMBean; return (A) this;
  }
  public boolean hasTargetMBean() {
    return this.targetMBean != null;
  }
  public A addToAttributes(int index,String item) {
    if (this.attributes == null) {this.attributes = new ArrayList<String>();}
    this.attributes.add(index, item);
    return (A)this;
  }
  public A setToAttributes(int index,String item) {
    if (this.attributes == null) {this.attributes = new ArrayList<String>();}
    this.attributes.set(index, item); return (A)this;
  }
  public A addToAttributes(java.lang.String... items) {
    if (this.attributes == null) {this.attributes = new ArrayList<String>();}
    for (String item : items) {this.attributes.add(item);} return (A)this;
  }
  public A addAllToAttributes(Collection<String> items) {
    if (this.attributes == null) {this.attributes = new ArrayList<String>();}
    for (String item : items) {this.attributes.add(item);} return (A)this;
  }
  public A removeFromAttributes(java.lang.String... items) {
    if (this.attributes == null) return (A)this;
    for (String item : items) { this.attributes.remove(item);} return (A)this;
  }
  public A removeAllFromAttributes(Collection<String> items) {
    if (this.attributes == null) return (A)this;
    for (String item : items) { this.attributes.remove(item);} return (A)this;
  }
  public List<String> getAttributes() {
    return this.attributes;
  }
  public String getAttribute(int index) {
    return this.attributes.get(index);
  }
  public String getFirstAttribute() {
    return this.attributes.get(0);
  }
  public String getLastAttribute() {
    return this.attributes.get(attributes.size() - 1);
  }
  public String getMatchingAttribute(Predicate<String> predicate) {
    for (String item: attributes) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingAttribute(Predicate<String> predicate) {
    for (String item: attributes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAttributes(List<String> attributes) {
    if (attributes != null) {this.attributes = new ArrayList(); for (String item : attributes){this.addToAttributes(item);}} else { this.attributes = null;} return (A) this;
  }
  public A withAttributes(java.lang.String... attributes) {
    if (this.attributes != null) {this.attributes.clear(); _visitables.remove("attributes"); }
    if (attributes != null) {for (String item :attributes){ this.addToAttributes(item);}} return (A) this;
  }
  public boolean hasAttributes() {
    return attributes != null && !attributes.isEmpty();
  }
  public A addToOutputs(int index,String item) {
    if (this.outputs == null) {this.outputs = new ArrayList<String>();}
    this.outputs.add(index, item);
    return (A)this;
  }
  public A setToOutputs(int index,String item) {
    if (this.outputs == null) {this.outputs = new ArrayList<String>();}
    this.outputs.set(index, item); return (A)this;
  }
  public A addToOutputs(java.lang.String... items) {
    if (this.outputs == null) {this.outputs = new ArrayList<String>();}
    for (String item : items) {this.outputs.add(item);} return (A)this;
  }
  public A addAllToOutputs(Collection<String> items) {
    if (this.outputs == null) {this.outputs = new ArrayList<String>();}
    for (String item : items) {this.outputs.add(item);} return (A)this;
  }
  public A removeFromOutputs(java.lang.String... items) {
    if (this.outputs == null) return (A)this;
    for (String item : items) { this.outputs.remove(item);} return (A)this;
  }
  public A removeAllFromOutputs(Collection<String> items) {
    if (this.outputs == null) return (A)this;
    for (String item : items) { this.outputs.remove(item);} return (A)this;
  }
  public List<String> getOutputs() {
    return this.outputs;
  }
  public String getOutput(int index) {
    return this.outputs.get(index);
  }
  public String getFirstOutput() {
    return this.outputs.get(0);
  }
  public String getLastOutput() {
    return this.outputs.get(outputs.size() - 1);
  }
  public String getMatchingOutput(Predicate<String> predicate) {
    for (String item: outputs) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingOutput(Predicate<String> predicate) {
    for (String item: outputs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withOutputs(List<String> outputs) {
    if (outputs != null) {this.outputs = new ArrayList(); for (String item : outputs){this.addToOutputs(item);}} else { this.outputs = null;} return (A) this;
  }
  public A withOutputs(java.lang.String... outputs) {
    if (this.outputs != null) {this.outputs.clear(); _visitables.remove("outputs"); }
    if (outputs != null) {for (String item :outputs){ this.addToOutputs(item);}} return (A) this;
  }
  public boolean hasOutputs() {
    return outputs != null && !outputs.isEmpty();
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    JmxTransQueryTemplateFluent that = (JmxTransQueryTemplateFluent) o;
    if (!java.util.Objects.equals(targetMBean, that.targetMBean)) return false;

    if (!java.util.Objects.equals(attributes, that.attributes)) return false;

    if (!java.util.Objects.equals(outputs, that.outputs)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(targetMBean,  attributes,  outputs,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (targetMBean != null) { sb.append("targetMBean:"); sb.append(targetMBean + ","); }
    if (attributes != null && !attributes.isEmpty()) { sb.append("attributes:"); sb.append(attributes + ","); }
    if (outputs != null && !outputs.isEmpty()) { sb.append("outputs:"); sb.append(outputs); }
    sb.append("}");
    return sb.toString();
  }
  
}