package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaBridgeTemplateBuilder extends KafkaBridgeTemplateFluent<KafkaBridgeTemplateBuilder> implements VisitableBuilder<KafkaBridgeTemplate,KafkaBridgeTemplateBuilder>{
  public KafkaBridgeTemplateBuilder() {
    this(false);
  }
  public KafkaBridgeTemplateBuilder(Boolean validationEnabled) {
    this(new KafkaBridgeTemplate(), validationEnabled);
  }
  public KafkaBridgeTemplateBuilder(KafkaBridgeTemplateFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaBridgeTemplateBuilder(KafkaBridgeTemplateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaBridgeTemplate(), validationEnabled);
  }
  public KafkaBridgeTemplateBuilder(KafkaBridgeTemplateFluent<?> fluent,KafkaBridgeTemplate instance) {
    this(fluent, instance, false);
  }
  public KafkaBridgeTemplateBuilder(KafkaBridgeTemplateFluent<?> fluent,KafkaBridgeTemplate instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaBridgeTemplate());

    if (instance != null) {
      fluent.withDeployment(instance.getDeployment());
      fluent.withPod(instance.getPod());
      fluent.withApiService(instance.getApiService());
      fluent.withPodDisruptionBudget(instance.getPodDisruptionBudget());
      fluent.withBridgeContainer(instance.getBridgeContainer());
      fluent.withInitContainer(instance.getInitContainer());
      fluent.withClusterRoleBinding(instance.getClusterRoleBinding());
      fluent.withServiceAccount(instance.getServiceAccount());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaBridgeTemplateBuilder(KafkaBridgeTemplate instance) {
    this(instance,false);
  }
  public KafkaBridgeTemplateBuilder(KafkaBridgeTemplate instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaBridgeTemplate());

    if (instance != null) {
      this.withDeployment(instance.getDeployment());
      this.withPod(instance.getPod());
      this.withApiService(instance.getApiService());
      this.withPodDisruptionBudget(instance.getPodDisruptionBudget());
      this.withBridgeContainer(instance.getBridgeContainer());
      this.withInitContainer(instance.getInitContainer());
      this.withClusterRoleBinding(instance.getClusterRoleBinding());
      this.withServiceAccount(instance.getServiceAccount());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaBridgeTemplateFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaBridgeTemplate build() {
    KafkaBridgeTemplate buildable = new KafkaBridgeTemplate();
    buildable.setDeployment(fluent.buildDeployment());
    buildable.setPod(fluent.buildPod());
    buildable.setApiService(fluent.buildApiService());
    buildable.setPodDisruptionBudget(fluent.buildPodDisruptionBudget());
    buildable.setBridgeContainer(fluent.buildBridgeContainer());
    buildable.setInitContainer(fluent.buildInitContainer());
    buildable.setClusterRoleBinding(fluent.buildClusterRoleBinding());
    buildable.setServiceAccount(fluent.buildServiceAccount());
    return buildable;
  }
  
}