package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaConnectTemplateBuilder extends KafkaConnectTemplateFluent<KafkaConnectTemplateBuilder> implements VisitableBuilder<KafkaConnectTemplate,KafkaConnectTemplateBuilder>{
  public KafkaConnectTemplateBuilder() {
    this(false);
  }
  public KafkaConnectTemplateBuilder(Boolean validationEnabled) {
    this(new KafkaConnectTemplate(), validationEnabled);
  }
  public KafkaConnectTemplateBuilder(KafkaConnectTemplateFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaConnectTemplateBuilder(KafkaConnectTemplateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaConnectTemplate(), validationEnabled);
  }
  public KafkaConnectTemplateBuilder(KafkaConnectTemplateFluent<?> fluent,KafkaConnectTemplate instance) {
    this(fluent, instance, false);
  }
  public KafkaConnectTemplateBuilder(KafkaConnectTemplateFluent<?> fluent,KafkaConnectTemplate instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaConnectTemplate());

    if (instance != null) {
      fluent.withDeployment(instance.getDeployment());
      fluent.withPodSet(instance.getPodSet());
      fluent.withPod(instance.getPod());
      fluent.withBuildPod(instance.getBuildPod());
      fluent.withApiService(instance.getApiService());
      fluent.withHeadlessService(instance.getHeadlessService());
      fluent.withPodDisruptionBudget(instance.getPodDisruptionBudget());
      fluent.withConnectContainer(instance.getConnectContainer());
      fluent.withInitContainer(instance.getInitContainer());
      fluent.withBuildContainer(instance.getBuildContainer());
      fluent.withBuildConfig(instance.getBuildConfig());
      fluent.withClusterRoleBinding(instance.getClusterRoleBinding());
      fluent.withServiceAccount(instance.getServiceAccount());
      fluent.withBuildServiceAccount(instance.getBuildServiceAccount());
      fluent.withJmxSecret(instance.getJmxSecret());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaConnectTemplateBuilder(KafkaConnectTemplate instance) {
    this(instance,false);
  }
  public KafkaConnectTemplateBuilder(KafkaConnectTemplate instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaConnectTemplate());

    if (instance != null) {
      this.withDeployment(instance.getDeployment());
      this.withPodSet(instance.getPodSet());
      this.withPod(instance.getPod());
      this.withBuildPod(instance.getBuildPod());
      this.withApiService(instance.getApiService());
      this.withHeadlessService(instance.getHeadlessService());
      this.withPodDisruptionBudget(instance.getPodDisruptionBudget());
      this.withConnectContainer(instance.getConnectContainer());
      this.withInitContainer(instance.getInitContainer());
      this.withBuildContainer(instance.getBuildContainer());
      this.withBuildConfig(instance.getBuildConfig());
      this.withClusterRoleBinding(instance.getClusterRoleBinding());
      this.withServiceAccount(instance.getServiceAccount());
      this.withBuildServiceAccount(instance.getBuildServiceAccount());
      this.withJmxSecret(instance.getJmxSecret());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaConnectTemplateFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaConnectTemplate build() {
    KafkaConnectTemplate buildable = new KafkaConnectTemplate();
    buildable.setDeployment(fluent.buildDeployment());
    buildable.setPodSet(fluent.buildPodSet());
    buildable.setPod(fluent.buildPod());
    buildable.setBuildPod(fluent.buildBuildPod());
    buildable.setApiService(fluent.buildApiService());
    buildable.setHeadlessService(fluent.buildHeadlessService());
    buildable.setPodDisruptionBudget(fluent.buildPodDisruptionBudget());
    buildable.setConnectContainer(fluent.buildConnectContainer());
    buildable.setInitContainer(fluent.buildInitContainer());
    buildable.setBuildContainer(fluent.buildBuildContainer());
    buildable.setBuildConfig(fluent.buildBuildConfig());
    buildable.setClusterRoleBinding(fluent.buildClusterRoleBinding());
    buildable.setServiceAccount(fluent.buildServiceAccount());
    buildable.setBuildServiceAccount(fluent.buildBuildServiceAccount());
    buildable.setJmxSecret(fluent.buildJmxSecret());
    return buildable;
  }
  
}