package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaMirrorMakerTemplateBuilder extends KafkaMirrorMakerTemplateFluent<KafkaMirrorMakerTemplateBuilder> implements VisitableBuilder<KafkaMirrorMakerTemplate,KafkaMirrorMakerTemplateBuilder>{
  public KafkaMirrorMakerTemplateBuilder() {
    this(false);
  }
  public KafkaMirrorMakerTemplateBuilder(Boolean validationEnabled) {
    this(new KafkaMirrorMakerTemplate(), validationEnabled);
  }
  public KafkaMirrorMakerTemplateBuilder(KafkaMirrorMakerTemplateFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaMirrorMakerTemplateBuilder(KafkaMirrorMakerTemplateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaMirrorMakerTemplate(), validationEnabled);
  }
  public KafkaMirrorMakerTemplateBuilder(KafkaMirrorMakerTemplateFluent<?> fluent,KafkaMirrorMakerTemplate instance) {
    this(fluent, instance, false);
  }
  public KafkaMirrorMakerTemplateBuilder(KafkaMirrorMakerTemplateFluent<?> fluent,KafkaMirrorMakerTemplate instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaMirrorMakerTemplate());

    if (instance != null) {
      fluent.withDeployment(instance.getDeployment());
      fluent.withPod(instance.getPod());
      fluent.withPodDisruptionBudget(instance.getPodDisruptionBudget());
      fluent.withMirrorMakerContainer(instance.getMirrorMakerContainer());
      fluent.withServiceAccount(instance.getServiceAccount());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaMirrorMakerTemplateBuilder(KafkaMirrorMakerTemplate instance) {
    this(instance,false);
  }
  public KafkaMirrorMakerTemplateBuilder(KafkaMirrorMakerTemplate instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaMirrorMakerTemplate());

    if (instance != null) {
      this.withDeployment(instance.getDeployment());
      this.withPod(instance.getPod());
      this.withPodDisruptionBudget(instance.getPodDisruptionBudget());
      this.withMirrorMakerContainer(instance.getMirrorMakerContainer());
      this.withServiceAccount(instance.getServiceAccount());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaMirrorMakerTemplateFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaMirrorMakerTemplate build() {
    KafkaMirrorMakerTemplate buildable = new KafkaMirrorMakerTemplate();
    buildable.setDeployment(fluent.buildDeployment());
    buildable.setPod(fluent.buildPod());
    buildable.setPodDisruptionBudget(fluent.buildPodDisruptionBudget());
    buildable.setMirrorMakerContainer(fluent.buildMirrorMakerContainer());
    buildable.setServiceAccount(fluent.buildServiceAccount());
    return buildable;
  }
  
}