package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaUserTemplateBuilder extends KafkaUserTemplateFluent<KafkaUserTemplateBuilder> implements VisitableBuilder<KafkaUserTemplate,KafkaUserTemplateBuilder>{
  public KafkaUserTemplateBuilder() {
    this(false);
  }
  public KafkaUserTemplateBuilder(Boolean validationEnabled) {
    this(new KafkaUserTemplate(), validationEnabled);
  }
  public KafkaUserTemplateBuilder(KafkaUserTemplateFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaUserTemplateBuilder(KafkaUserTemplateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaUserTemplate(), validationEnabled);
  }
  public KafkaUserTemplateBuilder(KafkaUserTemplateFluent<?> fluent,KafkaUserTemplate instance) {
    this(fluent, instance, false);
  }
  public KafkaUserTemplateBuilder(KafkaUserTemplateFluent<?> fluent,KafkaUserTemplate instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaUserTemplate());

    if (instance != null) {
      fluent.withSecret(instance.getSecret());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaUserTemplateBuilder(KafkaUserTemplate instance) {
    this(instance,false);
  }
  public KafkaUserTemplateBuilder(KafkaUserTemplate instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaUserTemplate());

    if (instance != null) {
      this.withSecret(instance.getSecret());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaUserTemplateFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaUserTemplate build() {
    KafkaUserTemplate buildable = new KafkaUserTemplate();
    buildable.setSecret(fluent.buildSecret());
    return buildable;
  }
  
}