package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MetadataTemplateBuilder extends MetadataTemplateFluent<MetadataTemplateBuilder> implements VisitableBuilder<MetadataTemplate,MetadataTemplateBuilder>{
  public MetadataTemplateBuilder() {
    this(false);
  }
  public MetadataTemplateBuilder(Boolean validationEnabled) {
    this(new MetadataTemplate(), validationEnabled);
  }
  public MetadataTemplateBuilder(MetadataTemplateFluent<?> fluent) {
    this(fluent, false);
  }
  public MetadataTemplateBuilder(MetadataTemplateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MetadataTemplate(), validationEnabled);
  }
  public MetadataTemplateBuilder(MetadataTemplateFluent<?> fluent,MetadataTemplate instance) {
    this(fluent, instance, false);
  }
  public MetadataTemplateBuilder(MetadataTemplateFluent<?> fluent,MetadataTemplate instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new MetadataTemplate());

    if (instance != null) {
      fluent.withLabels(instance.getLabels());
      fluent.withAnnotations(instance.getAnnotations());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MetadataTemplateBuilder(MetadataTemplate instance) {
    this(instance,false);
  }
  public MetadataTemplateBuilder(MetadataTemplate instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new MetadataTemplate());

    if (instance != null) {
      this.withLabels(instance.getLabels());
      this.withAnnotations(instance.getAnnotations());
    }
    this.validationEnabled = validationEnabled; 
  }
  MetadataTemplateFluent<?> fluent;
  Boolean validationEnabled;
  public MetadataTemplate build() {
    MetadataTemplate buildable = new MetadataTemplate();
    buildable.setLabels(fluent.getLabels());
    buildable.setAnnotations(fluent.getAnnotations());
    return buildable;
  }
  
}