package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodDisruptionBudgetTemplateBuilder extends PodDisruptionBudgetTemplateFluent<PodDisruptionBudgetTemplateBuilder> implements VisitableBuilder<PodDisruptionBudgetTemplate,PodDisruptionBudgetTemplateBuilder>{
  public PodDisruptionBudgetTemplateBuilder() {
    this(false);
  }
  public PodDisruptionBudgetTemplateBuilder(Boolean validationEnabled) {
    this(new PodDisruptionBudgetTemplate(), validationEnabled);
  }
  public PodDisruptionBudgetTemplateBuilder(PodDisruptionBudgetTemplateFluent<?> fluent) {
    this(fluent, false);
  }
  public PodDisruptionBudgetTemplateBuilder(PodDisruptionBudgetTemplateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodDisruptionBudgetTemplate(), validationEnabled);
  }
  public PodDisruptionBudgetTemplateBuilder(PodDisruptionBudgetTemplateFluent<?> fluent,PodDisruptionBudgetTemplate instance) {
    this(fluent, instance, false);
  }
  public PodDisruptionBudgetTemplateBuilder(PodDisruptionBudgetTemplateFluent<?> fluent,PodDisruptionBudgetTemplate instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PodDisruptionBudgetTemplate());

    if (instance != null) {
      fluent.withMetadata(instance.getMetadata());
      fluent.withMaxUnavailable(instance.getMaxUnavailable());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodDisruptionBudgetTemplateBuilder(PodDisruptionBudgetTemplate instance) {
    this(instance,false);
  }
  public PodDisruptionBudgetTemplateBuilder(PodDisruptionBudgetTemplate instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PodDisruptionBudgetTemplate());

    if (instance != null) {
      this.withMetadata(instance.getMetadata());
      this.withMaxUnavailable(instance.getMaxUnavailable());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodDisruptionBudgetTemplateFluent<?> fluent;
  Boolean validationEnabled;
  public PodDisruptionBudgetTemplate build() {
    PodDisruptionBudgetTemplate buildable = new PodDisruptionBudgetTemplate();
    buildable.setMetadata(fluent.buildMetadata());
    buildable.setMaxUnavailable(fluent.getMaxUnavailable());
    return buildable;
  }
  
}