package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodTemplateBuilder extends PodTemplateFluent<PodTemplateBuilder> implements VisitableBuilder<PodTemplate,PodTemplateBuilder>{
  public PodTemplateBuilder() {
    this(false);
  }
  public PodTemplateBuilder(Boolean validationEnabled) {
    this(new PodTemplate(), validationEnabled);
  }
  public PodTemplateBuilder(PodTemplateFluent<?> fluent) {
    this(fluent, false);
  }
  public PodTemplateBuilder(PodTemplateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodTemplate(), validationEnabled);
  }
  public PodTemplateBuilder(PodTemplateFluent<?> fluent,PodTemplate instance) {
    this(fluent, instance, false);
  }
  public PodTemplateBuilder(PodTemplateFluent<?> fluent,PodTemplate instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PodTemplate());

    if (instance != null) {
      fluent.withMetadata(instance.getMetadata());
      fluent.withImagePullSecrets(instance.getImagePullSecrets());
      fluent.withSecurityContext(instance.getSecurityContext());
      fluent.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds());
      fluent.withAffinity(instance.getAffinity());
      fluent.withTolerations(instance.getTolerations());
      fluent.withTopologySpreadConstraints(instance.getTopologySpreadConstraints());
      fluent.withPriorityClassName(instance.getPriorityClassName());
      fluent.withSchedulerName(instance.getSchedulerName());
      fluent.withHostAliases(instance.getHostAliases());
      fluent.withEnableServiceLinks(instance.getEnableServiceLinks());
      fluent.withTmpDirSizeLimit(instance.getTmpDirSizeLimit());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodTemplateBuilder(PodTemplate instance) {
    this(instance,false);
  }
  public PodTemplateBuilder(PodTemplate instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PodTemplate());

    if (instance != null) {
      this.withMetadata(instance.getMetadata());
      this.withImagePullSecrets(instance.getImagePullSecrets());
      this.withSecurityContext(instance.getSecurityContext());
      this.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds());
      this.withAffinity(instance.getAffinity());
      this.withTolerations(instance.getTolerations());
      this.withTopologySpreadConstraints(instance.getTopologySpreadConstraints());
      this.withPriorityClassName(instance.getPriorityClassName());
      this.withSchedulerName(instance.getSchedulerName());
      this.withHostAliases(instance.getHostAliases());
      this.withEnableServiceLinks(instance.getEnableServiceLinks());
      this.withTmpDirSizeLimit(instance.getTmpDirSizeLimit());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodTemplateFluent<?> fluent;
  Boolean validationEnabled;
  public PodTemplate build() {
    PodTemplate buildable = new PodTemplate();
    buildable.setMetadata(fluent.buildMetadata());
    buildable.setImagePullSecrets(fluent.getImagePullSecrets());
    buildable.setSecurityContext(fluent.getSecurityContext());
    buildable.setTerminationGracePeriodSeconds(fluent.getTerminationGracePeriodSeconds());
    buildable.setAffinity(fluent.getAffinity());
    buildable.setTolerations(fluent.getTolerations());
    buildable.setTopologySpreadConstraints(fluent.getTopologySpreadConstraints());
    buildable.setPriorityClassName(fluent.getPriorityClassName());
    buildable.setSchedulerName(fluent.getSchedulerName());
    buildable.setHostAliases(fluent.getHostAliases());
    buildable.setEnableServiceLinks(fluent.getEnableServiceLinks());
    buildable.setTmpDirSizeLimit(fluent.getTmpDirSizeLimit());
    return buildable;
  }
  
}