package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.model.PodSecurityContext;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.TopologySpreadConstraint;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.HostAlias;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.Toleration;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.Affinity;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PodTemplateFluent<A extends PodTemplateFluent<A>> extends BaseFluent<A>{
  public PodTemplateFluent() {
  }
  public PodTemplateFluent(PodTemplate instance) {
    instance = (instance != null ? instance : new PodTemplate());

    if (instance != null) {
      this.withMetadata(instance.getMetadata());
      this.withImagePullSecrets(instance.getImagePullSecrets());
      this.withSecurityContext(instance.getSecurityContext());
      this.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds());
      this.withAffinity(instance.getAffinity());
      this.withTolerations(instance.getTolerations());
      this.withTopologySpreadConstraints(instance.getTopologySpreadConstraints());
      this.withPriorityClassName(instance.getPriorityClassName());
      this.withSchedulerName(instance.getSchedulerName());
      this.withHostAliases(instance.getHostAliases());
      this.withEnableServiceLinks(instance.getEnableServiceLinks());
      this.withTmpDirSizeLimit(instance.getTmpDirSizeLimit());
    }
  }
  private MetadataTemplateBuilder metadata;
  private List<LocalObjectReference> imagePullSecrets;
  private PodSecurityContext securityContext;
  private int terminationGracePeriodSeconds;
  private Affinity affinity;
  private List<Toleration> tolerations;
  private List<TopologySpreadConstraint> topologySpreadConstraints;
  private String priorityClassName;
  private String schedulerName;
  private List<HostAlias> hostAliases;
  private Boolean enableServiceLinks;
  private String tmpDirSizeLimit;
  public MetadataTemplate buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(MetadataTemplate metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new MetadataTemplateBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public boolean hasMetadata() {
    return this.metadata != null;
  }
  public MetadataNested<A> withNewMetadata() {
    return new MetadataNested(null);
  }
  public MetadataNested<A> withNewMetadataLike(MetadataTemplate item) {
    return new MetadataNested(item);
  }
  public MetadataNested<A> editMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(null));
  }
  public MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(new MetadataTemplateBuilder().build()));
  }
  public MetadataNested<A> editOrNewMetadataLike(MetadataTemplate item) {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(item));
  }
  public A addToImagePullSecrets(int index,LocalObjectReference item) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReference>();}
    this.imagePullSecrets.add(index, item);
    return (A)this;
  }
  public A setToImagePullSecrets(int index,LocalObjectReference item) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReference>();}
    this.imagePullSecrets.set(index, item); return (A)this;
  }
  public A addToImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... items) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReference>();}
    for (LocalObjectReference item : items) {this.imagePullSecrets.add(item);} return (A)this;
  }
  public A addAllToImagePullSecrets(Collection<LocalObjectReference> items) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReference>();}
    for (LocalObjectReference item : items) {this.imagePullSecrets.add(item);} return (A)this;
  }
  public A removeFromImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... items) {
    if (this.imagePullSecrets == null) return (A)this;
    for (LocalObjectReference item : items) { this.imagePullSecrets.remove(item);} return (A)this;
  }
  public A removeAllFromImagePullSecrets(Collection<LocalObjectReference> items) {
    if (this.imagePullSecrets == null) return (A)this;
    for (LocalObjectReference item : items) { this.imagePullSecrets.remove(item);} return (A)this;
  }
  public List<LocalObjectReference> getImagePullSecrets() {
    return this.imagePullSecrets;
  }
  public LocalObjectReference getImagePullSecret(int index) {
    return this.imagePullSecrets.get(index);
  }
  public LocalObjectReference getFirstImagePullSecret() {
    return this.imagePullSecrets.get(0);
  }
  public LocalObjectReference getLastImagePullSecret() {
    return this.imagePullSecrets.get(imagePullSecrets.size() - 1);
  }
  public LocalObjectReference getMatchingImagePullSecret(Predicate<LocalObjectReference> predicate) {
    for (LocalObjectReference item: imagePullSecrets) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingImagePullSecret(Predicate<LocalObjectReference> predicate) {
    for (LocalObjectReference item: imagePullSecrets) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withImagePullSecrets(List<LocalObjectReference> imagePullSecrets) {
    if (imagePullSecrets != null) {this.imagePullSecrets = new ArrayList(); for (LocalObjectReference item : imagePullSecrets){this.addToImagePullSecrets(item);}} else { this.imagePullSecrets = null;} return (A) this;
  }
  public A withImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... imagePullSecrets) {
    if (this.imagePullSecrets != null) {this.imagePullSecrets.clear(); _visitables.remove("imagePullSecrets"); }
    if (imagePullSecrets != null) {for (LocalObjectReference item :imagePullSecrets){ this.addToImagePullSecrets(item);}} return (A) this;
  }
  public boolean hasImagePullSecrets() {
    return imagePullSecrets != null && !imagePullSecrets.isEmpty();
  }
  public A addNewImagePullSecret(String name) {
    return (A)addToImagePullSecrets(new LocalObjectReference(name));
  }
  public PodSecurityContext getSecurityContext() {
    return this.securityContext;
  }
  public A withSecurityContext(PodSecurityContext securityContext) {
    this.securityContext=securityContext; return (A) this;
  }
  public boolean hasSecurityContext() {
    return this.securityContext != null;
  }
  public int getTerminationGracePeriodSeconds() {
    return this.terminationGracePeriodSeconds;
  }
  public A withTerminationGracePeriodSeconds(int terminationGracePeriodSeconds) {
    this.terminationGracePeriodSeconds=terminationGracePeriodSeconds; return (A) this;
  }
  public boolean hasTerminationGracePeriodSeconds() {
    return true;
  }
  public Affinity getAffinity() {
    return this.affinity;
  }
  public A withAffinity(Affinity affinity) {
    this.affinity=affinity; return (A) this;
  }
  public boolean hasAffinity() {
    return this.affinity != null;
  }
  public A addToTolerations(int index,Toleration item) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    this.tolerations.add(index, item);
    return (A)this;
  }
  public A setToTolerations(int index,Toleration item) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    this.tolerations.set(index, item); return (A)this;
  }
  public A addToTolerations(io.fabric8.kubernetes.api.model.Toleration... items) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
  }
  public A addAllToTolerations(Collection<Toleration> items) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
  }
  public A removeFromTolerations(io.fabric8.kubernetes.api.model.Toleration... items) {
    if (this.tolerations == null) return (A)this;
    for (Toleration item : items) { this.tolerations.remove(item);} return (A)this;
  }
  public A removeAllFromTolerations(Collection<Toleration> items) {
    if (this.tolerations == null) return (A)this;
    for (Toleration item : items) { this.tolerations.remove(item);} return (A)this;
  }
  public List<Toleration> getTolerations() {
    return this.tolerations;
  }
  public Toleration getToleration(int index) {
    return this.tolerations.get(index);
  }
  public Toleration getFirstToleration() {
    return this.tolerations.get(0);
  }
  public Toleration getLastToleration() {
    return this.tolerations.get(tolerations.size() - 1);
  }
  public Toleration getMatchingToleration(Predicate<Toleration> predicate) {
    for (Toleration item: tolerations) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingToleration(Predicate<Toleration> predicate) {
    for (Toleration item: tolerations) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTolerations(List<Toleration> tolerations) {
    if (tolerations != null) {this.tolerations = new ArrayList(); for (Toleration item : tolerations){this.addToTolerations(item);}} else { this.tolerations = null;} return (A) this;
  }
  public A withTolerations(io.fabric8.kubernetes.api.model.Toleration... tolerations) {
    if (this.tolerations != null) {this.tolerations.clear(); _visitables.remove("tolerations"); }
    if (tolerations != null) {for (Toleration item :tolerations){ this.addToTolerations(item);}} return (A) this;
  }
  public boolean hasTolerations() {
    return tolerations != null && !tolerations.isEmpty();
  }
  public A addNewToleration(String effect,String key,String operator,Long tolerationSeconds,String value) {
    return (A)addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
  }
  public A addToTopologySpreadConstraints(int index,TopologySpreadConstraint item) {
    if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();}
    this.topologySpreadConstraints.add(index, item);
    return (A)this;
  }
  public A setToTopologySpreadConstraints(int index,TopologySpreadConstraint item) {
    if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();}
    this.topologySpreadConstraints.set(index, item); return (A)this;
  }
  public A addToTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... items) {
    if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();}
    for (TopologySpreadConstraint item : items) {this.topologySpreadConstraints.add(item);} return (A)this;
  }
  public A addAllToTopologySpreadConstraints(Collection<TopologySpreadConstraint> items) {
    if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();}
    for (TopologySpreadConstraint item : items) {this.topologySpreadConstraints.add(item);} return (A)this;
  }
  public A removeFromTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... items) {
    if (this.topologySpreadConstraints == null) return (A)this;
    for (TopologySpreadConstraint item : items) { this.topologySpreadConstraints.remove(item);} return (A)this;
  }
  public A removeAllFromTopologySpreadConstraints(Collection<TopologySpreadConstraint> items) {
    if (this.topologySpreadConstraints == null) return (A)this;
    for (TopologySpreadConstraint item : items) { this.topologySpreadConstraints.remove(item);} return (A)this;
  }
  public List<TopologySpreadConstraint> getTopologySpreadConstraints() {
    return this.topologySpreadConstraints;
  }
  public TopologySpreadConstraint getTopologySpreadConstraint(int index) {
    return this.topologySpreadConstraints.get(index);
  }
  public TopologySpreadConstraint getFirstTopologySpreadConstraint() {
    return this.topologySpreadConstraints.get(0);
  }
  public TopologySpreadConstraint getLastTopologySpreadConstraint() {
    return this.topologySpreadConstraints.get(topologySpreadConstraints.size() - 1);
  }
  public TopologySpreadConstraint getMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraint> predicate) {
    for (TopologySpreadConstraint item: topologySpreadConstraints) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraint> predicate) {
    for (TopologySpreadConstraint item: topologySpreadConstraints) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTopologySpreadConstraints(List<TopologySpreadConstraint> topologySpreadConstraints) {
    if (topologySpreadConstraints != null) {this.topologySpreadConstraints = new ArrayList(); for (TopologySpreadConstraint item : topologySpreadConstraints){this.addToTopologySpreadConstraints(item);}} else { this.topologySpreadConstraints = null;} return (A) this;
  }
  public A withTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... topologySpreadConstraints) {
    if (this.topologySpreadConstraints != null) {this.topologySpreadConstraints.clear(); _visitables.remove("topologySpreadConstraints"); }
    if (topologySpreadConstraints != null) {for (TopologySpreadConstraint item :topologySpreadConstraints){ this.addToTopologySpreadConstraints(item);}} return (A) this;
  }
  public boolean hasTopologySpreadConstraints() {
    return topologySpreadConstraints != null && !topologySpreadConstraints.isEmpty();
  }
  public String getPriorityClassName() {
    return this.priorityClassName;
  }
  public A withPriorityClassName(String priorityClassName) {
    this.priorityClassName=priorityClassName; return (A) this;
  }
  public boolean hasPriorityClassName() {
    return this.priorityClassName != null;
  }
  public String getSchedulerName() {
    return this.schedulerName;
  }
  public A withSchedulerName(String schedulerName) {
    this.schedulerName=schedulerName; return (A) this;
  }
  public boolean hasSchedulerName() {
    return this.schedulerName != null;
  }
  public A addToHostAliases(int index,HostAlias item) {
    if (this.hostAliases == null) {this.hostAliases = new ArrayList<HostAlias>();}
    this.hostAliases.add(index, item);
    return (A)this;
  }
  public A setToHostAliases(int index,HostAlias item) {
    if (this.hostAliases == null) {this.hostAliases = new ArrayList<HostAlias>();}
    this.hostAliases.set(index, item); return (A)this;
  }
  public A addToHostAliases(io.fabric8.kubernetes.api.model.HostAlias... items) {
    if (this.hostAliases == null) {this.hostAliases = new ArrayList<HostAlias>();}
    for (HostAlias item : items) {this.hostAliases.add(item);} return (A)this;
  }
  public A addAllToHostAliases(Collection<HostAlias> items) {
    if (this.hostAliases == null) {this.hostAliases = new ArrayList<HostAlias>();}
    for (HostAlias item : items) {this.hostAliases.add(item);} return (A)this;
  }
  public A removeFromHostAliases(io.fabric8.kubernetes.api.model.HostAlias... items) {
    if (this.hostAliases == null) return (A)this;
    for (HostAlias item : items) { this.hostAliases.remove(item);} return (A)this;
  }
  public A removeAllFromHostAliases(Collection<HostAlias> items) {
    if (this.hostAliases == null) return (A)this;
    for (HostAlias item : items) { this.hostAliases.remove(item);} return (A)this;
  }
  public List<HostAlias> getHostAliases() {
    return this.hostAliases;
  }
  public HostAlias getHostAlias(int index) {
    return this.hostAliases.get(index);
  }
  public HostAlias getFirstHostAlias() {
    return this.hostAliases.get(0);
  }
  public HostAlias getLastHostAlias() {
    return this.hostAliases.get(hostAliases.size() - 1);
  }
  public HostAlias getMatchingHostAlias(Predicate<HostAlias> predicate) {
    for (HostAlias item: hostAliases) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingHostAlias(Predicate<HostAlias> predicate) {
    for (HostAlias item: hostAliases) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withHostAliases(List<HostAlias> hostAliases) {
    if (hostAliases != null) {this.hostAliases = new ArrayList(); for (HostAlias item : hostAliases){this.addToHostAliases(item);}} else { this.hostAliases = null;} return (A) this;
  }
  public A withHostAliases(io.fabric8.kubernetes.api.model.HostAlias... hostAliases) {
    if (this.hostAliases != null) {this.hostAliases.clear(); _visitables.remove("hostAliases"); }
    if (hostAliases != null) {for (HostAlias item :hostAliases){ this.addToHostAliases(item);}} return (A) this;
  }
  public boolean hasHostAliases() {
    return hostAliases != null && !hostAliases.isEmpty();
  }
  public Boolean getEnableServiceLinks() {
    return this.enableServiceLinks;
  }
  public A withEnableServiceLinks(Boolean enableServiceLinks) {
    this.enableServiceLinks=enableServiceLinks; return (A) this;
  }
  public boolean hasEnableServiceLinks() {
    return this.enableServiceLinks != null;
  }
  public String getTmpDirSizeLimit() {
    return this.tmpDirSizeLimit;
  }
  public A withTmpDirSizeLimit(String tmpDirSizeLimit) {
    this.tmpDirSizeLimit=tmpDirSizeLimit; return (A) this;
  }
  public boolean hasTmpDirSizeLimit() {
    return this.tmpDirSizeLimit != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PodTemplateFluent that = (PodTemplateFluent) o;
    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    if (!java.util.Objects.equals(imagePullSecrets, that.imagePullSecrets)) return false;

    if (!java.util.Objects.equals(securityContext, that.securityContext)) return false;

    if (terminationGracePeriodSeconds != that.terminationGracePeriodSeconds) return false;
    if (!java.util.Objects.equals(affinity, that.affinity)) return false;

    if (!java.util.Objects.equals(tolerations, that.tolerations)) return false;

    if (!java.util.Objects.equals(topologySpreadConstraints, that.topologySpreadConstraints)) return false;

    if (!java.util.Objects.equals(priorityClassName, that.priorityClassName)) return false;

    if (!java.util.Objects.equals(schedulerName, that.schedulerName)) return false;

    if (!java.util.Objects.equals(hostAliases, that.hostAliases)) return false;

    if (!java.util.Objects.equals(enableServiceLinks, that.enableServiceLinks)) return false;

    if (!java.util.Objects.equals(tmpDirSizeLimit, that.tmpDirSizeLimit)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(metadata,  imagePullSecrets,  securityContext,  terminationGracePeriodSeconds,  affinity,  tolerations,  topologySpreadConstraints,  priorityClassName,  schedulerName,  hostAliases,  enableServiceLinks,  tmpDirSizeLimit,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (imagePullSecrets != null && !imagePullSecrets.isEmpty()) { sb.append("imagePullSecrets:"); sb.append(imagePullSecrets + ","); }
    if (securityContext != null) { sb.append("securityContext:"); sb.append(securityContext + ","); }
    sb.append("terminationGracePeriodSeconds:"); sb.append(terminationGracePeriodSeconds + ",");
    if (affinity != null) { sb.append("affinity:"); sb.append(affinity + ","); }
    if (tolerations != null && !tolerations.isEmpty()) { sb.append("tolerations:"); sb.append(tolerations + ","); }
    if (topologySpreadConstraints != null && !topologySpreadConstraints.isEmpty()) { sb.append("topologySpreadConstraints:"); sb.append(topologySpreadConstraints + ","); }
    if (priorityClassName != null) { sb.append("priorityClassName:"); sb.append(priorityClassName + ","); }
    if (schedulerName != null) { sb.append("schedulerName:"); sb.append(schedulerName + ","); }
    if (hostAliases != null && !hostAliases.isEmpty()) { sb.append("hostAliases:"); sb.append(hostAliases + ","); }
    if (enableServiceLinks != null) { sb.append("enableServiceLinks:"); sb.append(enableServiceLinks + ","); }
    if (tmpDirSizeLimit != null) { sb.append("tmpDirSizeLimit:"); sb.append(tmpDirSizeLimit); }
    sb.append("}");
    return sb.toString();
  }
  public A withEnableServiceLinks() {
    return withEnableServiceLinks(true);
  }
  public class MetadataNested<N> extends MetadataTemplateFluent<MetadataNested<N>> implements Nested<N>{
    MetadataNested(MetadataTemplate item) {
      this.builder = new MetadataTemplateBuilder(this, item);
    }
    MetadataTemplateBuilder builder;
    public N and() {
      return (N) PodTemplateFluent.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  
}