package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ResourceTemplateBuilder extends ResourceTemplateFluent<ResourceTemplateBuilder> implements VisitableBuilder<ResourceTemplate,ResourceTemplateBuilder>{
  public ResourceTemplateBuilder() {
    this(false);
  }
  public ResourceTemplateBuilder(Boolean validationEnabled) {
    this(new ResourceTemplate(), validationEnabled);
  }
  public ResourceTemplateBuilder(ResourceTemplateFluent<?> fluent) {
    this(fluent, false);
  }
  public ResourceTemplateBuilder(ResourceTemplateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ResourceTemplate(), validationEnabled);
  }
  public ResourceTemplateBuilder(ResourceTemplateFluent<?> fluent,ResourceTemplate instance) {
    this(fluent, instance, false);
  }
  public ResourceTemplateBuilder(ResourceTemplateFluent<?> fluent,ResourceTemplate instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ResourceTemplate());

    if (instance != null) {
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ResourceTemplateBuilder(ResourceTemplate instance) {
    this(instance,false);
  }
  public ResourceTemplateBuilder(ResourceTemplate instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ResourceTemplate());

    if (instance != null) {
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  ResourceTemplateFluent<?> fluent;
  Boolean validationEnabled;
  public ResourceTemplate build() {
    ResourceTemplate buildable = new ResourceTemplate();
    buildable.setMetadata(fluent.buildMetadata());
    return buildable;
  }
  
}