/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.AclOperation;
import io.strimzi.api.kafka.model.AclRule;
import io.strimzi.api.kafka.model.AclRuleClusterResource;
import io.strimzi.api.kafka.model.AclRuleClusterResourceBuilder;
import io.strimzi.api.kafka.model.AclRuleClusterResourceFluent;
import io.strimzi.api.kafka.model.AclRuleGroupResource;
import io.strimzi.api.kafka.model.AclRuleGroupResourceBuilder;
import io.strimzi.api.kafka.model.AclRuleGroupResourceFluent;
import io.strimzi.api.kafka.model.AclRuleResource;
import io.strimzi.api.kafka.model.AclRuleTopicResource;
import io.strimzi.api.kafka.model.AclRuleTopicResourceBuilder;
import io.strimzi.api.kafka.model.AclRuleTopicResourceFluent;
import io.strimzi.api.kafka.model.AclRuleTransactionalIdResource;
import io.strimzi.api.kafka.model.AclRuleTransactionalIdResourceBuilder;
import io.strimzi.api.kafka.model.AclRuleTransactionalIdResourceFluent;
import io.strimzi.api.kafka.model.AclRuleType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class AclRuleFluent<A extends AclRuleFluent<A>>
extends BaseFluent<A> {
    private AclRuleType type;
    private VisitableBuilder<? extends AclRuleResource, ?> resource;
    private String host;
    private AclOperation operation;
    private List<AclOperation> operations;

    public AclRuleFluent() {
    }

    public AclRuleFluent(AclRule instance) {
        AclRule aclRule = instance = instance != null ? instance : new AclRule();
        if (instance != null) {
            this.withType(instance.getType());
            this.withResource(instance.getResource());
            this.withHost(instance.getHost());
            this.withOperations(instance.getOperations());
            this.withType(instance.getType());
            this.withResource(instance.getResource());
            this.withHost(instance.getHost());
            this.withOperation(instance.getOperation());
            this.withOperations(instance.getOperations());
        }
    }

    public AclRuleType getType() {
        return this.type;
    }

    public A withType(AclRuleType type) {
        this.type = type;
        return (A)((Object)this);
    }

    public boolean hasType() {
        return this.type != null;
    }

    public AclRuleResource buildResource() {
        return this.resource != null ? (AclRuleResource)this.resource.build() : null;
    }

    public A withResource(AclRuleResource resource) {
        if (resource == null) {
            this.resource = null;
            this._visitables.remove((Object)"resource");
            return (A)((Object)this);
        }
        VisitableBuilder builder = AclRuleFluent.builder(resource);
        this._visitables.get((Object)"resource").clear();
        this._visitables.get((Object)"resource").add(builder);
        this.resource = builder;
        return (A)((Object)this);
    }

    public boolean hasResource() {
        return this.resource != null;
    }

    public AclRuleGroupResourceNested<A> withNewAclRuleGroupResource() {
        return new AclRuleGroupResourceNested(null);
    }

    public AclRuleGroupResourceNested<A> withNewAclRuleGroupResourceLike(AclRuleGroupResource item) {
        return new AclRuleGroupResourceNested(item);
    }

    public AclRuleTopicResourceNested<A> withNewAclRuleTopicResource() {
        return new AclRuleTopicResourceNested(null);
    }

    public AclRuleTopicResourceNested<A> withNewAclRuleTopicResourceLike(AclRuleTopicResource item) {
        return new AclRuleTopicResourceNested(item);
    }

    public AclRuleTransactionalIdResourceNested<A> withNewAclRuleTransactionalIdResource() {
        return new AclRuleTransactionalIdResourceNested(null);
    }

    public AclRuleTransactionalIdResourceNested<A> withNewAclRuleTransactionalIdResourceLike(AclRuleTransactionalIdResource item) {
        return new AclRuleTransactionalIdResourceNested(item);
    }

    public AclRuleClusterResourceNested<A> withNewAclRuleClusterResource() {
        return new AclRuleClusterResourceNested(null);
    }

    public AclRuleClusterResourceNested<A> withNewAclRuleClusterResourceLike(AclRuleClusterResource item) {
        return new AclRuleClusterResourceNested(item);
    }

    public String getHost() {
        return this.host;
    }

    public A withHost(String host) {
        this.host = host;
        return (A)((Object)this);
    }

    public boolean hasHost() {
        return this.host != null;
    }

    public AclOperation getOperation() {
        return this.operation;
    }

    public A withOperation(AclOperation operation) {
        this.operation = operation;
        return (A)((Object)this);
    }

    public boolean hasOperation() {
        return this.operation != null;
    }

    public A addToOperations(int index, AclOperation item) {
        if (this.operations == null) {
            this.operations = new ArrayList<AclOperation>();
        }
        this.operations.add(index, item);
        return (A)((Object)this);
    }

    public A setToOperations(int index, AclOperation item) {
        if (this.operations == null) {
            this.operations = new ArrayList<AclOperation>();
        }
        this.operations.set(index, item);
        return (A)((Object)this);
    }

    public A addToOperations(AclOperation ... items) {
        if (this.operations == null) {
            this.operations = new ArrayList<AclOperation>();
        }
        for (AclOperation item : items) {
            this.operations.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToOperations(Collection<AclOperation> items) {
        if (this.operations == null) {
            this.operations = new ArrayList<AclOperation>();
        }
        for (AclOperation item : items) {
            this.operations.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromOperations(AclOperation ... items) {
        if (this.operations == null) {
            return (A)((Object)this);
        }
        for (AclOperation item : items) {
            this.operations.remove((Object)item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromOperations(Collection<AclOperation> items) {
        if (this.operations == null) {
            return (A)((Object)this);
        }
        for (AclOperation item : items) {
            this.operations.remove((Object)item);
        }
        return (A)((Object)this);
    }

    public List<AclOperation> getOperations() {
        return this.operations;
    }

    public AclOperation getOperation(int index) {
        return this.operations.get(index);
    }

    public AclOperation getFirstOperation() {
        return this.operations.get(0);
    }

    public AclOperation getLastOperation() {
        return this.operations.get(this.operations.size() - 1);
    }

    public AclOperation getMatchingOperation(Predicate<AclOperation> predicate) {
        for (AclOperation item : this.operations) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingOperation(Predicate<AclOperation> predicate) {
        for (AclOperation item : this.operations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withOperations(List<AclOperation> operations) {
        if (operations != null) {
            this.operations = new ArrayList<AclOperation>();
            for (AclOperation item : operations) {
                this.addToOperations(item);
            }
        } else {
            this.operations = null;
        }
        return (A)((Object)this);
    }

    public A withOperations(AclOperation ... operations) {
        if (this.operations != null) {
            this.operations.clear();
            this._visitables.remove((Object)"operations");
        }
        if (operations != null) {
            for (AclOperation item : operations) {
                this.addToOperations(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasOperations() {
        return this.operations != null && !this.operations.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AclRuleFluent that = (AclRuleFluent)((Object)o);
        if (!Objects.equals((Object)this.type, (Object)that.type)) {
            return false;
        }
        if (!Objects.equals(this.resource, that.resource)) {
            return false;
        }
        if (!Objects.equals(this.host, that.host)) {
            return false;
        }
        if (!Objects.equals((Object)this.operation, (Object)that.operation)) {
            return false;
        }
        return Objects.equals(this.operations, that.operations);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.resource, this.host, this.operation, this.operations, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type + ",");
        }
        if (this.resource != null) {
            sb.append("resource:");
            sb.append(this.resource + ",");
        }
        if (this.host != null) {
            sb.append("host:");
            sb.append(this.host + ",");
        }
        if (this.operation != null) {
            sb.append("operation:");
            sb.append(this.operation + ",");
        }
        if (this.operations != null && !this.operations.isEmpty()) {
            sb.append("operations:");
            sb.append(this.operations);
        }
        sb.append("}");
        return sb.toString();
    }

    protected static <T> VisitableBuilder<T, ?> builder(Object item) {
        switch (item.getClass().getName()) {
            case "io.strimzi.api.kafka.model.AclRuleGroupResource": {
                return new AclRuleGroupResourceBuilder((AclRuleGroupResource)item);
            }
            case "io.strimzi.api.kafka.model.AclRuleTopicResource": {
                return new AclRuleTopicResourceBuilder((AclRuleTopicResource)item);
            }
            case "io.strimzi.api.kafka.model.AclRuleTransactionalIdResource": {
                return new AclRuleTransactionalIdResourceBuilder((AclRuleTransactionalIdResource)item);
            }
            case "io.strimzi.api.kafka.model.AclRuleClusterResource": {
                return new AclRuleClusterResourceBuilder((AclRuleClusterResource)item);
            }
        }
        return AclRuleFluent.builderOf((Object)item);
    }

    public class AclRuleGroupResourceNested<N>
    extends AclRuleGroupResourceFluent<AclRuleGroupResourceNested<N>>
    implements Nested<N> {
        AclRuleGroupResourceBuilder builder;

        AclRuleGroupResourceNested(AclRuleGroupResource item) {
            this.builder = new AclRuleGroupResourceBuilder(this, item);
        }

        public N and() {
            return (N)AclRuleFluent.this.withResource(this.builder.build());
        }

        public N endAclRuleGroupResource() {
            return this.and();
        }
    }

    public class AclRuleTopicResourceNested<N>
    extends AclRuleTopicResourceFluent<AclRuleTopicResourceNested<N>>
    implements Nested<N> {
        AclRuleTopicResourceBuilder builder;

        AclRuleTopicResourceNested(AclRuleTopicResource item) {
            this.builder = new AclRuleTopicResourceBuilder(this, item);
        }

        public N and() {
            return (N)AclRuleFluent.this.withResource(this.builder.build());
        }

        public N endAclRuleTopicResource() {
            return this.and();
        }
    }

    public class AclRuleTransactionalIdResourceNested<N>
    extends AclRuleTransactionalIdResourceFluent<AclRuleTransactionalIdResourceNested<N>>
    implements Nested<N> {
        AclRuleTransactionalIdResourceBuilder builder;

        AclRuleTransactionalIdResourceNested(AclRuleTransactionalIdResource item) {
            this.builder = new AclRuleTransactionalIdResourceBuilder(this, item);
        }

        public N and() {
            return (N)AclRuleFluent.this.withResource(this.builder.build());
        }

        public N endAclRuleTransactionalIdResource() {
            return this.and();
        }
    }

    public class AclRuleClusterResourceNested<N>
    extends AclRuleClusterResourceFluent<AclRuleClusterResourceNested<N>>
    implements Nested<N> {
        AclRuleClusterResourceBuilder builder;

        AclRuleClusterResourceNested(AclRuleClusterResource item) {
            this.builder = new AclRuleClusterResourceBuilder(this, item);
        }

        public N and() {
            return (N)AclRuleFluent.this.withResource(this.builder.build());
        }

        public N endAclRuleClusterResource() {
            return this.and();
        }
    }
}

