/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.client.CustomResource;
import io.strimzi.api.kafka.model.status.Status;
import java.util.function.Predicate;

class CustomResourceConditions {
    private CustomResourceConditions() {
    }

    static <Y extends Status, T extends CustomResource<?, Y>> Predicate<T> isReady() {
        return CustomResourceConditions.isLatestGenerationAndAnyConditionMatches("Ready", "True");
    }

    static <Y extends Status, T extends CustomResource<?, Y>> Predicate<T> isLatestGenerationAndAnyConditionMatches(String type, String status) {
        return CustomResourceConditions.isStatusLatestGenerationAndMatches(CustomResourceConditions.anyCondition(type, status));
    }

    private static <Y extends Status> Predicate<Y> anyCondition(String expectedType, String expectedStatus) {
        return status -> {
            if (status.getConditions() == null) {
                return false;
            }
            return status.getConditions().stream().anyMatch(condition -> expectedType.equals(condition.getType()) && expectedStatus.equals(condition.getStatus()));
        };
    }

    private static <Y extends Status, T extends CustomResource<?, Y>> Predicate<T> isStatusLatestGenerationAndMatches(Predicate<Y> predicate) {
        return resource -> {
            if (resource.getStatus() == null) {
                return false;
            }
            boolean expectedGeneration = resource.getMetadata().getGeneration().longValue() == ((Status)resource.getStatus()).getObservedGeneration();
            return expectedGeneration && predicate.test((Status)resource.getStatus());
        };
    }
}

