/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.CertAndKeySecretSource;
import io.strimzi.api.kafka.model.CertAndKeySecretSourceBuilder;
import io.strimzi.api.kafka.model.CertSecretSource;
import io.strimzi.api.kafka.model.CertSecretSourceBuilder;
import io.strimzi.api.kafka.model.CertSecretSourceFluent;
import io.strimzi.api.kafka.model.KafkaAuthorizationOpa;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class KafkaAuthorizationOpaFluent<A extends KafkaAuthorizationOpaFluent<A>>
extends BaseFluent<A> {
    private List<String> superUsers;
    private String url;
    private boolean allowOnError;
    private int initialCacheCapacity;
    private int maximumCacheSize;
    private long expireAfterMs;
    private boolean enableMetrics;
    private ArrayList<CertSecretSourceBuilder> tlsTrustedCertificates;

    public KafkaAuthorizationOpaFluent() {
    }

    public KafkaAuthorizationOpaFluent(KafkaAuthorizationOpa instance) {
        KafkaAuthorizationOpa kafkaAuthorizationOpa = instance = instance != null ? instance : new KafkaAuthorizationOpa();
        if (instance != null) {
            this.withSuperUsers(instance.getSuperUsers());
            this.withUrl(instance.getUrl());
            this.withAllowOnError(instance.isAllowOnError());
            this.withInitialCacheCapacity(instance.getInitialCacheCapacity());
            this.withMaximumCacheSize(instance.getMaximumCacheSize());
            this.withExpireAfterMs(instance.getExpireAfterMs());
            this.withEnableMetrics(instance.isEnableMetrics());
            this.withTlsTrustedCertificates(instance.getTlsTrustedCertificates());
        }
    }

    public A addToSuperUsers(int index, String item) {
        if (this.superUsers == null) {
            this.superUsers = new ArrayList<String>();
        }
        this.superUsers.add(index, item);
        return (A)((Object)this);
    }

    public A setToSuperUsers(int index, String item) {
        if (this.superUsers == null) {
            this.superUsers = new ArrayList<String>();
        }
        this.superUsers.set(index, item);
        return (A)((Object)this);
    }

    public A addToSuperUsers(String ... items) {
        if (this.superUsers == null) {
            this.superUsers = new ArrayList<String>();
        }
        for (String item : items) {
            this.superUsers.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToSuperUsers(Collection<String> items) {
        if (this.superUsers == null) {
            this.superUsers = new ArrayList<String>();
        }
        for (String item : items) {
            this.superUsers.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromSuperUsers(String ... items) {
        if (this.superUsers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.superUsers.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSuperUsers(Collection<String> items) {
        if (this.superUsers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.superUsers.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getSuperUsers() {
        return this.superUsers;
    }

    public String getSuperUser(int index) {
        return this.superUsers.get(index);
    }

    public String getFirstSuperUser() {
        return this.superUsers.get(0);
    }

    public String getLastSuperUser() {
        return this.superUsers.get(this.superUsers.size() - 1);
    }

    public String getMatchingSuperUser(Predicate<String> predicate) {
        for (String item : this.superUsers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingSuperUser(Predicate<String> predicate) {
        for (String item : this.superUsers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSuperUsers(List<String> superUsers) {
        if (superUsers != null) {
            this.superUsers = new ArrayList<String>();
            for (String item : superUsers) {
                this.addToSuperUsers(item);
            }
        } else {
            this.superUsers = null;
        }
        return (A)((Object)this);
    }

    public A withSuperUsers(String ... superUsers) {
        if (this.superUsers != null) {
            this.superUsers.clear();
            this._visitables.remove((Object)"superUsers");
        }
        if (superUsers != null) {
            for (String item : superUsers) {
                this.addToSuperUsers(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasSuperUsers() {
        return this.superUsers != null && !this.superUsers.isEmpty();
    }

    public String getUrl() {
        return this.url;
    }

    public A withUrl(String url) {
        this.url = url;
        return (A)((Object)this);
    }

    public boolean hasUrl() {
        return this.url != null;
    }

    public boolean isAllowOnError() {
        return this.allowOnError;
    }

    public A withAllowOnError(boolean allowOnError) {
        this.allowOnError = allowOnError;
        return (A)((Object)this);
    }

    public boolean hasAllowOnError() {
        return true;
    }

    public int getInitialCacheCapacity() {
        return this.initialCacheCapacity;
    }

    public A withInitialCacheCapacity(int initialCacheCapacity) {
        this.initialCacheCapacity = initialCacheCapacity;
        return (A)((Object)this);
    }

    public boolean hasInitialCacheCapacity() {
        return true;
    }

    public int getMaximumCacheSize() {
        return this.maximumCacheSize;
    }

    public A withMaximumCacheSize(int maximumCacheSize) {
        this.maximumCacheSize = maximumCacheSize;
        return (A)((Object)this);
    }

    public boolean hasMaximumCacheSize() {
        return true;
    }

    public long getExpireAfterMs() {
        return this.expireAfterMs;
    }

    public A withExpireAfterMs(long expireAfterMs) {
        this.expireAfterMs = expireAfterMs;
        return (A)((Object)this);
    }

    public boolean hasExpireAfterMs() {
        return true;
    }

    public boolean isEnableMetrics() {
        return this.enableMetrics;
    }

    public A withEnableMetrics(boolean enableMetrics) {
        this.enableMetrics = enableMetrics;
        return (A)((Object)this);
    }

    public boolean hasEnableMetrics() {
        return true;
    }

    public A addToTlsTrustedCertificates(int index, CertSecretSource item) {
        if (this.tlsTrustedCertificates == null) {
            this.tlsTrustedCertificates = new ArrayList();
        }
        CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
        if (index < 0 || index >= this.tlsTrustedCertificates.size()) {
            this._visitables.get((Object)"tlsTrustedCertificates").add(builder);
            this.tlsTrustedCertificates.add(builder);
        } else {
            this._visitables.get((Object)"tlsTrustedCertificates").add(index, builder);
            this.tlsTrustedCertificates.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToTlsTrustedCertificates(int index, CertSecretSource item) {
        if (this.tlsTrustedCertificates == null) {
            this.tlsTrustedCertificates = new ArrayList();
        }
        CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
        if (index < 0 || index >= this.tlsTrustedCertificates.size()) {
            this._visitables.get((Object)"tlsTrustedCertificates").add(builder);
            this.tlsTrustedCertificates.add(builder);
        } else {
            this._visitables.get((Object)"tlsTrustedCertificates").set(index, builder);
            this.tlsTrustedCertificates.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToTlsTrustedCertificates(CertSecretSource ... items) {
        if (this.tlsTrustedCertificates == null) {
            this.tlsTrustedCertificates = new ArrayList();
        }
        for (CertSecretSource item : items) {
            CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
            this._visitables.get((Object)"tlsTrustedCertificates").add(builder);
            this.tlsTrustedCertificates.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToTlsTrustedCertificates(Collection<CertSecretSource> items) {
        if (this.tlsTrustedCertificates == null) {
            this.tlsTrustedCertificates = new ArrayList();
        }
        for (CertSecretSource item : items) {
            CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
            this._visitables.get((Object)"tlsTrustedCertificates").add(builder);
            this.tlsTrustedCertificates.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromTlsTrustedCertificates(CertSecretSource ... items) {
        if (this.tlsTrustedCertificates == null) {
            return (A)((Object)this);
        }
        for (CertSecretSource item : items) {
            CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
            this._visitables.get((Object)"tlsTrustedCertificates").remove((Object)builder);
            this.tlsTrustedCertificates.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTlsTrustedCertificates(Collection<CertSecretSource> items) {
        if (this.tlsTrustedCertificates == null) {
            return (A)((Object)this);
        }
        for (CertSecretSource item : items) {
            CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
            this._visitables.get((Object)"tlsTrustedCertificates").remove((Object)builder);
            this.tlsTrustedCertificates.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromTlsTrustedCertificates(Predicate<CertSecretSourceBuilder> predicate) {
        if (this.tlsTrustedCertificates == null) {
            return (A)((Object)this);
        }
        Iterator<CertSecretSourceBuilder> each = this.tlsTrustedCertificates.iterator();
        List visitables = this._visitables.get((Object)"tlsTrustedCertificates");
        while (each.hasNext()) {
            CertSecretSourceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<CertSecretSource> buildTlsTrustedCertificates() {
        return this.tlsTrustedCertificates != null ? KafkaAuthorizationOpaFluent.build(this.tlsTrustedCertificates) : null;
    }

    public CertSecretSource buildTlsTrustedCertificate(int index) {
        return this.tlsTrustedCertificates.get(index).build();
    }

    public CertSecretSource buildFirstTlsTrustedCertificate() {
        return this.tlsTrustedCertificates.get(0).build();
    }

    public CertSecretSource buildLastTlsTrustedCertificate() {
        return this.tlsTrustedCertificates.get(this.tlsTrustedCertificates.size() - 1).build();
    }

    public CertSecretSource buildMatchingTlsTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
        for (CertSecretSourceBuilder item : this.tlsTrustedCertificates) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingTlsTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
        for (CertSecretSourceBuilder item : this.tlsTrustedCertificates) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTlsTrustedCertificates(List<CertSecretSource> tlsTrustedCertificates) {
        if (this.tlsTrustedCertificates != null) {
            this._visitables.get((Object)"tlsTrustedCertificates").clear();
        }
        if (tlsTrustedCertificates != null) {
            this.tlsTrustedCertificates = new ArrayList();
            for (CertSecretSource item : tlsTrustedCertificates) {
                this.addToTlsTrustedCertificates(item);
            }
        } else {
            this.tlsTrustedCertificates = null;
        }
        return (A)((Object)this);
    }

    public A withTlsTrustedCertificates(CertSecretSource ... tlsTrustedCertificates) {
        if (this.tlsTrustedCertificates != null) {
            this.tlsTrustedCertificates.clear();
            this._visitables.remove((Object)"tlsTrustedCertificates");
        }
        if (tlsTrustedCertificates != null) {
            for (CertSecretSource item : tlsTrustedCertificates) {
                this.addToTlsTrustedCertificates(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTlsTrustedCertificates() {
        return this.tlsTrustedCertificates != null && !this.tlsTrustedCertificates.isEmpty();
    }

    public TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificate() {
        return new TlsTrustedCertificatesNested(-1, null);
    }

    public TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificateLike(CertSecretSource item) {
        return new TlsTrustedCertificatesNested(-1, item);
    }

    public TlsTrustedCertificatesNested<A> setNewTlsTrustedCertificateLike(int index, CertSecretSource item) {
        return new TlsTrustedCertificatesNested(index, item);
    }

    public TlsTrustedCertificatesNested<A> editTlsTrustedCertificate(int index) {
        if (this.tlsTrustedCertificates.size() <= index) {
            throw new RuntimeException("Can't edit tlsTrustedCertificates. Index exceeds size.");
        }
        return this.setNewTlsTrustedCertificateLike(index, this.buildTlsTrustedCertificate(index));
    }

    public TlsTrustedCertificatesNested<A> editFirstTlsTrustedCertificate() {
        if (this.tlsTrustedCertificates.size() == 0) {
            throw new RuntimeException("Can't edit first tlsTrustedCertificates. The list is empty.");
        }
        return this.setNewTlsTrustedCertificateLike(0, this.buildTlsTrustedCertificate(0));
    }

    public TlsTrustedCertificatesNested<A> editLastTlsTrustedCertificate() {
        int index = this.tlsTrustedCertificates.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last tlsTrustedCertificates. The list is empty.");
        }
        return this.setNewTlsTrustedCertificateLike(index, this.buildTlsTrustedCertificate(index));
    }

    public TlsTrustedCertificatesNested<A> editMatchingTlsTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tlsTrustedCertificates.size(); ++i) {
            if (!predicate.test(this.tlsTrustedCertificates.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching tlsTrustedCertificates. No match found.");
        }
        return this.setNewTlsTrustedCertificateLike(index, this.buildTlsTrustedCertificate(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaAuthorizationOpaFluent that = (KafkaAuthorizationOpaFluent)((Object)o);
        if (!Objects.equals(this.superUsers, that.superUsers)) {
            return false;
        }
        if (!Objects.equals(this.url, that.url)) {
            return false;
        }
        if (this.allowOnError != that.allowOnError) {
            return false;
        }
        if (this.initialCacheCapacity != that.initialCacheCapacity) {
            return false;
        }
        if (this.maximumCacheSize != that.maximumCacheSize) {
            return false;
        }
        if (this.expireAfterMs != that.expireAfterMs) {
            return false;
        }
        if (this.enableMetrics != that.enableMetrics) {
            return false;
        }
        return Objects.equals(this.tlsTrustedCertificates, that.tlsTrustedCertificates);
    }

    public int hashCode() {
        return Objects.hash(this.superUsers, this.url, this.allowOnError, this.initialCacheCapacity, this.maximumCacheSize, this.expireAfterMs, this.enableMetrics, this.tlsTrustedCertificates, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.superUsers != null && !this.superUsers.isEmpty()) {
            sb.append("superUsers:");
            sb.append(this.superUsers + ",");
        }
        if (this.url != null) {
            sb.append("url:");
            sb.append(this.url + ",");
        }
        sb.append("allowOnError:");
        sb.append(this.allowOnError + ",");
        sb.append("initialCacheCapacity:");
        sb.append(this.initialCacheCapacity + ",");
        sb.append("maximumCacheSize:");
        sb.append(this.maximumCacheSize + ",");
        sb.append("expireAfterMs:");
        sb.append(this.expireAfterMs + ",");
        sb.append("enableMetrics:");
        sb.append(this.enableMetrics + ",");
        if (this.tlsTrustedCertificates != null && !this.tlsTrustedCertificates.isEmpty()) {
            sb.append("tlsTrustedCertificates:");
            sb.append(this.tlsTrustedCertificates);
        }
        sb.append("}");
        return sb.toString();
    }

    protected static <T> VisitableBuilder<T, ?> builder(Object item) {
        switch (item.getClass().getName()) {
            case "io.strimzi.api.kafka.model.CertAndKeySecretSource": {
                return new CertAndKeySecretSourceBuilder((CertAndKeySecretSource)item);
            }
        }
        return KafkaAuthorizationOpaFluent.builderOf((Object)item);
    }

    public A withAllowOnError() {
        return this.withAllowOnError(true);
    }

    public A withEnableMetrics() {
        return this.withEnableMetrics(true);
    }

    public class TlsTrustedCertificatesNested<N>
    extends CertSecretSourceFluent<TlsTrustedCertificatesNested<N>>
    implements Nested<N> {
        CertSecretSourceBuilder builder;
        int index;

        TlsTrustedCertificatesNested(int index, CertSecretSource item) {
            this.index = index;
            this.builder = new CertSecretSourceBuilder(this, item);
        }

        public N and() {
            return (N)KafkaAuthorizationOpaFluent.this.setToTlsTrustedCertificates(this.index, this.builder.build());
        }

        public N endTlsTrustedCertificate() {
            return this.and();
        }
    }
}

