/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.strimzi.api.kafka.model.ExternalLogging;
import io.strimzi.api.kafka.model.ExternalLoggingBuilder;
import io.strimzi.api.kafka.model.ExternalLoggingFluent;
import io.strimzi.api.kafka.model.InlineLogging;
import io.strimzi.api.kafka.model.InlineLoggingBuilder;
import io.strimzi.api.kafka.model.InlineLoggingFluent;
import io.strimzi.api.kafka.model.JmxPrometheusExporterMetrics;
import io.strimzi.api.kafka.model.JmxPrometheusExporterMetricsBuilder;
import io.strimzi.api.kafka.model.JmxPrometheusExporterMetricsFluent;
import io.strimzi.api.kafka.model.JvmOptions;
import io.strimzi.api.kafka.model.JvmOptionsBuilder;
import io.strimzi.api.kafka.model.JvmOptionsFluent;
import io.strimzi.api.kafka.model.KafkaAuthorization;
import io.strimzi.api.kafka.model.KafkaAuthorizationCustom;
import io.strimzi.api.kafka.model.KafkaAuthorizationCustomBuilder;
import io.strimzi.api.kafka.model.KafkaAuthorizationCustomFluent;
import io.strimzi.api.kafka.model.KafkaAuthorizationKeycloak;
import io.strimzi.api.kafka.model.KafkaAuthorizationKeycloakBuilder;
import io.strimzi.api.kafka.model.KafkaAuthorizationKeycloakFluent;
import io.strimzi.api.kafka.model.KafkaAuthorizationOpa;
import io.strimzi.api.kafka.model.KafkaAuthorizationOpaBuilder;
import io.strimzi.api.kafka.model.KafkaAuthorizationOpaFluent;
import io.strimzi.api.kafka.model.KafkaAuthorizationSimple;
import io.strimzi.api.kafka.model.KafkaAuthorizationSimpleBuilder;
import io.strimzi.api.kafka.model.KafkaAuthorizationSimpleFluent;
import io.strimzi.api.kafka.model.KafkaClusterSpec;
import io.strimzi.api.kafka.model.KafkaJmxOptions;
import io.strimzi.api.kafka.model.KafkaJmxOptionsBuilder;
import io.strimzi.api.kafka.model.KafkaJmxOptionsFluent;
import io.strimzi.api.kafka.model.Logging;
import io.strimzi.api.kafka.model.MetricsConfig;
import io.strimzi.api.kafka.model.Probe;
import io.strimzi.api.kafka.model.ProbeBuilder;
import io.strimzi.api.kafka.model.ProbeFluent;
import io.strimzi.api.kafka.model.Rack;
import io.strimzi.api.kafka.model.RackBuilder;
import io.strimzi.api.kafka.model.RackFluent;
import io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener;
import io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerBuilder;
import io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent;
import io.strimzi.api.kafka.model.storage.EphemeralStorage;
import io.strimzi.api.kafka.model.storage.EphemeralStorageBuilder;
import io.strimzi.api.kafka.model.storage.EphemeralStorageFluent;
import io.strimzi.api.kafka.model.storage.JbodStorage;
import io.strimzi.api.kafka.model.storage.JbodStorageBuilder;
import io.strimzi.api.kafka.model.storage.JbodStorageFluent;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorage;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorageBuilder;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluent;
import io.strimzi.api.kafka.model.storage.Storage;
import io.strimzi.api.kafka.model.template.KafkaClusterTemplate;
import io.strimzi.api.kafka.model.template.KafkaClusterTemplateBuilder;
import io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class KafkaClusterSpecFluent<A extends KafkaClusterSpecFluent<A>>
extends BaseFluent<A> {
    private VisitableBuilder<? extends Storage, ?> storage;
    private String version;
    private String metadataVersion;
    private Map<String, Object> config;
    private String brokerRackInitImage;
    private RackBuilder rack;
    private VisitableBuilder<? extends Logging, ?> logging;
    private int replicas;
    private String image;
    private ResourceRequirements resources;
    private ProbeBuilder livenessProbe;
    private ProbeBuilder readinessProbe;
    private JvmOptionsBuilder jvmOptions;
    private KafkaJmxOptionsBuilder jmxOptions;
    private VisitableBuilder<? extends MetricsConfig, ?> metricsConfig;
    private ArrayList<GenericKafkaListenerBuilder> listeners;
    private VisitableBuilder<? extends KafkaAuthorization, ?> authorization;
    private KafkaClusterTemplateBuilder template;

    public KafkaClusterSpecFluent() {
    }

    public KafkaClusterSpecFluent(KafkaClusterSpec instance) {
        KafkaClusterSpec kafkaClusterSpec = instance = instance != null ? instance : new KafkaClusterSpec();
        if (instance != null) {
            this.withStorage(instance.getStorage());
            this.withVersion(instance.getVersion());
            this.withMetadataVersion(instance.getMetadataVersion());
            this.withConfig(instance.getConfig());
            this.withBrokerRackInitImage(instance.getBrokerRackInitImage());
            this.withRack(instance.getRack());
            this.withLogging(instance.getLogging());
            this.withReplicas(instance.getReplicas());
            this.withImage(instance.getImage());
            this.withResources(instance.getResources());
            this.withLivenessProbe(instance.getLivenessProbe());
            this.withReadinessProbe(instance.getReadinessProbe());
            this.withJvmOptions(instance.getJvmOptions());
            this.withJmxOptions(instance.getJmxOptions());
            this.withMetricsConfig(instance.getMetricsConfig());
            this.withListeners(instance.getListeners());
            this.withAuthorization(instance.getAuthorization());
            this.withTemplate(instance.getTemplate());
        }
    }

    public Storage buildStorage() {
        return this.storage != null ? (Storage)this.storage.build() : null;
    }

    public A withStorage(Storage storage) {
        if (storage == null) {
            this.storage = null;
            this._visitables.remove((Object)"storage");
            return (A)((Object)this);
        }
        VisitableBuilder builder = KafkaClusterSpecFluent.builder(storage);
        this._visitables.get((Object)"storage").clear();
        this._visitables.get((Object)"storage").add(builder);
        this.storage = builder;
        return (A)((Object)this);
    }

    public boolean hasStorage() {
        return this.storage != null;
    }

    public PersistentClaimStorageNested<A> withNewPersistentClaimStorage() {
        return new PersistentClaimStorageNested(null);
    }

    public PersistentClaimStorageNested<A> withNewPersistentClaimStorageLike(PersistentClaimStorage item) {
        return new PersistentClaimStorageNested(item);
    }

    public EphemeralStorageNested<A> withNewEphemeralStorage() {
        return new EphemeralStorageNested(null);
    }

    public EphemeralStorageNested<A> withNewEphemeralStorageLike(EphemeralStorage item) {
        return new EphemeralStorageNested(item);
    }

    public JbodStorageNested<A> withNewJbodStorage() {
        return new JbodStorageNested(null);
    }

    public JbodStorageNested<A> withNewJbodStorageLike(JbodStorage item) {
        return new JbodStorageNested(item);
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version = version;
        return (A)((Object)this);
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public String getMetadataVersion() {
        return this.metadataVersion;
    }

    public A withMetadataVersion(String metadataVersion) {
        this.metadataVersion = metadataVersion;
        return (A)((Object)this);
    }

    public boolean hasMetadataVersion() {
        return this.metadataVersion != null;
    }

    public A addToConfig(String key, Object value) {
        if (this.config == null && key != null && value != null) {
            this.config = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.config.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToConfig(Map<String, Object> map) {
        if (this.config == null && map != null) {
            this.config = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.config.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromConfig(String key) {
        if (this.config == null) {
            return (A)((Object)this);
        }
        if (key != null && this.config != null) {
            this.config.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromConfig(Map<String, Object> map) {
        if (this.config == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.config == null) continue;
                this.config.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getConfig() {
        return this.config;
    }

    public <K, V> A withConfig(Map<String, Object> config) {
        this.config = config == null ? null : new LinkedHashMap<String, Object>(config);
        return (A)((Object)this);
    }

    public boolean hasConfig() {
        return this.config != null;
    }

    public String getBrokerRackInitImage() {
        return this.brokerRackInitImage;
    }

    public A withBrokerRackInitImage(String brokerRackInitImage) {
        this.brokerRackInitImage = brokerRackInitImage;
        return (A)((Object)this);
    }

    public boolean hasBrokerRackInitImage() {
        return this.brokerRackInitImage != null;
    }

    public Rack buildRack() {
        return this.rack != null ? this.rack.build() : null;
    }

    public A withRack(Rack rack) {
        this._visitables.get((Object)"rack").remove((Object)this.rack);
        if (rack != null) {
            this.rack = new RackBuilder(rack);
            this._visitables.get((Object)"rack").add(this.rack);
        } else {
            this.rack = null;
            this._visitables.get((Object)"rack").remove((Object)this.rack);
        }
        return (A)((Object)this);
    }

    public boolean hasRack() {
        return this.rack != null;
    }

    public A withNewRack(String topologyKey) {
        return this.withRack(new Rack(topologyKey));
    }

    public RackNested<A> withNewRack() {
        return new RackNested(null);
    }

    public RackNested<A> withNewRackLike(Rack item) {
        return new RackNested(item);
    }

    public RackNested<A> editRack() {
        return this.withNewRackLike(Optional.ofNullable(this.buildRack()).orElse(null));
    }

    public RackNested<A> editOrNewRack() {
        return this.withNewRackLike(Optional.ofNullable(this.buildRack()).orElse(new RackBuilder().build()));
    }

    public RackNested<A> editOrNewRackLike(Rack item) {
        return this.withNewRackLike(Optional.ofNullable(this.buildRack()).orElse(item));
    }

    public Logging buildLogging() {
        return this.logging != null ? (Logging)this.logging.build() : null;
    }

    public A withLogging(Logging logging) {
        if (logging == null) {
            this.logging = null;
            this._visitables.remove((Object)"logging");
            return (A)((Object)this);
        }
        VisitableBuilder builder = KafkaClusterSpecFluent.builder(logging);
        this._visitables.get((Object)"logging").clear();
        this._visitables.get((Object)"logging").add(builder);
        this.logging = builder;
        return (A)((Object)this);
    }

    public boolean hasLogging() {
        return this.logging != null;
    }

    public ExternalLoggingNested<A> withNewExternalLogging() {
        return new ExternalLoggingNested(null);
    }

    public ExternalLoggingNested<A> withNewExternalLoggingLike(ExternalLogging item) {
        return new ExternalLoggingNested(item);
    }

    public InlineLoggingNested<A> withNewInlineLogging() {
        return new InlineLoggingNested(null);
    }

    public InlineLoggingNested<A> withNewInlineLoggingLike(InlineLogging item) {
        return new InlineLoggingNested(item);
    }

    public int getReplicas() {
        return this.replicas;
    }

    public A withReplicas(int replicas) {
        this.replicas = replicas;
        return (A)((Object)this);
    }

    public boolean hasReplicas() {
        return true;
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image = image;
        return (A)((Object)this);
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public ResourceRequirements getResources() {
        return this.resources;
    }

    public A withResources(ResourceRequirements resources) {
        this.resources = resources;
        return (A)((Object)this);
    }

    public boolean hasResources() {
        return this.resources != null;
    }

    public Probe buildLivenessProbe() {
        return this.livenessProbe != null ? this.livenessProbe.build() : null;
    }

    public A withLivenessProbe(Probe livenessProbe) {
        this._visitables.get((Object)"livenessProbe").remove((Object)this.livenessProbe);
        if (livenessProbe != null) {
            this.livenessProbe = new ProbeBuilder(livenessProbe);
            this._visitables.get((Object)"livenessProbe").add(this.livenessProbe);
        } else {
            this.livenessProbe = null;
            this._visitables.get((Object)"livenessProbe").remove((Object)this.livenessProbe);
        }
        return (A)((Object)this);
    }

    public boolean hasLivenessProbe() {
        return this.livenessProbe != null;
    }

    public A withNewLivenessProbe(int initialDelaySeconds, int timeoutSeconds) {
        return this.withLivenessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    public LivenessProbeNested<A> withNewLivenessProbe() {
        return new LivenessProbeNested(null);
    }

    public LivenessProbeNested<A> withNewLivenessProbeLike(Probe item) {
        return new LivenessProbeNested(item);
    }

    public LivenessProbeNested<A> editLivenessProbe() {
        return this.withNewLivenessProbeLike(Optional.ofNullable(this.buildLivenessProbe()).orElse(null));
    }

    public LivenessProbeNested<A> editOrNewLivenessProbe() {
        return this.withNewLivenessProbeLike(Optional.ofNullable(this.buildLivenessProbe()).orElse(new ProbeBuilder().build()));
    }

    public LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item) {
        return this.withNewLivenessProbeLike(Optional.ofNullable(this.buildLivenessProbe()).orElse(item));
    }

    public Probe buildReadinessProbe() {
        return this.readinessProbe != null ? this.readinessProbe.build() : null;
    }

    public A withReadinessProbe(Probe readinessProbe) {
        this._visitables.get((Object)"readinessProbe").remove((Object)this.readinessProbe);
        if (readinessProbe != null) {
            this.readinessProbe = new ProbeBuilder(readinessProbe);
            this._visitables.get((Object)"readinessProbe").add(this.readinessProbe);
        } else {
            this.readinessProbe = null;
            this._visitables.get((Object)"readinessProbe").remove((Object)this.readinessProbe);
        }
        return (A)((Object)this);
    }

    public boolean hasReadinessProbe() {
        return this.readinessProbe != null;
    }

    public A withNewReadinessProbe(int initialDelaySeconds, int timeoutSeconds) {
        return this.withReadinessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    public ReadinessProbeNested<A> withNewReadinessProbe() {
        return new ReadinessProbeNested(null);
    }

    public ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item) {
        return new ReadinessProbeNested(item);
    }

    public ReadinessProbeNested<A> editReadinessProbe() {
        return this.withNewReadinessProbeLike(Optional.ofNullable(this.buildReadinessProbe()).orElse(null));
    }

    public ReadinessProbeNested<A> editOrNewReadinessProbe() {
        return this.withNewReadinessProbeLike(Optional.ofNullable(this.buildReadinessProbe()).orElse(new ProbeBuilder().build()));
    }

    public ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item) {
        return this.withNewReadinessProbeLike(Optional.ofNullable(this.buildReadinessProbe()).orElse(item));
    }

    public JvmOptions buildJvmOptions() {
        return this.jvmOptions != null ? this.jvmOptions.build() : null;
    }

    public A withJvmOptions(JvmOptions jvmOptions) {
        this._visitables.get((Object)"jvmOptions").remove((Object)this.jvmOptions);
        if (jvmOptions != null) {
            this.jvmOptions = new JvmOptionsBuilder(jvmOptions);
            this._visitables.get((Object)"jvmOptions").add(this.jvmOptions);
        } else {
            this.jvmOptions = null;
            this._visitables.get((Object)"jvmOptions").remove((Object)this.jvmOptions);
        }
        return (A)((Object)this);
    }

    public boolean hasJvmOptions() {
        return this.jvmOptions != null;
    }

    public JvmOptionsNested<A> withNewJvmOptions() {
        return new JvmOptionsNested(null);
    }

    public JvmOptionsNested<A> withNewJvmOptionsLike(JvmOptions item) {
        return new JvmOptionsNested(item);
    }

    public JvmOptionsNested<A> editJvmOptions() {
        return this.withNewJvmOptionsLike(Optional.ofNullable(this.buildJvmOptions()).orElse(null));
    }

    public JvmOptionsNested<A> editOrNewJvmOptions() {
        return this.withNewJvmOptionsLike(Optional.ofNullable(this.buildJvmOptions()).orElse(new JvmOptionsBuilder().build()));
    }

    public JvmOptionsNested<A> editOrNewJvmOptionsLike(JvmOptions item) {
        return this.withNewJvmOptionsLike(Optional.ofNullable(this.buildJvmOptions()).orElse(item));
    }

    public KafkaJmxOptions buildJmxOptions() {
        return this.jmxOptions != null ? this.jmxOptions.build() : null;
    }

    public A withJmxOptions(KafkaJmxOptions jmxOptions) {
        this._visitables.get((Object)"jmxOptions").remove((Object)this.jmxOptions);
        if (jmxOptions != null) {
            this.jmxOptions = new KafkaJmxOptionsBuilder(jmxOptions);
            this._visitables.get((Object)"jmxOptions").add(this.jmxOptions);
        } else {
            this.jmxOptions = null;
            this._visitables.get((Object)"jmxOptions").remove((Object)this.jmxOptions);
        }
        return (A)((Object)this);
    }

    public boolean hasJmxOptions() {
        return this.jmxOptions != null;
    }

    public JmxOptionsNested<A> withNewJmxOptions() {
        return new JmxOptionsNested(null);
    }

    public JmxOptionsNested<A> withNewJmxOptionsLike(KafkaJmxOptions item) {
        return new JmxOptionsNested(item);
    }

    public JmxOptionsNested<A> editJmxOptions() {
        return this.withNewJmxOptionsLike(Optional.ofNullable(this.buildJmxOptions()).orElse(null));
    }

    public JmxOptionsNested<A> editOrNewJmxOptions() {
        return this.withNewJmxOptionsLike(Optional.ofNullable(this.buildJmxOptions()).orElse(new KafkaJmxOptionsBuilder().build()));
    }

    public JmxOptionsNested<A> editOrNewJmxOptionsLike(KafkaJmxOptions item) {
        return this.withNewJmxOptionsLike(Optional.ofNullable(this.buildJmxOptions()).orElse(item));
    }

    public MetricsConfig buildMetricsConfig() {
        return this.metricsConfig != null ? (MetricsConfig)this.metricsConfig.build() : null;
    }

    public A withMetricsConfig(MetricsConfig metricsConfig) {
        if (metricsConfig == null) {
            this.metricsConfig = null;
            this._visitables.remove((Object)"metricsConfig");
            return (A)((Object)this);
        }
        VisitableBuilder builder = KafkaClusterSpecFluent.builder(metricsConfig);
        this._visitables.get((Object)"metricsConfig").clear();
        this._visitables.get((Object)"metricsConfig").add(builder);
        this.metricsConfig = builder;
        return (A)((Object)this);
    }

    public boolean hasMetricsConfig() {
        return this.metricsConfig != null;
    }

    public JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfig() {
        return new JmxPrometheusExporterMetricsConfigNested(null);
    }

    public JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfigLike(JmxPrometheusExporterMetrics item) {
        return new JmxPrometheusExporterMetricsConfigNested(item);
    }

    public A addToListeners(int index, GenericKafkaListener item) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        GenericKafkaListenerBuilder builder = new GenericKafkaListenerBuilder(item);
        if (index < 0 || index >= this.listeners.size()) {
            this._visitables.get((Object)"listeners").add(builder);
            this.listeners.add(builder);
        } else {
            this._visitables.get((Object)"listeners").add(index, builder);
            this.listeners.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToListeners(int index, GenericKafkaListener item) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        GenericKafkaListenerBuilder builder = new GenericKafkaListenerBuilder(item);
        if (index < 0 || index >= this.listeners.size()) {
            this._visitables.get((Object)"listeners").add(builder);
            this.listeners.add(builder);
        } else {
            this._visitables.get((Object)"listeners").set(index, builder);
            this.listeners.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToListeners(GenericKafkaListener ... items) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        for (GenericKafkaListener item : items) {
            GenericKafkaListenerBuilder builder = new GenericKafkaListenerBuilder(item);
            this._visitables.get((Object)"listeners").add(builder);
            this.listeners.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToListeners(Collection<GenericKafkaListener> items) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        for (GenericKafkaListener item : items) {
            GenericKafkaListenerBuilder builder = new GenericKafkaListenerBuilder(item);
            this._visitables.get((Object)"listeners").add(builder);
            this.listeners.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromListeners(GenericKafkaListener ... items) {
        if (this.listeners == null) {
            return (A)((Object)this);
        }
        for (GenericKafkaListener item : items) {
            GenericKafkaListenerBuilder builder = new GenericKafkaListenerBuilder(item);
            this._visitables.get((Object)"listeners").remove((Object)builder);
            this.listeners.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromListeners(Collection<GenericKafkaListener> items) {
        if (this.listeners == null) {
            return (A)((Object)this);
        }
        for (GenericKafkaListener item : items) {
            GenericKafkaListenerBuilder builder = new GenericKafkaListenerBuilder(item);
            this._visitables.get((Object)"listeners").remove((Object)builder);
            this.listeners.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromListeners(Predicate<GenericKafkaListenerBuilder> predicate) {
        if (this.listeners == null) {
            return (A)((Object)this);
        }
        Iterator<GenericKafkaListenerBuilder> each = this.listeners.iterator();
        List visitables = this._visitables.get((Object)"listeners");
        while (each.hasNext()) {
            GenericKafkaListenerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<GenericKafkaListener> buildListeners() {
        return this.listeners != null ? KafkaClusterSpecFluent.build(this.listeners) : null;
    }

    public GenericKafkaListener buildListener(int index) {
        return this.listeners.get(index).build();
    }

    public GenericKafkaListener buildFirstListener() {
        return this.listeners.get(0).build();
    }

    public GenericKafkaListener buildLastListener() {
        return this.listeners.get(this.listeners.size() - 1).build();
    }

    public GenericKafkaListener buildMatchingListener(Predicate<GenericKafkaListenerBuilder> predicate) {
        for (GenericKafkaListenerBuilder item : this.listeners) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingListener(Predicate<GenericKafkaListenerBuilder> predicate) {
        for (GenericKafkaListenerBuilder item : this.listeners) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withListeners(List<GenericKafkaListener> listeners) {
        if (this.listeners != null) {
            this._visitables.get((Object)"listeners").clear();
        }
        if (listeners != null) {
            this.listeners = new ArrayList();
            for (GenericKafkaListener item : listeners) {
                this.addToListeners(item);
            }
        } else {
            this.listeners = null;
        }
        return (A)((Object)this);
    }

    public A withListeners(GenericKafkaListener ... listeners) {
        if (this.listeners != null) {
            this.listeners.clear();
            this._visitables.remove((Object)"listeners");
        }
        if (listeners != null) {
            for (GenericKafkaListener item : listeners) {
                this.addToListeners(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasListeners() {
        return this.listeners != null && !this.listeners.isEmpty();
    }

    public ListenersNested<A> addNewListener() {
        return new ListenersNested(-1, null);
    }

    public ListenersNested<A> addNewListenerLike(GenericKafkaListener item) {
        return new ListenersNested(-1, item);
    }

    public ListenersNested<A> setNewListenerLike(int index, GenericKafkaListener item) {
        return new ListenersNested(index, item);
    }

    public ListenersNested<A> editListener(int index) {
        if (this.listeners.size() <= index) {
            throw new RuntimeException("Can't edit listeners. Index exceeds size.");
        }
        return this.setNewListenerLike(index, this.buildListener(index));
    }

    public ListenersNested<A> editFirstListener() {
        if (this.listeners.size() == 0) {
            throw new RuntimeException("Can't edit first listeners. The list is empty.");
        }
        return this.setNewListenerLike(0, this.buildListener(0));
    }

    public ListenersNested<A> editLastListener() {
        int index = this.listeners.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last listeners. The list is empty.");
        }
        return this.setNewListenerLike(index, this.buildListener(index));
    }

    public ListenersNested<A> editMatchingListener(Predicate<GenericKafkaListenerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.listeners.size(); ++i) {
            if (!predicate.test(this.listeners.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching listeners. No match found.");
        }
        return this.setNewListenerLike(index, this.buildListener(index));
    }

    public KafkaAuthorization buildAuthorization() {
        return this.authorization != null ? (KafkaAuthorization)this.authorization.build() : null;
    }

    public A withAuthorization(KafkaAuthorization authorization) {
        if (authorization == null) {
            this.authorization = null;
            this._visitables.remove((Object)"authorization");
            return (A)((Object)this);
        }
        VisitableBuilder builder = KafkaClusterSpecFluent.builder(authorization);
        this._visitables.get((Object)"authorization").clear();
        this._visitables.get((Object)"authorization").add(builder);
        this.authorization = builder;
        return (A)((Object)this);
    }

    public boolean hasAuthorization() {
        return this.authorization != null;
    }

    public KafkaAuthorizationOpaNested<A> withNewKafkaAuthorizationOpa() {
        return new KafkaAuthorizationOpaNested(null);
    }

    public KafkaAuthorizationOpaNested<A> withNewKafkaAuthorizationOpaLike(KafkaAuthorizationOpa item) {
        return new KafkaAuthorizationOpaNested(item);
    }

    public KafkaAuthorizationCustomNested<A> withNewKafkaAuthorizationCustom() {
        return new KafkaAuthorizationCustomNested(null);
    }

    public KafkaAuthorizationCustomNested<A> withNewKafkaAuthorizationCustomLike(KafkaAuthorizationCustom item) {
        return new KafkaAuthorizationCustomNested(item);
    }

    public KafkaAuthorizationKeycloakNested<A> withNewKafkaAuthorizationKeycloak() {
        return new KafkaAuthorizationKeycloakNested(null);
    }

    public KafkaAuthorizationKeycloakNested<A> withNewKafkaAuthorizationKeycloakLike(KafkaAuthorizationKeycloak item) {
        return new KafkaAuthorizationKeycloakNested(item);
    }

    public KafkaAuthorizationSimpleNested<A> withNewKafkaAuthorizationSimple() {
        return new KafkaAuthorizationSimpleNested(null);
    }

    public KafkaAuthorizationSimpleNested<A> withNewKafkaAuthorizationSimpleLike(KafkaAuthorizationSimple item) {
        return new KafkaAuthorizationSimpleNested(item);
    }

    public KafkaClusterTemplate buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    public A withTemplate(KafkaClusterTemplate template) {
        this._visitables.get((Object)"template").remove((Object)this.template);
        if (template != null) {
            this.template = new KafkaClusterTemplateBuilder(template);
            this._visitables.get((Object)"template").add(this.template);
        } else {
            this.template = null;
            this._visitables.get((Object)"template").remove((Object)this.template);
        }
        return (A)((Object)this);
    }

    public boolean hasTemplate() {
        return this.template != null;
    }

    public TemplateNested<A> withNewTemplate() {
        return new TemplateNested(null);
    }

    public TemplateNested<A> withNewTemplateLike(KafkaClusterTemplate item) {
        return new TemplateNested(item);
    }

    public TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(null));
    }

    public TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(new KafkaClusterTemplateBuilder().build()));
    }

    public TemplateNested<A> editOrNewTemplateLike(KafkaClusterTemplate item) {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaClusterSpecFluent that = (KafkaClusterSpecFluent)((Object)o);
        if (!Objects.equals(this.storage, that.storage)) {
            return false;
        }
        if (!Objects.equals(this.version, that.version)) {
            return false;
        }
        if (!Objects.equals(this.metadataVersion, that.metadataVersion)) {
            return false;
        }
        if (!Objects.equals(this.config, that.config)) {
            return false;
        }
        if (!Objects.equals(this.brokerRackInitImage, that.brokerRackInitImage)) {
            return false;
        }
        if (!Objects.equals((Object)this.rack, (Object)that.rack)) {
            return false;
        }
        if (!Objects.equals(this.logging, that.logging)) {
            return false;
        }
        if (this.replicas != that.replicas) {
            return false;
        }
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals(this.resources, that.resources)) {
            return false;
        }
        if (!Objects.equals((Object)this.livenessProbe, (Object)that.livenessProbe)) {
            return false;
        }
        if (!Objects.equals((Object)this.readinessProbe, (Object)that.readinessProbe)) {
            return false;
        }
        if (!Objects.equals((Object)this.jvmOptions, (Object)that.jvmOptions)) {
            return false;
        }
        if (!Objects.equals((Object)this.jmxOptions, (Object)that.jmxOptions)) {
            return false;
        }
        if (!Objects.equals(this.metricsConfig, that.metricsConfig)) {
            return false;
        }
        if (!Objects.equals(this.listeners, that.listeners)) {
            return false;
        }
        if (!Objects.equals(this.authorization, that.authorization)) {
            return false;
        }
        return Objects.equals((Object)this.template, (Object)that.template);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.storage, this.version, this.metadataVersion, this.config, this.brokerRackInitImage, this.rack, this.logging, this.replicas, this.image, this.resources, this.livenessProbe, this.readinessProbe, this.jvmOptions, this.jmxOptions, this.metricsConfig, this.listeners, this.authorization, this.template, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.storage != null) {
            sb.append("storage:");
            sb.append(this.storage + ",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version + ",");
        }
        if (this.metadataVersion != null) {
            sb.append("metadataVersion:");
            sb.append(this.metadataVersion + ",");
        }
        if (this.config != null && !this.config.isEmpty()) {
            sb.append("config:");
            sb.append(this.config + ",");
        }
        if (this.brokerRackInitImage != null) {
            sb.append("brokerRackInitImage:");
            sb.append(this.brokerRackInitImage + ",");
        }
        if (this.rack != null) {
            sb.append("rack:");
            sb.append(this.rack + ",");
        }
        if (this.logging != null) {
            sb.append("logging:");
            sb.append(this.logging + ",");
        }
        sb.append("replicas:");
        sb.append(this.replicas + ",");
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.livenessProbe != null) {
            sb.append("livenessProbe:");
            sb.append(this.livenessProbe + ",");
        }
        if (this.readinessProbe != null) {
            sb.append("readinessProbe:");
            sb.append(this.readinessProbe + ",");
        }
        if (this.jvmOptions != null) {
            sb.append("jvmOptions:");
            sb.append(this.jvmOptions + ",");
        }
        if (this.jmxOptions != null) {
            sb.append("jmxOptions:");
            sb.append(this.jmxOptions + ",");
        }
        if (this.metricsConfig != null) {
            sb.append("metricsConfig:");
            sb.append(this.metricsConfig + ",");
        }
        if (this.listeners != null && !this.listeners.isEmpty()) {
            sb.append("listeners:");
            sb.append(this.listeners + ",");
        }
        if (this.authorization != null) {
            sb.append("authorization:");
            sb.append(this.authorization + ",");
        }
        if (this.template != null) {
            sb.append("template:");
            sb.append((Object)this.template);
        }
        sb.append("}");
        return sb.toString();
    }

    protected static <T> VisitableBuilder<T, ?> builder(Object item) {
        switch (item.getClass().getName()) {
            case "io.strimzi.api.kafka.model.storage.PersistentClaimStorage": {
                return new PersistentClaimStorageBuilder((PersistentClaimStorage)item);
            }
            case "io.strimzi.api.kafka.model.storage.EphemeralStorage": {
                return new EphemeralStorageBuilder((EphemeralStorage)item);
            }
            case "io.strimzi.api.kafka.model.storage.JbodStorage": {
                return new JbodStorageBuilder((JbodStorage)item);
            }
            case "io.strimzi.api.kafka.model.ExternalLogging": {
                return new ExternalLoggingBuilder((ExternalLogging)item);
            }
            case "io.strimzi.api.kafka.model.InlineLogging": {
                return new InlineLoggingBuilder((InlineLogging)item);
            }
            case "io.strimzi.api.kafka.model.JmxPrometheusExporterMetrics": {
                return new JmxPrometheusExporterMetricsBuilder((JmxPrometheusExporterMetrics)item);
            }
            case "io.strimzi.api.kafka.model.KafkaAuthorizationOpa": {
                return new KafkaAuthorizationOpaBuilder((KafkaAuthorizationOpa)item);
            }
            case "io.strimzi.api.kafka.model.KafkaAuthorizationCustom": {
                return new KafkaAuthorizationCustomBuilder((KafkaAuthorizationCustom)item);
            }
            case "io.strimzi.api.kafka.model.KafkaAuthorizationKeycloak": {
                return new KafkaAuthorizationKeycloakBuilder((KafkaAuthorizationKeycloak)item);
            }
            case "io.strimzi.api.kafka.model.KafkaAuthorizationSimple": {
                return new KafkaAuthorizationSimpleBuilder((KafkaAuthorizationSimple)item);
            }
        }
        return KafkaClusterSpecFluent.builderOf((Object)item);
    }

    public class PersistentClaimStorageNested<N>
    extends PersistentClaimStorageFluent<PersistentClaimStorageNested<N>>
    implements Nested<N> {
        PersistentClaimStorageBuilder builder;

        PersistentClaimStorageNested(PersistentClaimStorage item) {
            this.builder = new PersistentClaimStorageBuilder(this, item);
        }

        public N and() {
            return (N)KafkaClusterSpecFluent.this.withStorage(this.builder.build());
        }

        public N endPersistentClaimStorage() {
            return this.and();
        }
    }

    public class EphemeralStorageNested<N>
    extends EphemeralStorageFluent<EphemeralStorageNested<N>>
    implements Nested<N> {
        EphemeralStorageBuilder builder;

        EphemeralStorageNested(EphemeralStorage item) {
            this.builder = new EphemeralStorageBuilder(this, item);
        }

        public N and() {
            return (N)KafkaClusterSpecFluent.this.withStorage(this.builder.build());
        }

        public N endEphemeralStorage() {
            return this.and();
        }
    }

    public class JbodStorageNested<N>
    extends JbodStorageFluent<JbodStorageNested<N>>
    implements Nested<N> {
        JbodStorageBuilder builder;

        JbodStorageNested(JbodStorage item) {
            this.builder = new JbodStorageBuilder(this, item);
        }

        public N and() {
            return (N)KafkaClusterSpecFluent.this.withStorage(this.builder.build());
        }

        public N endJbodStorage() {
            return this.and();
        }
    }

    public class RackNested<N>
    extends RackFluent<RackNested<N>>
    implements Nested<N> {
        RackBuilder builder;

        RackNested(Rack item) {
            this.builder = new RackBuilder(this, item);
        }

        public N and() {
            return (N)KafkaClusterSpecFluent.this.withRack(this.builder.build());
        }

        public N endRack() {
            return this.and();
        }
    }

    public class ExternalLoggingNested<N>
    extends ExternalLoggingFluent<ExternalLoggingNested<N>>
    implements Nested<N> {
        ExternalLoggingBuilder builder;

        ExternalLoggingNested(ExternalLogging item) {
            this.builder = new ExternalLoggingBuilder(this, item);
        }

        public N and() {
            return (N)KafkaClusterSpecFluent.this.withLogging(this.builder.build());
        }

        public N endExternalLogging() {
            return this.and();
        }
    }

    public class InlineLoggingNested<N>
    extends InlineLoggingFluent<InlineLoggingNested<N>>
    implements Nested<N> {
        InlineLoggingBuilder builder;

        InlineLoggingNested(InlineLogging item) {
            this.builder = new InlineLoggingBuilder(this, item);
        }

        public N and() {
            return (N)KafkaClusterSpecFluent.this.withLogging(this.builder.build());
        }

        public N endInlineLogging() {
            return this.and();
        }
    }

    public class LivenessProbeNested<N>
    extends ProbeFluent<LivenessProbeNested<N>>
    implements Nested<N> {
        ProbeBuilder builder;

        LivenessProbeNested(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        public N and() {
            return (N)KafkaClusterSpecFluent.this.withLivenessProbe(this.builder.build());
        }

        public N endLivenessProbe() {
            return this.and();
        }
    }

    public class ReadinessProbeNested<N>
    extends ProbeFluent<ReadinessProbeNested<N>>
    implements Nested<N> {
        ProbeBuilder builder;

        ReadinessProbeNested(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        public N and() {
            return (N)KafkaClusterSpecFluent.this.withReadinessProbe(this.builder.build());
        }

        public N endReadinessProbe() {
            return this.and();
        }
    }

    public class JvmOptionsNested<N>
    extends JvmOptionsFluent<JvmOptionsNested<N>>
    implements Nested<N> {
        JvmOptionsBuilder builder;

        JvmOptionsNested(JvmOptions item) {
            this.builder = new JvmOptionsBuilder(this, item);
        }

        public N and() {
            return (N)KafkaClusterSpecFluent.this.withJvmOptions(this.builder.build());
        }

        public N endJvmOptions() {
            return this.and();
        }
    }

    public class JmxOptionsNested<N>
    extends KafkaJmxOptionsFluent<JmxOptionsNested<N>>
    implements Nested<N> {
        KafkaJmxOptionsBuilder builder;

        JmxOptionsNested(KafkaJmxOptions item) {
            this.builder = new KafkaJmxOptionsBuilder(this, item);
        }

        public N and() {
            return (N)KafkaClusterSpecFluent.this.withJmxOptions(this.builder.build());
        }

        public N endJmxOptions() {
            return this.and();
        }
    }

    public class JmxPrometheusExporterMetricsConfigNested<N>
    extends JmxPrometheusExporterMetricsFluent<JmxPrometheusExporterMetricsConfigNested<N>>
    implements Nested<N> {
        JmxPrometheusExporterMetricsBuilder builder;

        JmxPrometheusExporterMetricsConfigNested(JmxPrometheusExporterMetrics item) {
            this.builder = new JmxPrometheusExporterMetricsBuilder(this, item);
        }

        public N and() {
            return (N)KafkaClusterSpecFluent.this.withMetricsConfig(this.builder.build());
        }

        public N endJmxPrometheusExporterMetricsConfig() {
            return this.and();
        }
    }

    public class ListenersNested<N>
    extends GenericKafkaListenerFluent<ListenersNested<N>>
    implements Nested<N> {
        GenericKafkaListenerBuilder builder;
        int index;

        ListenersNested(int index, GenericKafkaListener item) {
            this.index = index;
            this.builder = new GenericKafkaListenerBuilder(this, item);
        }

        public N and() {
            return (N)KafkaClusterSpecFluent.this.setToListeners(this.index, this.builder.build());
        }

        public N endListener() {
            return this.and();
        }
    }

    public class KafkaAuthorizationOpaNested<N>
    extends KafkaAuthorizationOpaFluent<KafkaAuthorizationOpaNested<N>>
    implements Nested<N> {
        KafkaAuthorizationOpaBuilder builder;

        KafkaAuthorizationOpaNested(KafkaAuthorizationOpa item) {
            this.builder = new KafkaAuthorizationOpaBuilder(this, item);
        }

        public N and() {
            return (N)KafkaClusterSpecFluent.this.withAuthorization(this.builder.build());
        }

        public N endKafkaAuthorizationOpa() {
            return this.and();
        }
    }

    public class KafkaAuthorizationCustomNested<N>
    extends KafkaAuthorizationCustomFluent<KafkaAuthorizationCustomNested<N>>
    implements Nested<N> {
        KafkaAuthorizationCustomBuilder builder;

        KafkaAuthorizationCustomNested(KafkaAuthorizationCustom item) {
            this.builder = new KafkaAuthorizationCustomBuilder(this, item);
        }

        public N and() {
            return (N)KafkaClusterSpecFluent.this.withAuthorization(this.builder.build());
        }

        public N endKafkaAuthorizationCustom() {
            return this.and();
        }
    }

    public class KafkaAuthorizationKeycloakNested<N>
    extends KafkaAuthorizationKeycloakFluent<KafkaAuthorizationKeycloakNested<N>>
    implements Nested<N> {
        KafkaAuthorizationKeycloakBuilder builder;

        KafkaAuthorizationKeycloakNested(KafkaAuthorizationKeycloak item) {
            this.builder = new KafkaAuthorizationKeycloakBuilder(this, item);
        }

        public N and() {
            return (N)KafkaClusterSpecFluent.this.withAuthorization(this.builder.build());
        }

        public N endKafkaAuthorizationKeycloak() {
            return this.and();
        }
    }

    public class KafkaAuthorizationSimpleNested<N>
    extends KafkaAuthorizationSimpleFluent<KafkaAuthorizationSimpleNested<N>>
    implements Nested<N> {
        KafkaAuthorizationSimpleBuilder builder;

        KafkaAuthorizationSimpleNested(KafkaAuthorizationSimple item) {
            this.builder = new KafkaAuthorizationSimpleBuilder(this, item);
        }

        public N and() {
            return (N)KafkaClusterSpecFluent.this.withAuthorization(this.builder.build());
        }

        public N endKafkaAuthorizationSimple() {
            return this.and();
        }
    }

    public class TemplateNested<N>
    extends KafkaClusterTemplateFluent<TemplateNested<N>>
    implements Nested<N> {
        KafkaClusterTemplateBuilder builder;

        TemplateNested(KafkaClusterTemplate item) {
            this.builder = new KafkaClusterTemplateBuilder(this, item);
        }

        public N and() {
            return (N)KafkaClusterSpecFluent.this.withTemplate(this.builder.build());
        }

        public N endTemplate() {
            return this.and();
        }
    }
}

