/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.client.CustomResourceFluent;
import io.strimzi.api.kafka.model.KafkaConnector;
import io.strimzi.api.kafka.model.KafkaConnectorSpec;
import io.strimzi.api.kafka.model.KafkaConnectorSpecBuilder;
import io.strimzi.api.kafka.model.KafkaConnectorSpecFluent;
import io.strimzi.api.kafka.model.status.KafkaConnectorStatus;
import io.strimzi.api.kafka.model.status.KafkaConnectorStatusBuilder;
import io.strimzi.api.kafka.model.status.KafkaConnectorStatusFluent;
import java.util.Objects;
import java.util.Optional;

public class KafkaConnectorFluent<A extends KafkaConnectorFluent<A>>
extends CustomResourceFluent<KafkaConnectorSpec, KafkaConnectorStatus, A> {
    private String apiVersion;
    private String kind;
    private KafkaConnectorSpecBuilder spec;
    private KafkaConnectorStatusBuilder status;

    public KafkaConnectorFluent() {
    }

    public KafkaConnectorFluent(KafkaConnector instance) {
        KafkaConnector kafkaConnector = instance = instance != null ? instance : new KafkaConnector();
        if (instance != null) {
            this.withSpec(instance.getSpec());
            this.withStatus(instance.getStatus());
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withSpec(instance.getSpec());
            this.withStatus(instance.getStatus());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)((Object)this);
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public KafkaConnectorSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    public A withSpec(KafkaConnectorSpec spec) {
        this._visitables.get((Object)"spec").remove((Object)this.spec);
        if (spec != null) {
            this.spec = new KafkaConnectorSpecBuilder(spec);
            this._visitables.get((Object)"spec").add(this.spec);
        } else {
            this.spec = null;
            this._visitables.get((Object)"spec").remove((Object)this.spec);
        }
        return (A)((Object)this);
    }

    public boolean hasSpec() {
        return this.spec != null;
    }

    public SpecNested<A> withNewSpec() {
        return new SpecNested(null);
    }

    public SpecNested<A> withNewSpecLike(KafkaConnectorSpec item) {
        return new SpecNested(item);
    }

    public SpecNested<A> editSpec() {
        return this.withNewSpecLike(Optional.ofNullable(this.buildSpec()).orElse(null));
    }

    public SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(Optional.ofNullable(this.buildSpec()).orElse(new KafkaConnectorSpecBuilder().build()));
    }

    public SpecNested<A> editOrNewSpecLike(KafkaConnectorSpec item) {
        return this.withNewSpecLike(Optional.ofNullable(this.buildSpec()).orElse(item));
    }

    public KafkaConnectorStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    public A withStatus(KafkaConnectorStatus status) {
        this._visitables.get((Object)"status").remove((Object)this.status);
        if (status != null) {
            this.status = new KafkaConnectorStatusBuilder(status);
            this._visitables.get((Object)"status").add(this.status);
        } else {
            this.status = null;
            this._visitables.get((Object)"status").remove((Object)this.status);
        }
        return (A)((Object)this);
    }

    public boolean hasStatus() {
        return this.status != null;
    }

    public StatusNested<A> withNewStatus() {
        return new StatusNested(null);
    }

    public StatusNested<A> withNewStatusLike(KafkaConnectorStatus item) {
        return new StatusNested(item);
    }

    public StatusNested<A> editStatus() {
        return this.withNewStatusLike(Optional.ofNullable(this.buildStatus()).orElse(null));
    }

    public StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(Optional.ofNullable(this.buildStatus()).orElse(new KafkaConnectorStatusBuilder().build()));
    }

    public StatusNested<A> editOrNewStatusLike(KafkaConnectorStatus item) {
        return this.withNewStatusLike(Optional.ofNullable(this.buildStatus()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaConnectorFluent that = (KafkaConnectorFluent)((Object)o);
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals((Object)this.spec, (Object)that.spec)) {
            return false;
        }
        return Objects.equals((Object)this.status, (Object)that.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.apiVersion, this.kind, this.spec, this.status, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.spec != null) {
            sb.append("spec:");
            sb.append(this.spec + ",");
        }
        if (this.status != null) {
            sb.append("status:");
            sb.append((Object)this.status);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SpecNested<N>
    extends KafkaConnectorSpecFluent<SpecNested<N>>
    implements Nested<N> {
        KafkaConnectorSpecBuilder builder;

        SpecNested(KafkaConnectorSpec item) {
            this.builder = new KafkaConnectorSpecBuilder(this, item);
        }

        public N and() {
            return (N)KafkaConnectorFluent.this.withSpec(this.builder.build());
        }

        public N endSpec() {
            return this.and();
        }
    }

    public class StatusNested<N>
    extends KafkaConnectorStatusFluent<StatusNested<N>>
    implements Nested<N> {
        KafkaConnectorStatusBuilder builder;

        StatusNested(KafkaConnectorStatus item) {
            this.builder = new KafkaConnectorStatusBuilder(this, item);
        }

        public N and() {
            return (N)KafkaConnectorFluent.this.withStatus(this.builder.build());
        }

        public N endStatus() {
            return this.and();
        }
    }
}

