/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.annotations.DeprecatedProperty;
import io.strimzi.api.kafka.model.KafkaMirrorMaker2ConnectorSpec;
import io.strimzi.api.kafka.model.UnknownPropertyPreserving;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.PresentInVersions;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"sourceCluster", "targetCluster", "sourceConnector", "heartbeatConnector", "checkpointConnector", "topicsPattern", "topicsBlacklistPattern", "topicsExcludePattern", "groupsPattern", "groupsBlacklistPattern", "groupsExcludePattern"})
public class KafkaMirrorMaker2MirrorSpec
implements Serializable,
UnknownPropertyPreserving {
    private static final long serialVersionUID = 1L;
    private String sourceCluster;
    private String targetCluster;
    private KafkaMirrorMaker2ConnectorSpec sourceConnector;
    private KafkaMirrorMaker2ConnectorSpec checkpointConnector;
    private KafkaMirrorMaker2ConnectorSpec heartbeatConnector;
    private String topicsPattern;
    private String topicsBlacklistPattern;
    private String topicsExcludePattern;
    private String groupsPattern;
    private String groupsBlacklistPattern;
    private String groupsExcludePattern;
    private Map<String, Object> additionalProperties;

    @Description(value="A regular expression matching the topics to be mirrored, for example, \"topic1|topic2|topic3\". Comma-separated lists are also supported.")
    public String getTopicsPattern() {
        return this.topicsPattern;
    }

    public void setTopicsPattern(String topicsPattern) {
        this.topicsPattern = topicsPattern;
    }

    @DeprecatedProperty(movedToPath=".spec.mirrors.topicsExcludePattern")
    @PresentInVersions(value="v1alpha1-v1beta2")
    @Deprecated
    @Description(value="A regular expression matching the topics to exclude from mirroring. Comma-separated lists are also supported.")
    public String getTopicsBlacklistPattern() {
        return this.topicsBlacklistPattern;
    }

    public void setTopicsBlacklistPattern(String topicsBlacklistPattern) {
        this.topicsBlacklistPattern = topicsBlacklistPattern;
    }

    @Description(value="A regular expression matching the topics to exclude from mirroring. Comma-separated lists are also supported.")
    public String getTopicsExcludePattern() {
        return this.topicsExcludePattern;
    }

    public void setTopicsExcludePattern(String topicsExcludePattern) {
        this.topicsExcludePattern = topicsExcludePattern;
    }

    @Description(value="A regular expression matching the consumer groups to be mirrored. Comma-separated lists are also supported.")
    public String getGroupsPattern() {
        return this.groupsPattern;
    }

    public void setGroupsPattern(String groupsPattern) {
        this.groupsPattern = groupsPattern;
    }

    @DeprecatedProperty(movedToPath=".spec.mirrors.groupsExcludePattern")
    @PresentInVersions(value="v1alpha1-v1beta2")
    @Deprecated
    @Description(value="A regular expression matching the consumer groups to exclude from mirroring. Comma-separated lists are also supported.")
    public String getGroupsBlacklistPattern() {
        return this.groupsBlacklistPattern;
    }

    public void setGroupsBlacklistPattern(String groupsBlacklistPattern) {
        this.groupsBlacklistPattern = groupsBlacklistPattern;
    }

    @Description(value="A regular expression matching the consumer groups to exclude from mirroring. Comma-separated lists are also supported.")
    public String getGroupsExcludePattern() {
        return this.groupsExcludePattern;
    }

    public void setGroupsExcludePattern(String groupsExcludePattern) {
        this.groupsExcludePattern = groupsExcludePattern;
    }

    @Description(value="The alias of the source cluster used by the Kafka MirrorMaker 2 connectors. The alias must match a cluster in the list at `spec.clusters`.")
    @JsonProperty(required=true)
    public String getSourceCluster() {
        return this.sourceCluster;
    }

    public void setSourceCluster(String sourceCluster) {
        this.sourceCluster = sourceCluster;
    }

    @Description(value="The alias of the target cluster used by the Kafka MirrorMaker 2 connectors. The alias must match a cluster in the list at `spec.clusters`.")
    @JsonProperty(required=true)
    public String getTargetCluster() {
        return this.targetCluster;
    }

    public void setTargetCluster(String targetCluster) {
        this.targetCluster = targetCluster;
    }

    @Description(value="The specification of the Kafka MirrorMaker 2 source connector.")
    public KafkaMirrorMaker2ConnectorSpec getSourceConnector() {
        return this.sourceConnector;
    }

    public void setSourceConnector(KafkaMirrorMaker2ConnectorSpec sourceConnector) {
        this.sourceConnector = sourceConnector;
    }

    @Description(value="The specification of the Kafka MirrorMaker 2 checkpoint connector.")
    public KafkaMirrorMaker2ConnectorSpec getCheckpointConnector() {
        return this.checkpointConnector;
    }

    public void setCheckpointConnector(KafkaMirrorMaker2ConnectorSpec checkpointConnector) {
        this.checkpointConnector = checkpointConnector;
    }

    @Description(value="The specification of the Kafka MirrorMaker 2 heartbeat connector.")
    public KafkaMirrorMaker2ConnectorSpec getHeartbeatConnector() {
        return this.heartbeatConnector;
    }

    public void setHeartbeatConnector(KafkaMirrorMaker2ConnectorSpec heartbeatConnector) {
        this.heartbeatConnector = heartbeatConnector;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties != null ? this.additionalProperties : Collections.emptyMap();
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>(1);
        }
        this.additionalProperties.put(name, value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaMirrorMaker2MirrorSpec)) {
            return false;
        }
        KafkaMirrorMaker2MirrorSpec other = (KafkaMirrorMaker2MirrorSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$sourceCluster = this.getSourceCluster();
        String other$sourceCluster = other.getSourceCluster();
        if (this$sourceCluster == null ? other$sourceCluster != null : !this$sourceCluster.equals(other$sourceCluster)) {
            return false;
        }
        String this$targetCluster = this.getTargetCluster();
        String other$targetCluster = other.getTargetCluster();
        if (this$targetCluster == null ? other$targetCluster != null : !this$targetCluster.equals(other$targetCluster)) {
            return false;
        }
        KafkaMirrorMaker2ConnectorSpec this$sourceConnector = this.getSourceConnector();
        KafkaMirrorMaker2ConnectorSpec other$sourceConnector = other.getSourceConnector();
        if (this$sourceConnector == null ? other$sourceConnector != null : !((Object)this$sourceConnector).equals(other$sourceConnector)) {
            return false;
        }
        KafkaMirrorMaker2ConnectorSpec this$checkpointConnector = this.getCheckpointConnector();
        KafkaMirrorMaker2ConnectorSpec other$checkpointConnector = other.getCheckpointConnector();
        if (this$checkpointConnector == null ? other$checkpointConnector != null : !((Object)this$checkpointConnector).equals(other$checkpointConnector)) {
            return false;
        }
        KafkaMirrorMaker2ConnectorSpec this$heartbeatConnector = this.getHeartbeatConnector();
        KafkaMirrorMaker2ConnectorSpec other$heartbeatConnector = other.getHeartbeatConnector();
        if (this$heartbeatConnector == null ? other$heartbeatConnector != null : !((Object)this$heartbeatConnector).equals(other$heartbeatConnector)) {
            return false;
        }
        String this$topicsPattern = this.getTopicsPattern();
        String other$topicsPattern = other.getTopicsPattern();
        if (this$topicsPattern == null ? other$topicsPattern != null : !this$topicsPattern.equals(other$topicsPattern)) {
            return false;
        }
        String this$topicsBlacklistPattern = this.getTopicsBlacklistPattern();
        String other$topicsBlacklistPattern = other.getTopicsBlacklistPattern();
        if (this$topicsBlacklistPattern == null ? other$topicsBlacklistPattern != null : !this$topicsBlacklistPattern.equals(other$topicsBlacklistPattern)) {
            return false;
        }
        String this$topicsExcludePattern = this.getTopicsExcludePattern();
        String other$topicsExcludePattern = other.getTopicsExcludePattern();
        if (this$topicsExcludePattern == null ? other$topicsExcludePattern != null : !this$topicsExcludePattern.equals(other$topicsExcludePattern)) {
            return false;
        }
        String this$groupsPattern = this.getGroupsPattern();
        String other$groupsPattern = other.getGroupsPattern();
        if (this$groupsPattern == null ? other$groupsPattern != null : !this$groupsPattern.equals(other$groupsPattern)) {
            return false;
        }
        String this$groupsBlacklistPattern = this.getGroupsBlacklistPattern();
        String other$groupsBlacklistPattern = other.getGroupsBlacklistPattern();
        if (this$groupsBlacklistPattern == null ? other$groupsBlacklistPattern != null : !this$groupsBlacklistPattern.equals(other$groupsBlacklistPattern)) {
            return false;
        }
        String this$groupsExcludePattern = this.getGroupsExcludePattern();
        String other$groupsExcludePattern = other.getGroupsExcludePattern();
        if (this$groupsExcludePattern == null ? other$groupsExcludePattern != null : !this$groupsExcludePattern.equals(other$groupsExcludePattern)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaMirrorMaker2MirrorSpec;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sourceCluster = this.getSourceCluster();
        result = result * 59 + ($sourceCluster == null ? 43 : $sourceCluster.hashCode());
        String $targetCluster = this.getTargetCluster();
        result = result * 59 + ($targetCluster == null ? 43 : $targetCluster.hashCode());
        KafkaMirrorMaker2ConnectorSpec $sourceConnector = this.getSourceConnector();
        result = result * 59 + ($sourceConnector == null ? 43 : ((Object)$sourceConnector).hashCode());
        KafkaMirrorMaker2ConnectorSpec $checkpointConnector = this.getCheckpointConnector();
        result = result * 59 + ($checkpointConnector == null ? 43 : ((Object)$checkpointConnector).hashCode());
        KafkaMirrorMaker2ConnectorSpec $heartbeatConnector = this.getHeartbeatConnector();
        result = result * 59 + ($heartbeatConnector == null ? 43 : ((Object)$heartbeatConnector).hashCode());
        String $topicsPattern = this.getTopicsPattern();
        result = result * 59 + ($topicsPattern == null ? 43 : $topicsPattern.hashCode());
        String $topicsBlacklistPattern = this.getTopicsBlacklistPattern();
        result = result * 59 + ($topicsBlacklistPattern == null ? 43 : $topicsBlacklistPattern.hashCode());
        String $topicsExcludePattern = this.getTopicsExcludePattern();
        result = result * 59 + ($topicsExcludePattern == null ? 43 : $topicsExcludePattern.hashCode());
        String $groupsPattern = this.getGroupsPattern();
        result = result * 59 + ($groupsPattern == null ? 43 : $groupsPattern.hashCode());
        String $groupsBlacklistPattern = this.getGroupsBlacklistPattern();
        result = result * 59 + ($groupsBlacklistPattern == null ? 43 : $groupsBlacklistPattern.hashCode());
        String $groupsExcludePattern = this.getGroupsExcludePattern();
        result = result * 59 + ($groupsExcludePattern == null ? 43 : $groupsExcludePattern.hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

