/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.KafkaRebalanceSpec;
import io.strimzi.api.kafka.model.SpecFluent;
import io.strimzi.api.kafka.model.balancing.KafkaRebalanceMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class KafkaRebalanceSpecFluent<A extends KafkaRebalanceSpecFluent<A>>
extends SpecFluent<A> {
    private KafkaRebalanceMode mode;
    private List<Integer> brokers;
    private List<String> goals;
    private boolean skipHardGoalCheck;
    private boolean rebalanceDisk;
    private String excludedTopics;
    private int concurrentPartitionMovementsPerBroker;
    private int concurrentIntraBrokerPartitionMovements;
    private int concurrentLeaderMovements;
    private long replicationThrottle;
    private List<String> replicaMovementStrategies;

    public KafkaRebalanceSpecFluent() {
    }

    public KafkaRebalanceSpecFluent(KafkaRebalanceSpec instance) {
        KafkaRebalanceSpec kafkaRebalanceSpec = instance = instance != null ? instance : new KafkaRebalanceSpec();
        if (instance != null) {
            this.withMode(instance.getMode());
            this.withBrokers(instance.getBrokers());
            this.withGoals(instance.getGoals());
            this.withSkipHardGoalCheck(instance.isSkipHardGoalCheck());
            this.withRebalanceDisk(instance.isRebalanceDisk());
            this.withExcludedTopics(instance.getExcludedTopics());
            this.withConcurrentPartitionMovementsPerBroker(instance.getConcurrentPartitionMovementsPerBroker());
            this.withConcurrentIntraBrokerPartitionMovements(instance.getConcurrentIntraBrokerPartitionMovements());
            this.withConcurrentLeaderMovements(instance.getConcurrentLeaderMovements());
            this.withReplicationThrottle(instance.getReplicationThrottle());
            this.withReplicaMovementStrategies(instance.getReplicaMovementStrategies());
        }
    }

    public KafkaRebalanceMode getMode() {
        return this.mode;
    }

    public A withMode(KafkaRebalanceMode mode) {
        this.mode = mode;
        return (A)((Object)this);
    }

    public boolean hasMode() {
        return this.mode != null;
    }

    public A addToBrokers(int index, Integer item) {
        if (this.brokers == null) {
            this.brokers = new ArrayList<Integer>();
        }
        this.brokers.add(index, item);
        return (A)((Object)this);
    }

    public A setToBrokers(int index, Integer item) {
        if (this.brokers == null) {
            this.brokers = new ArrayList<Integer>();
        }
        this.brokers.set(index, item);
        return (A)((Object)this);
    }

    public A addToBrokers(Integer ... items) {
        if (this.brokers == null) {
            this.brokers = new ArrayList<Integer>();
        }
        for (Integer item : items) {
            this.brokers.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToBrokers(Collection<Integer> items) {
        if (this.brokers == null) {
            this.brokers = new ArrayList<Integer>();
        }
        for (Integer item : items) {
            this.brokers.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromBrokers(Integer ... items) {
        if (this.brokers == null) {
            return (A)((Object)this);
        }
        for (Integer item : items) {
            this.brokers.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromBrokers(Collection<Integer> items) {
        if (this.brokers == null) {
            return (A)((Object)this);
        }
        for (Integer item : items) {
            this.brokers.remove(item);
        }
        return (A)((Object)this);
    }

    public List<Integer> getBrokers() {
        return this.brokers;
    }

    public Integer getBroker(int index) {
        return this.brokers.get(index);
    }

    public Integer getFirstBroker() {
        return this.brokers.get(0);
    }

    public Integer getLastBroker() {
        return this.brokers.get(this.brokers.size() - 1);
    }

    public Integer getMatchingBroker(Predicate<Integer> predicate) {
        for (Integer item : this.brokers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingBroker(Predicate<Integer> predicate) {
        for (Integer item : this.brokers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withBrokers(List<Integer> brokers) {
        if (brokers != null) {
            this.brokers = new ArrayList<Integer>();
            for (Integer item : brokers) {
                this.addToBrokers(item);
            }
        } else {
            this.brokers = null;
        }
        return (A)((Object)this);
    }

    public A withBrokers(Integer ... brokers) {
        if (this.brokers != null) {
            this.brokers.clear();
            this._visitables.remove((Object)"brokers");
        }
        if (brokers != null) {
            for (Integer item : brokers) {
                this.addToBrokers(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasBrokers() {
        return this.brokers != null && !this.brokers.isEmpty();
    }

    public A addToGoals(int index, String item) {
        if (this.goals == null) {
            this.goals = new ArrayList<String>();
        }
        this.goals.add(index, item);
        return (A)((Object)this);
    }

    public A setToGoals(int index, String item) {
        if (this.goals == null) {
            this.goals = new ArrayList<String>();
        }
        this.goals.set(index, item);
        return (A)((Object)this);
    }

    public A addToGoals(String ... items) {
        if (this.goals == null) {
            this.goals = new ArrayList<String>();
        }
        for (String item : items) {
            this.goals.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToGoals(Collection<String> items) {
        if (this.goals == null) {
            this.goals = new ArrayList<String>();
        }
        for (String item : items) {
            this.goals.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromGoals(String ... items) {
        if (this.goals == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.goals.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromGoals(Collection<String> items) {
        if (this.goals == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.goals.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getGoals() {
        return this.goals;
    }

    public String getGoal(int index) {
        return this.goals.get(index);
    }

    public String getFirstGoal() {
        return this.goals.get(0);
    }

    public String getLastGoal() {
        return this.goals.get(this.goals.size() - 1);
    }

    public String getMatchingGoal(Predicate<String> predicate) {
        for (String item : this.goals) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingGoal(Predicate<String> predicate) {
        for (String item : this.goals) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withGoals(List<String> goals) {
        if (goals != null) {
            this.goals = new ArrayList<String>();
            for (String item : goals) {
                this.addToGoals(item);
            }
        } else {
            this.goals = null;
        }
        return (A)((Object)this);
    }

    public A withGoals(String ... goals) {
        if (this.goals != null) {
            this.goals.clear();
            this._visitables.remove((Object)"goals");
        }
        if (goals != null) {
            for (String item : goals) {
                this.addToGoals(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasGoals() {
        return this.goals != null && !this.goals.isEmpty();
    }

    public boolean isSkipHardGoalCheck() {
        return this.skipHardGoalCheck;
    }

    public A withSkipHardGoalCheck(boolean skipHardGoalCheck) {
        this.skipHardGoalCheck = skipHardGoalCheck;
        return (A)((Object)this);
    }

    public boolean hasSkipHardGoalCheck() {
        return true;
    }

    public boolean isRebalanceDisk() {
        return this.rebalanceDisk;
    }

    public A withRebalanceDisk(boolean rebalanceDisk) {
        this.rebalanceDisk = rebalanceDisk;
        return (A)((Object)this);
    }

    public boolean hasRebalanceDisk() {
        return true;
    }

    public String getExcludedTopics() {
        return this.excludedTopics;
    }

    public A withExcludedTopics(String excludedTopics) {
        this.excludedTopics = excludedTopics;
        return (A)((Object)this);
    }

    public boolean hasExcludedTopics() {
        return this.excludedTopics != null;
    }

    public int getConcurrentPartitionMovementsPerBroker() {
        return this.concurrentPartitionMovementsPerBroker;
    }

    public A withConcurrentPartitionMovementsPerBroker(int concurrentPartitionMovementsPerBroker) {
        this.concurrentPartitionMovementsPerBroker = concurrentPartitionMovementsPerBroker;
        return (A)((Object)this);
    }

    public boolean hasConcurrentPartitionMovementsPerBroker() {
        return true;
    }

    public int getConcurrentIntraBrokerPartitionMovements() {
        return this.concurrentIntraBrokerPartitionMovements;
    }

    public A withConcurrentIntraBrokerPartitionMovements(int concurrentIntraBrokerPartitionMovements) {
        this.concurrentIntraBrokerPartitionMovements = concurrentIntraBrokerPartitionMovements;
        return (A)((Object)this);
    }

    public boolean hasConcurrentIntraBrokerPartitionMovements() {
        return true;
    }

    public int getConcurrentLeaderMovements() {
        return this.concurrentLeaderMovements;
    }

    public A withConcurrentLeaderMovements(int concurrentLeaderMovements) {
        this.concurrentLeaderMovements = concurrentLeaderMovements;
        return (A)((Object)this);
    }

    public boolean hasConcurrentLeaderMovements() {
        return true;
    }

    public long getReplicationThrottle() {
        return this.replicationThrottle;
    }

    public A withReplicationThrottle(long replicationThrottle) {
        this.replicationThrottle = replicationThrottle;
        return (A)((Object)this);
    }

    public boolean hasReplicationThrottle() {
        return true;
    }

    public A addToReplicaMovementStrategies(int index, String item) {
        if (this.replicaMovementStrategies == null) {
            this.replicaMovementStrategies = new ArrayList<String>();
        }
        this.replicaMovementStrategies.add(index, item);
        return (A)((Object)this);
    }

    public A setToReplicaMovementStrategies(int index, String item) {
        if (this.replicaMovementStrategies == null) {
            this.replicaMovementStrategies = new ArrayList<String>();
        }
        this.replicaMovementStrategies.set(index, item);
        return (A)((Object)this);
    }

    public A addToReplicaMovementStrategies(String ... items) {
        if (this.replicaMovementStrategies == null) {
            this.replicaMovementStrategies = new ArrayList<String>();
        }
        for (String item : items) {
            this.replicaMovementStrategies.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToReplicaMovementStrategies(Collection<String> items) {
        if (this.replicaMovementStrategies == null) {
            this.replicaMovementStrategies = new ArrayList<String>();
        }
        for (String item : items) {
            this.replicaMovementStrategies.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromReplicaMovementStrategies(String ... items) {
        if (this.replicaMovementStrategies == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.replicaMovementStrategies.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromReplicaMovementStrategies(Collection<String> items) {
        if (this.replicaMovementStrategies == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.replicaMovementStrategies.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getReplicaMovementStrategies() {
        return this.replicaMovementStrategies;
    }

    public String getReplicaMovementStrategy(int index) {
        return this.replicaMovementStrategies.get(index);
    }

    public String getFirstReplicaMovementStrategy() {
        return this.replicaMovementStrategies.get(0);
    }

    public String getLastReplicaMovementStrategy() {
        return this.replicaMovementStrategies.get(this.replicaMovementStrategies.size() - 1);
    }

    public String getMatchingReplicaMovementStrategy(Predicate<String> predicate) {
        for (String item : this.replicaMovementStrategies) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingReplicaMovementStrategy(Predicate<String> predicate) {
        for (String item : this.replicaMovementStrategies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withReplicaMovementStrategies(List<String> replicaMovementStrategies) {
        if (replicaMovementStrategies != null) {
            this.replicaMovementStrategies = new ArrayList<String>();
            for (String item : replicaMovementStrategies) {
                this.addToReplicaMovementStrategies(item);
            }
        } else {
            this.replicaMovementStrategies = null;
        }
        return (A)((Object)this);
    }

    public A withReplicaMovementStrategies(String ... replicaMovementStrategies) {
        if (this.replicaMovementStrategies != null) {
            this.replicaMovementStrategies.clear();
            this._visitables.remove((Object)"replicaMovementStrategies");
        }
        if (replicaMovementStrategies != null) {
            for (String item : replicaMovementStrategies) {
                this.addToReplicaMovementStrategies(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasReplicaMovementStrategies() {
        return this.replicaMovementStrategies != null && !this.replicaMovementStrategies.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaRebalanceSpecFluent that = (KafkaRebalanceSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.mode, (Object)that.mode)) {
            return false;
        }
        if (!Objects.equals(this.brokers, that.brokers)) {
            return false;
        }
        if (!Objects.equals(this.goals, that.goals)) {
            return false;
        }
        if (this.skipHardGoalCheck != that.skipHardGoalCheck) {
            return false;
        }
        if (this.rebalanceDisk != that.rebalanceDisk) {
            return false;
        }
        if (!Objects.equals(this.excludedTopics, that.excludedTopics)) {
            return false;
        }
        if (this.concurrentPartitionMovementsPerBroker != that.concurrentPartitionMovementsPerBroker) {
            return false;
        }
        if (this.concurrentIntraBrokerPartitionMovements != that.concurrentIntraBrokerPartitionMovements) {
            return false;
        }
        if (this.concurrentLeaderMovements != that.concurrentLeaderMovements) {
            return false;
        }
        if (this.replicationThrottle != that.replicationThrottle) {
            return false;
        }
        return Objects.equals(this.replicaMovementStrategies, that.replicaMovementStrategies);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.mode, this.brokers, this.goals, this.skipHardGoalCheck, this.rebalanceDisk, this.excludedTopics, this.concurrentPartitionMovementsPerBroker, this.concurrentIntraBrokerPartitionMovements, this.concurrentLeaderMovements, this.replicationThrottle, this.replicaMovementStrategies, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.mode != null) {
            sb.append("mode:");
            sb.append(this.mode + ",");
        }
        if (this.brokers != null && !this.brokers.isEmpty()) {
            sb.append("brokers:");
            sb.append(this.brokers + ",");
        }
        if (this.goals != null && !this.goals.isEmpty()) {
            sb.append("goals:");
            sb.append(this.goals + ",");
        }
        sb.append("skipHardGoalCheck:");
        sb.append(this.skipHardGoalCheck + ",");
        sb.append("rebalanceDisk:");
        sb.append(this.rebalanceDisk + ",");
        if (this.excludedTopics != null) {
            sb.append("excludedTopics:");
            sb.append(this.excludedTopics + ",");
        }
        sb.append("concurrentPartitionMovementsPerBroker:");
        sb.append(this.concurrentPartitionMovementsPerBroker + ",");
        sb.append("concurrentIntraBrokerPartitionMovements:");
        sb.append(this.concurrentIntraBrokerPartitionMovements + ",");
        sb.append("concurrentLeaderMovements:");
        sb.append(this.concurrentLeaderMovements + ",");
        sb.append("replicationThrottle:");
        sb.append(this.replicationThrottle + ",");
        if (this.replicaMovementStrategies != null && !this.replicaMovementStrategies.isEmpty()) {
            sb.append("replicaMovementStrategies:");
            sb.append(this.replicaMovementStrategies);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withSkipHardGoalCheck() {
        return this.withSkipHardGoalCheck(true);
    }

    public A withRebalanceDisk() {
        return this.withRebalanceDisk(true);
    }
}

