/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.Sidecar;
import io.strimzi.api.kafka.model.SidecarFluent;

public class SidecarBuilder
extends SidecarFluent<SidecarBuilder>
implements VisitableBuilder<Sidecar, SidecarBuilder> {
    SidecarFluent<?> fluent;
    Boolean validationEnabled;

    public SidecarBuilder() {
        this(false);
    }

    public SidecarBuilder(Boolean validationEnabled) {
        this(new Sidecar(), validationEnabled);
    }

    public SidecarBuilder(SidecarFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public SidecarBuilder(SidecarFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Sidecar(), validationEnabled);
    }

    public SidecarBuilder(SidecarFluent<?> fluent, Sidecar instance) {
        this(fluent, instance, false);
    }

    public SidecarBuilder(SidecarFluent<?> fluent, Sidecar instance, Boolean validationEnabled) {
        this.fluent = fluent;
        Sidecar sidecar = instance = instance != null ? instance : new Sidecar();
        if (instance != null) {
            fluent.withImage(instance.getImage());
            fluent.withResources(instance.getResources());
        }
        this.validationEnabled = validationEnabled;
    }

    public SidecarBuilder(Sidecar instance) {
        this(instance, (Boolean)false);
    }

    public SidecarBuilder(Sidecar instance, Boolean validationEnabled) {
        this.fluent = this;
        Sidecar sidecar = instance = instance != null ? instance : new Sidecar();
        if (instance != null) {
            this.withImage(instance.getImage());
            this.withResources(instance.getResources());
        }
        this.validationEnabled = validationEnabled;
    }

    public Sidecar build() {
        Sidecar buildable = new Sidecar();
        buildable.setImage(this.fluent.getImage());
        buildable.setResources(this.fluent.getResources());
        return buildable;
    }
}

