/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.balancing;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.strimzi.api.kafka.model.balancing.BrokerCapacityOverride;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class BrokerCapacityOverrideFluent<A extends BrokerCapacityOverrideFluent<A>>
extends BaseFluent<A> {
    private List<Integer> brokers;
    private String cpu;
    private String inboundNetwork;
    private String outboundNetwork;

    public BrokerCapacityOverrideFluent() {
    }

    public BrokerCapacityOverrideFluent(BrokerCapacityOverride instance) {
        BrokerCapacityOverride brokerCapacityOverride = instance = instance != null ? instance : new BrokerCapacityOverride();
        if (instance != null) {
            this.withBrokers(instance.getBrokers());
            this.withCpu(instance.getCpu());
            this.withInboundNetwork(instance.getInboundNetwork());
            this.withOutboundNetwork(instance.getOutboundNetwork());
        }
    }

    public A addToBrokers(int index, Integer item) {
        if (this.brokers == null) {
            this.brokers = new ArrayList<Integer>();
        }
        this.brokers.add(index, item);
        return (A)((Object)this);
    }

    public A setToBrokers(int index, Integer item) {
        if (this.brokers == null) {
            this.brokers = new ArrayList<Integer>();
        }
        this.brokers.set(index, item);
        return (A)((Object)this);
    }

    public A addToBrokers(Integer ... items) {
        if (this.brokers == null) {
            this.brokers = new ArrayList<Integer>();
        }
        for (Integer item : items) {
            this.brokers.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToBrokers(Collection<Integer> items) {
        if (this.brokers == null) {
            this.brokers = new ArrayList<Integer>();
        }
        for (Integer item : items) {
            this.brokers.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromBrokers(Integer ... items) {
        if (this.brokers == null) {
            return (A)((Object)this);
        }
        for (Integer item : items) {
            this.brokers.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromBrokers(Collection<Integer> items) {
        if (this.brokers == null) {
            return (A)((Object)this);
        }
        for (Integer item : items) {
            this.brokers.remove(item);
        }
        return (A)((Object)this);
    }

    public List<Integer> getBrokers() {
        return this.brokers;
    }

    public Integer getBroker(int index) {
        return this.brokers.get(index);
    }

    public Integer getFirstBroker() {
        return this.brokers.get(0);
    }

    public Integer getLastBroker() {
        return this.brokers.get(this.brokers.size() - 1);
    }

    public Integer getMatchingBroker(Predicate<Integer> predicate) {
        for (Integer item : this.brokers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingBroker(Predicate<Integer> predicate) {
        for (Integer item : this.brokers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withBrokers(List<Integer> brokers) {
        if (brokers != null) {
            this.brokers = new ArrayList<Integer>();
            for (Integer item : brokers) {
                this.addToBrokers(item);
            }
        } else {
            this.brokers = null;
        }
        return (A)((Object)this);
    }

    public A withBrokers(Integer ... brokers) {
        if (this.brokers != null) {
            this.brokers.clear();
            this._visitables.remove((Object)"brokers");
        }
        if (brokers != null) {
            for (Integer item : brokers) {
                this.addToBrokers(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasBrokers() {
        return this.brokers != null && !this.brokers.isEmpty();
    }

    public String getCpu() {
        return this.cpu;
    }

    public A withCpu(String cpu) {
        this.cpu = cpu;
        return (A)((Object)this);
    }

    public boolean hasCpu() {
        return this.cpu != null;
    }

    public String getInboundNetwork() {
        return this.inboundNetwork;
    }

    public A withInboundNetwork(String inboundNetwork) {
        this.inboundNetwork = inboundNetwork;
        return (A)((Object)this);
    }

    public boolean hasInboundNetwork() {
        return this.inboundNetwork != null;
    }

    public String getOutboundNetwork() {
        return this.outboundNetwork;
    }

    public A withOutboundNetwork(String outboundNetwork) {
        this.outboundNetwork = outboundNetwork;
        return (A)((Object)this);
    }

    public boolean hasOutboundNetwork() {
        return this.outboundNetwork != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BrokerCapacityOverrideFluent that = (BrokerCapacityOverrideFluent)((Object)o);
        if (!Objects.equals(this.brokers, that.brokers)) {
            return false;
        }
        if (!Objects.equals(this.cpu, that.cpu)) {
            return false;
        }
        if (!Objects.equals(this.inboundNetwork, that.inboundNetwork)) {
            return false;
        }
        return Objects.equals(this.outboundNetwork, that.outboundNetwork);
    }

    public int hashCode() {
        return Objects.hash(this.brokers, this.cpu, this.inboundNetwork, this.outboundNetwork, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.brokers != null && !this.brokers.isEmpty()) {
            sb.append("brokers:");
            sb.append(this.brokers + ",");
        }
        if (this.cpu != null) {
            sb.append("cpu:");
            sb.append(this.cpu + ",");
        }
        if (this.inboundNetwork != null) {
            sb.append("inboundNetwork:");
            sb.append(this.inboundNetwork + ",");
        }
        if (this.outboundNetwork != null) {
            sb.append("outboundNetwork:");
            sb.append(this.outboundNetwork);
        }
        sb.append("}");
        return sb.toString();
    }
}

