/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.listener.arraylistener;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.UnknownPropertyPreserving;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.DescriptionFile;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@DescriptionFile
@JsonPropertyOrder(value={"broker", "advertisedHost", "advertisedPort", "host", "dnsAnnotations", "nodePort", "loadBalancerIP"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class GenericKafkaListenerConfigurationBroker
implements Serializable,
UnknownPropertyPreserving {
    private static final long serialVersionUID = 1L;
    private Integer broker;
    private String advertisedHost;
    private Integer advertisedPort;
    private String host;
    private Map<String, String> annotations = new HashMap<String, String>(0);
    private Map<String, String> labels = new HashMap<String, String>(0);
    private Integer nodePort;
    private String loadBalancerIP;
    private Map<String, Object> additionalProperties = new HashMap<String, Object>(0);

    @Description(value="ID of the kafka broker (broker identifier). Broker IDs start from 0 and correspond to the number of broker replicas.")
    @JsonProperty(required=true)
    public Integer getBroker() {
        return this.broker;
    }

    public void setBroker(Integer broker) {
        this.broker = broker;
    }

    @Description(value="The host name used in the brokers' `advertised.listeners`.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public String getAdvertisedHost() {
        return this.advertisedHost;
    }

    public void setAdvertisedHost(String advertisedHost) {
        this.advertisedHost = advertisedHost;
    }

    @Description(value="The port number used in the brokers' `advertised.listeners`.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getAdvertisedPort() {
        return this.advertisedPort;
    }

    public void setAdvertisedPort(Integer advertisedPort) {
        this.advertisedPort = advertisedPort;
    }

    @Description(value="The broker host. This field will be used in the Ingress resource or in the Route resource to specify the desired hostname. This field can be used only with `route` (optional) or `ingress` (required) type listeners.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    @Description(value="Annotations that will be added to the `Ingress` or `Service` resource. You can use this field to configure DNS providers such as External DNS. This field can be used only with `loadbalancer`, `nodeport`, or `ingress` type listeners.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Map<String, String> annotations) {
        this.annotations = annotations;
    }

    @Description(value="Labels that will be added to the `Ingress`, `Route`, or `Service` resource. This field can be used only with `loadbalancer`, `nodeport`, `route`, or `ingress` type listeners.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, String> getLabels() {
        return this.labels;
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    @Description(value="Node port for the per-broker service. This field can be used only with `nodeport` type listener.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getNodePort() {
        return this.nodePort;
    }

    public void setNodePort(Integer nodePort) {
        this.nodePort = nodePort;
    }

    @Description(value="The loadbalancer is requested with the IP address specified in this field. This feature depends on whether the underlying cloud provider supports specifying the `loadBalancerIP` when a load balancer is created. This field is ignored if the cloud provider does not support the feature.This field can be used only with `loadbalancer` type listener.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public String getLoadBalancerIP() {
        return this.loadBalancerIP;
    }

    public void setLoadBalancerIP(String loadBalancerIP) {
        this.loadBalancerIP = loadBalancerIP;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties != null ? this.additionalProperties : Collections.emptyMap();
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>(1);
        }
        this.additionalProperties.put(name, value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenericKafkaListenerConfigurationBroker)) {
            return false;
        }
        GenericKafkaListenerConfigurationBroker other = (GenericKafkaListenerConfigurationBroker)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$broker = this.getBroker();
        Integer other$broker = other.getBroker();
        if (this$broker == null ? other$broker != null : !((Object)this$broker).equals(other$broker)) {
            return false;
        }
        Integer this$advertisedPort = this.getAdvertisedPort();
        Integer other$advertisedPort = other.getAdvertisedPort();
        if (this$advertisedPort == null ? other$advertisedPort != null : !((Object)this$advertisedPort).equals(other$advertisedPort)) {
            return false;
        }
        Integer this$nodePort = this.getNodePort();
        Integer other$nodePort = other.getNodePort();
        if (this$nodePort == null ? other$nodePort != null : !((Object)this$nodePort).equals(other$nodePort)) {
            return false;
        }
        String this$advertisedHost = this.getAdvertisedHost();
        String other$advertisedHost = other.getAdvertisedHost();
        if (this$advertisedHost == null ? other$advertisedHost != null : !this$advertisedHost.equals(other$advertisedHost)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        Map<String, String> this$annotations = this.getAnnotations();
        Map<String, String> other$annotations = other.getAnnotations();
        if (this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations)) {
            return false;
        }
        Map<String, String> this$labels = this.getLabels();
        Map<String, String> other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
            return false;
        }
        String this$loadBalancerIP = this.getLoadBalancerIP();
        String other$loadBalancerIP = other.getLoadBalancerIP();
        if (this$loadBalancerIP == null ? other$loadBalancerIP != null : !this$loadBalancerIP.equals(other$loadBalancerIP)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GenericKafkaListenerConfigurationBroker;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $broker = this.getBroker();
        result = result * 59 + ($broker == null ? 43 : ((Object)$broker).hashCode());
        Integer $advertisedPort = this.getAdvertisedPort();
        result = result * 59 + ($advertisedPort == null ? 43 : ((Object)$advertisedPort).hashCode());
        Integer $nodePort = this.getNodePort();
        result = result * 59 + ($nodePort == null ? 43 : ((Object)$nodePort).hashCode());
        String $advertisedHost = this.getAdvertisedHost();
        result = result * 59 + ($advertisedHost == null ? 43 : $advertisedHost.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        Map<String, String> $annotations = this.getAnnotations();
        result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
        Map<String, String> $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        String $loadBalancerIP = this.getLoadBalancerIP();
        result = result * 59 + ($loadBalancerIP == null ? 43 : $loadBalancerIP.hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

