/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.nodepool;

import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.strimzi.api.kafka.model.JvmOptions;
import io.strimzi.api.kafka.model.JvmOptionsBuilder;
import io.strimzi.api.kafka.model.JvmOptionsFluent;
import io.strimzi.api.kafka.model.SpecFluent;
import io.strimzi.api.kafka.model.nodepool.KafkaNodePoolSpec;
import io.strimzi.api.kafka.model.nodepool.KafkaNodePoolTemplate;
import io.strimzi.api.kafka.model.nodepool.KafkaNodePoolTemplateBuilder;
import io.strimzi.api.kafka.model.nodepool.KafkaNodePoolTemplateFluent;
import io.strimzi.api.kafka.model.nodepool.ProcessRoles;
import io.strimzi.api.kafka.model.storage.EphemeralStorage;
import io.strimzi.api.kafka.model.storage.EphemeralStorageBuilder;
import io.strimzi.api.kafka.model.storage.EphemeralStorageFluent;
import io.strimzi.api.kafka.model.storage.JbodStorage;
import io.strimzi.api.kafka.model.storage.JbodStorageBuilder;
import io.strimzi.api.kafka.model.storage.JbodStorageFluent;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorage;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorageBuilder;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluent;
import io.strimzi.api.kafka.model.storage.Storage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class KafkaNodePoolSpecFluent<A extends KafkaNodePoolSpecFluent<A>>
extends SpecFluent<A> {
    private int replicas;
    private VisitableBuilder<? extends Storage, ?> storage;
    private List<ProcessRoles> roles;
    private ResourceRequirements resources;
    private JvmOptionsBuilder jvmOptions;
    private KafkaNodePoolTemplateBuilder template;

    public KafkaNodePoolSpecFluent() {
    }

    public KafkaNodePoolSpecFluent(KafkaNodePoolSpec instance) {
        KafkaNodePoolSpec kafkaNodePoolSpec = instance = instance != null ? instance : new KafkaNodePoolSpec();
        if (instance != null) {
            this.withReplicas(instance.getReplicas());
            this.withStorage(instance.getStorage());
            this.withRoles(instance.getRoles());
            this.withResources(instance.getResources());
            this.withJvmOptions(instance.getJvmOptions());
            this.withTemplate(instance.getTemplate());
        }
    }

    public int getReplicas() {
        return this.replicas;
    }

    public A withReplicas(int replicas) {
        this.replicas = replicas;
        return (A)((Object)this);
    }

    public boolean hasReplicas() {
        return true;
    }

    public Storage buildStorage() {
        return this.storage != null ? (Storage)this.storage.build() : null;
    }

    public A withStorage(Storage storage) {
        if (storage == null) {
            this.storage = null;
            this._visitables.remove((Object)"storage");
            return (A)((Object)this);
        }
        VisitableBuilder builder = KafkaNodePoolSpecFluent.builder(storage);
        this._visitables.get((Object)"storage").clear();
        this._visitables.get((Object)"storage").add(builder);
        this.storage = builder;
        return (A)((Object)this);
    }

    public boolean hasStorage() {
        return this.storage != null;
    }

    public PersistentClaimStorageNested<A> withNewPersistentClaimStorage() {
        return new PersistentClaimStorageNested(null);
    }

    public PersistentClaimStorageNested<A> withNewPersistentClaimStorageLike(PersistentClaimStorage item) {
        return new PersistentClaimStorageNested(item);
    }

    public EphemeralStorageNested<A> withNewEphemeralStorage() {
        return new EphemeralStorageNested(null);
    }

    public EphemeralStorageNested<A> withNewEphemeralStorageLike(EphemeralStorage item) {
        return new EphemeralStorageNested(item);
    }

    public JbodStorageNested<A> withNewJbodStorage() {
        return new JbodStorageNested(null);
    }

    public JbodStorageNested<A> withNewJbodStorageLike(JbodStorage item) {
        return new JbodStorageNested(item);
    }

    public A addToRoles(int index, ProcessRoles item) {
        if (this.roles == null) {
            this.roles = new ArrayList<ProcessRoles>();
        }
        this.roles.add(index, item);
        return (A)((Object)this);
    }

    public A setToRoles(int index, ProcessRoles item) {
        if (this.roles == null) {
            this.roles = new ArrayList<ProcessRoles>();
        }
        this.roles.set(index, item);
        return (A)((Object)this);
    }

    public A addToRoles(ProcessRoles ... items) {
        if (this.roles == null) {
            this.roles = new ArrayList<ProcessRoles>();
        }
        for (ProcessRoles item : items) {
            this.roles.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToRoles(Collection<ProcessRoles> items) {
        if (this.roles == null) {
            this.roles = new ArrayList<ProcessRoles>();
        }
        for (ProcessRoles item : items) {
            this.roles.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromRoles(ProcessRoles ... items) {
        if (this.roles == null) {
            return (A)((Object)this);
        }
        for (ProcessRoles item : items) {
            this.roles.remove((Object)item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromRoles(Collection<ProcessRoles> items) {
        if (this.roles == null) {
            return (A)((Object)this);
        }
        for (ProcessRoles item : items) {
            this.roles.remove((Object)item);
        }
        return (A)((Object)this);
    }

    public List<ProcessRoles> getRoles() {
        return this.roles;
    }

    public ProcessRoles getRole(int index) {
        return this.roles.get(index);
    }

    public ProcessRoles getFirstRole() {
        return this.roles.get(0);
    }

    public ProcessRoles getLastRole() {
        return this.roles.get(this.roles.size() - 1);
    }

    public ProcessRoles getMatchingRole(Predicate<ProcessRoles> predicate) {
        for (ProcessRoles item : this.roles) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingRole(Predicate<ProcessRoles> predicate) {
        for (ProcessRoles item : this.roles) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRoles(List<ProcessRoles> roles) {
        if (roles != null) {
            this.roles = new ArrayList<ProcessRoles>();
            for (ProcessRoles item : roles) {
                this.addToRoles(item);
            }
        } else {
            this.roles = null;
        }
        return (A)((Object)this);
    }

    public A withRoles(ProcessRoles ... roles) {
        if (this.roles != null) {
            this.roles.clear();
            this._visitables.remove((Object)"roles");
        }
        if (roles != null) {
            for (ProcessRoles item : roles) {
                this.addToRoles(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasRoles() {
        return this.roles != null && !this.roles.isEmpty();
    }

    public ResourceRequirements getResources() {
        return this.resources;
    }

    public A withResources(ResourceRequirements resources) {
        this.resources = resources;
        return (A)((Object)this);
    }

    public boolean hasResources() {
        return this.resources != null;
    }

    public JvmOptions buildJvmOptions() {
        return this.jvmOptions != null ? this.jvmOptions.build() : null;
    }

    public A withJvmOptions(JvmOptions jvmOptions) {
        this._visitables.get((Object)"jvmOptions").remove((Object)this.jvmOptions);
        if (jvmOptions != null) {
            this.jvmOptions = new JvmOptionsBuilder(jvmOptions);
            this._visitables.get((Object)"jvmOptions").add(this.jvmOptions);
        } else {
            this.jvmOptions = null;
            this._visitables.get((Object)"jvmOptions").remove((Object)this.jvmOptions);
        }
        return (A)((Object)this);
    }

    public boolean hasJvmOptions() {
        return this.jvmOptions != null;
    }

    public JvmOptionsNested<A> withNewJvmOptions() {
        return new JvmOptionsNested(null);
    }

    public JvmOptionsNested<A> withNewJvmOptionsLike(JvmOptions item) {
        return new JvmOptionsNested(item);
    }

    public JvmOptionsNested<A> editJvmOptions() {
        return this.withNewJvmOptionsLike(Optional.ofNullable(this.buildJvmOptions()).orElse(null));
    }

    public JvmOptionsNested<A> editOrNewJvmOptions() {
        return this.withNewJvmOptionsLike(Optional.ofNullable(this.buildJvmOptions()).orElse(new JvmOptionsBuilder().build()));
    }

    public JvmOptionsNested<A> editOrNewJvmOptionsLike(JvmOptions item) {
        return this.withNewJvmOptionsLike(Optional.ofNullable(this.buildJvmOptions()).orElse(item));
    }

    public KafkaNodePoolTemplate buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    public A withTemplate(KafkaNodePoolTemplate template) {
        this._visitables.get((Object)"template").remove((Object)this.template);
        if (template != null) {
            this.template = new KafkaNodePoolTemplateBuilder(template);
            this._visitables.get((Object)"template").add(this.template);
        } else {
            this.template = null;
            this._visitables.get((Object)"template").remove((Object)this.template);
        }
        return (A)((Object)this);
    }

    public boolean hasTemplate() {
        return this.template != null;
    }

    public TemplateNested<A> withNewTemplate() {
        return new TemplateNested(null);
    }

    public TemplateNested<A> withNewTemplateLike(KafkaNodePoolTemplate item) {
        return new TemplateNested(item);
    }

    public TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(null));
    }

    public TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(new KafkaNodePoolTemplateBuilder().build()));
    }

    public TemplateNested<A> editOrNewTemplateLike(KafkaNodePoolTemplate item) {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaNodePoolSpecFluent that = (KafkaNodePoolSpecFluent)((Object)o);
        if (this.replicas != that.replicas) {
            return false;
        }
        if (!Objects.equals(this.storage, that.storage)) {
            return false;
        }
        if (!Objects.equals(this.roles, that.roles)) {
            return false;
        }
        if (!Objects.equals(this.resources, that.resources)) {
            return false;
        }
        if (!Objects.equals((Object)this.jvmOptions, (Object)that.jvmOptions)) {
            return false;
        }
        return Objects.equals((Object)this.template, (Object)that.template);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.replicas, this.storage, this.roles, this.resources, this.jvmOptions, this.template, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("replicas:");
        sb.append(this.replicas + ",");
        if (this.storage != null) {
            sb.append("storage:");
            sb.append(this.storage + ",");
        }
        if (this.roles != null && !this.roles.isEmpty()) {
            sb.append("roles:");
            sb.append(this.roles + ",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.jvmOptions != null) {
            sb.append("jvmOptions:");
            sb.append(this.jvmOptions + ",");
        }
        if (this.template != null) {
            sb.append("template:");
            sb.append((Object)this.template);
        }
        sb.append("}");
        return sb.toString();
    }

    protected static <T> VisitableBuilder<T, ?> builder(Object item) {
        switch (item.getClass().getName()) {
            case "io.strimzi.api.kafka.model.storage.PersistentClaimStorage": {
                return new PersistentClaimStorageBuilder((PersistentClaimStorage)item);
            }
            case "io.strimzi.api.kafka.model.storage.EphemeralStorage": {
                return new EphemeralStorageBuilder((EphemeralStorage)item);
            }
            case "io.strimzi.api.kafka.model.storage.JbodStorage": {
                return new JbodStorageBuilder((JbodStorage)item);
            }
        }
        return KafkaNodePoolSpecFluent.builderOf((Object)item);
    }

    public class PersistentClaimStorageNested<N>
    extends PersistentClaimStorageFluent<PersistentClaimStorageNested<N>>
    implements Nested<N> {
        PersistentClaimStorageBuilder builder;

        PersistentClaimStorageNested(PersistentClaimStorage item) {
            this.builder = new PersistentClaimStorageBuilder(this, item);
        }

        public N and() {
            return (N)KafkaNodePoolSpecFluent.this.withStorage(this.builder.build());
        }

        public N endPersistentClaimStorage() {
            return this.and();
        }
    }

    public class EphemeralStorageNested<N>
    extends EphemeralStorageFluent<EphemeralStorageNested<N>>
    implements Nested<N> {
        EphemeralStorageBuilder builder;

        EphemeralStorageNested(EphemeralStorage item) {
            this.builder = new EphemeralStorageBuilder(this, item);
        }

        public N and() {
            return (N)KafkaNodePoolSpecFluent.this.withStorage(this.builder.build());
        }

        public N endEphemeralStorage() {
            return this.and();
        }
    }

    public class JbodStorageNested<N>
    extends JbodStorageFluent<JbodStorageNested<N>>
    implements Nested<N> {
        JbodStorageBuilder builder;

        JbodStorageNested(JbodStorage item) {
            this.builder = new JbodStorageBuilder(this, item);
        }

        public N and() {
            return (N)KafkaNodePoolSpecFluent.this.withStorage(this.builder.build());
        }

        public N endJbodStorage() {
            return this.and();
        }
    }

    public class JvmOptionsNested<N>
    extends JvmOptionsFluent<JvmOptionsNested<N>>
    implements Nested<N> {
        JvmOptionsBuilder builder;

        JvmOptionsNested(JvmOptions item) {
            this.builder = new JvmOptionsBuilder(this, item);
        }

        public N and() {
            return (N)KafkaNodePoolSpecFluent.this.withJvmOptions(this.builder.build());
        }

        public N endJvmOptions() {
            return this.and();
        }
    }

    public class TemplateNested<N>
    extends KafkaNodePoolTemplateFluent<TemplateNested<N>>
    implements Nested<N> {
        KafkaNodePoolTemplateBuilder builder;

        TemplateNested(KafkaNodePoolTemplate item) {
            this.builder = new KafkaNodePoolTemplateBuilder(this, item);
        }

        public N and() {
            return (N)KafkaNodePoolSpecFluent.this.withTemplate(this.builder.build());
        }

        public N endTemplate() {
            return this.and();
        }
    }
}

