/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.status;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.status.ListenerStatus;
import io.strimzi.api.kafka.model.status.Status;
import io.strimzi.api.kafka.model.status.UsedNodePoolStatus;
import io.strimzi.crdgenerator.annotations.Description;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"conditions", "observedGeneration", "listeners", "kafkaNodePools", "clusterId", "operatorLastSuccessfulVersion", "kafkaVersion", "kafkaMetadataVersion"})
public class KafkaStatus
extends Status {
    private static final long serialVersionUID = 1L;
    private List<ListenerStatus> listeners;
    private List<UsedNodePoolStatus> kafkaNodePools;
    private String clusterId;
    private String operatorLastSuccessfulVersion;
    private String kafkaVersion;
    private String kafkaMetadataVersion;

    @Description(value="Addresses of the internal and external listeners")
    public List<ListenerStatus> getListeners() {
        return this.listeners;
    }

    public void setListeners(List<ListenerStatus> listeners) {
        this.listeners = listeners;
    }

    @Description(value="List of the KafkaNodePools used by this Kafka cluster")
    public List<UsedNodePoolStatus> getKafkaNodePools() {
        return this.kafkaNodePools;
    }

    public void setKafkaNodePools(List<UsedNodePoolStatus> kafkaNodePools) {
        this.kafkaNodePools = kafkaNodePools;
    }

    @Description(value="Kafka cluster Id")
    public String getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    @Description(value="The version of the Strimzi Cluster Operator which performed the last successful reconciliation.")
    public String getOperatorLastSuccessfulVersion() {
        return this.operatorLastSuccessfulVersion;
    }

    public void setOperatorLastSuccessfulVersion(String operatorLastSuccessfulVersion) {
        this.operatorLastSuccessfulVersion = operatorLastSuccessfulVersion;
    }

    @Description(value="The version of Kafka currently deployed in the cluster.")
    public String getKafkaVersion() {
        return this.kafkaVersion;
    }

    public void setKafkaVersion(String kafkaVersion) {
        this.kafkaVersion = kafkaVersion;
    }

    @Description(value="The KRaft metadata.version currently used by the Kafka cluster.")
    public String getKafkaMetadataVersion() {
        return this.kafkaMetadataVersion;
    }

    public void setKafkaMetadataVersion(String kafkaMetadataVersion) {
        this.kafkaMetadataVersion = kafkaMetadataVersion;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaStatus)) {
            return false;
        }
        KafkaStatus other = (KafkaStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ListenerStatus> this$listeners = this.getListeners();
        List<ListenerStatus> other$listeners = other.getListeners();
        if (this$listeners == null ? other$listeners != null : !((Object)this$listeners).equals(other$listeners)) {
            return false;
        }
        List<UsedNodePoolStatus> this$kafkaNodePools = this.getKafkaNodePools();
        List<UsedNodePoolStatus> other$kafkaNodePools = other.getKafkaNodePools();
        if (this$kafkaNodePools == null ? other$kafkaNodePools != null : !((Object)this$kafkaNodePools).equals(other$kafkaNodePools)) {
            return false;
        }
        String this$clusterId = this.getClusterId();
        String other$clusterId = other.getClusterId();
        if (this$clusterId == null ? other$clusterId != null : !this$clusterId.equals(other$clusterId)) {
            return false;
        }
        String this$operatorLastSuccessfulVersion = this.getOperatorLastSuccessfulVersion();
        String other$operatorLastSuccessfulVersion = other.getOperatorLastSuccessfulVersion();
        if (this$operatorLastSuccessfulVersion == null ? other$operatorLastSuccessfulVersion != null : !this$operatorLastSuccessfulVersion.equals(other$operatorLastSuccessfulVersion)) {
            return false;
        }
        String this$kafkaVersion = this.getKafkaVersion();
        String other$kafkaVersion = other.getKafkaVersion();
        if (this$kafkaVersion == null ? other$kafkaVersion != null : !this$kafkaVersion.equals(other$kafkaVersion)) {
            return false;
        }
        String this$kafkaMetadataVersion = this.getKafkaMetadataVersion();
        String other$kafkaMetadataVersion = other.getKafkaMetadataVersion();
        return !(this$kafkaMetadataVersion == null ? other$kafkaMetadataVersion != null : !this$kafkaMetadataVersion.equals(other$kafkaMetadataVersion));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KafkaStatus;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ListenerStatus> $listeners = this.getListeners();
        result = result * 59 + ($listeners == null ? 43 : ((Object)$listeners).hashCode());
        List<UsedNodePoolStatus> $kafkaNodePools = this.getKafkaNodePools();
        result = result * 59 + ($kafkaNodePools == null ? 43 : ((Object)$kafkaNodePools).hashCode());
        String $clusterId = this.getClusterId();
        result = result * 59 + ($clusterId == null ? 43 : $clusterId.hashCode());
        String $operatorLastSuccessfulVersion = this.getOperatorLastSuccessfulVersion();
        result = result * 59 + ($operatorLastSuccessfulVersion == null ? 43 : $operatorLastSuccessfulVersion.hashCode());
        String $kafkaVersion = this.getKafkaVersion();
        result = result * 59 + ($kafkaVersion == null ? 43 : $kafkaVersion.hashCode());
        String $kafkaMetadataVersion = this.getKafkaMetadataVersion();
        result = result * 59 + ($kafkaMetadataVersion == null ? 43 : $kafkaMetadataVersion.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "KafkaStatus(super=" + super.toString() + ", listeners=" + this.getListeners() + ", kafkaNodePools=" + this.getKafkaNodePools() + ", clusterId=" + this.getClusterId() + ", operatorLastSuccessfulVersion=" + this.getOperatorLastSuccessfulVersion() + ", kafkaVersion=" + this.getKafkaVersion() + ", kafkaMetadataVersion=" + this.getKafkaMetadataVersion() + ")";
    }
}

