/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.status.KafkaStatus;
import io.strimzi.api.kafka.model.status.ListenerStatus;
import io.strimzi.api.kafka.model.status.ListenerStatusBuilder;
import io.strimzi.api.kafka.model.status.ListenerStatusFluent;
import io.strimzi.api.kafka.model.status.StatusFluent;
import io.strimzi.api.kafka.model.status.UsedNodePoolStatus;
import io.strimzi.api.kafka.model.status.UsedNodePoolStatusBuilder;
import io.strimzi.api.kafka.model.status.UsedNodePoolStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class KafkaStatusFluent<A extends KafkaStatusFluent<A>>
extends StatusFluent<A> {
    private ArrayList<ListenerStatusBuilder> listeners;
    private ArrayList<UsedNodePoolStatusBuilder> kafkaNodePools;
    private String clusterId;
    private String operatorLastSuccessfulVersion;
    private String kafkaVersion;
    private String kafkaMetadataVersion;

    public KafkaStatusFluent() {
    }

    public KafkaStatusFluent(KafkaStatus instance) {
        KafkaStatus kafkaStatus = instance = instance != null ? instance : new KafkaStatus();
        if (instance != null) {
            this.withListeners(instance.getListeners());
            this.withKafkaNodePools(instance.getKafkaNodePools());
            this.withClusterId(instance.getClusterId());
            this.withOperatorLastSuccessfulVersion(instance.getOperatorLastSuccessfulVersion());
            this.withKafkaVersion(instance.getKafkaVersion());
            this.withKafkaMetadataVersion(instance.getKafkaMetadataVersion());
            this.withConditions(instance.getConditions());
            this.withObservedGeneration(instance.getObservedGeneration());
        }
    }

    public A addToListeners(int index, ListenerStatus item) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        ListenerStatusBuilder builder = new ListenerStatusBuilder(item);
        if (index < 0 || index >= this.listeners.size()) {
            this._visitables.get((Object)"listeners").add(builder);
            this.listeners.add(builder);
        } else {
            this._visitables.get((Object)"listeners").add(index, builder);
            this.listeners.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToListeners(int index, ListenerStatus item) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        ListenerStatusBuilder builder = new ListenerStatusBuilder(item);
        if (index < 0 || index >= this.listeners.size()) {
            this._visitables.get((Object)"listeners").add(builder);
            this.listeners.add(builder);
        } else {
            this._visitables.get((Object)"listeners").set(index, builder);
            this.listeners.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToListeners(ListenerStatus ... items) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        for (ListenerStatus item : items) {
            ListenerStatusBuilder builder = new ListenerStatusBuilder(item);
            this._visitables.get((Object)"listeners").add(builder);
            this.listeners.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToListeners(Collection<ListenerStatus> items) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        for (ListenerStatus item : items) {
            ListenerStatusBuilder builder = new ListenerStatusBuilder(item);
            this._visitables.get((Object)"listeners").add(builder);
            this.listeners.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromListeners(ListenerStatus ... items) {
        if (this.listeners == null) {
            return (A)((Object)this);
        }
        for (ListenerStatus item : items) {
            ListenerStatusBuilder builder = new ListenerStatusBuilder(item);
            this._visitables.get((Object)"listeners").remove((Object)builder);
            this.listeners.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromListeners(Collection<ListenerStatus> items) {
        if (this.listeners == null) {
            return (A)((Object)this);
        }
        for (ListenerStatus item : items) {
            ListenerStatusBuilder builder = new ListenerStatusBuilder(item);
            this._visitables.get((Object)"listeners").remove((Object)builder);
            this.listeners.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromListeners(Predicate<ListenerStatusBuilder> predicate) {
        if (this.listeners == null) {
            return (A)((Object)this);
        }
        Iterator<ListenerStatusBuilder> each = this.listeners.iterator();
        List visitables = this._visitables.get((Object)"listeners");
        while (each.hasNext()) {
            ListenerStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ListenerStatus> buildListeners() {
        return this.listeners != null ? KafkaStatusFluent.build(this.listeners) : null;
    }

    public ListenerStatus buildListener(int index) {
        return this.listeners.get(index).build();
    }

    public ListenerStatus buildFirstListener() {
        return this.listeners.get(0).build();
    }

    public ListenerStatus buildLastListener() {
        return this.listeners.get(this.listeners.size() - 1).build();
    }

    public ListenerStatus buildMatchingListener(Predicate<ListenerStatusBuilder> predicate) {
        for (ListenerStatusBuilder item : this.listeners) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingListener(Predicate<ListenerStatusBuilder> predicate) {
        for (ListenerStatusBuilder item : this.listeners) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withListeners(List<ListenerStatus> listeners) {
        if (this.listeners != null) {
            this._visitables.get((Object)"listeners").clear();
        }
        if (listeners != null) {
            this.listeners = new ArrayList();
            for (ListenerStatus item : listeners) {
                this.addToListeners(item);
            }
        } else {
            this.listeners = null;
        }
        return (A)((Object)this);
    }

    public A withListeners(ListenerStatus ... listeners) {
        if (this.listeners != null) {
            this.listeners.clear();
            this._visitables.remove((Object)"listeners");
        }
        if (listeners != null) {
            for (ListenerStatus item : listeners) {
                this.addToListeners(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasListeners() {
        return this.listeners != null && !this.listeners.isEmpty();
    }

    public ListenersNested<A> addNewListener() {
        return new ListenersNested(-1, null);
    }

    public ListenersNested<A> addNewListenerLike(ListenerStatus item) {
        return new ListenersNested(-1, item);
    }

    public ListenersNested<A> setNewListenerLike(int index, ListenerStatus item) {
        return new ListenersNested(index, item);
    }

    public ListenersNested<A> editListener(int index) {
        if (this.listeners.size() <= index) {
            throw new RuntimeException("Can't edit listeners. Index exceeds size.");
        }
        return this.setNewListenerLike(index, this.buildListener(index));
    }

    public ListenersNested<A> editFirstListener() {
        if (this.listeners.size() == 0) {
            throw new RuntimeException("Can't edit first listeners. The list is empty.");
        }
        return this.setNewListenerLike(0, this.buildListener(0));
    }

    public ListenersNested<A> editLastListener() {
        int index = this.listeners.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last listeners. The list is empty.");
        }
        return this.setNewListenerLike(index, this.buildListener(index));
    }

    public ListenersNested<A> editMatchingListener(Predicate<ListenerStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.listeners.size(); ++i) {
            if (!predicate.test(this.listeners.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching listeners. No match found.");
        }
        return this.setNewListenerLike(index, this.buildListener(index));
    }

    public A addToKafkaNodePools(int index, UsedNodePoolStatus item) {
        if (this.kafkaNodePools == null) {
            this.kafkaNodePools = new ArrayList();
        }
        UsedNodePoolStatusBuilder builder = new UsedNodePoolStatusBuilder(item);
        if (index < 0 || index >= this.kafkaNodePools.size()) {
            this._visitables.get((Object)"kafkaNodePools").add(builder);
            this.kafkaNodePools.add(builder);
        } else {
            this._visitables.get((Object)"kafkaNodePools").add(index, builder);
            this.kafkaNodePools.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToKafkaNodePools(int index, UsedNodePoolStatus item) {
        if (this.kafkaNodePools == null) {
            this.kafkaNodePools = new ArrayList();
        }
        UsedNodePoolStatusBuilder builder = new UsedNodePoolStatusBuilder(item);
        if (index < 0 || index >= this.kafkaNodePools.size()) {
            this._visitables.get((Object)"kafkaNodePools").add(builder);
            this.kafkaNodePools.add(builder);
        } else {
            this._visitables.get((Object)"kafkaNodePools").set(index, builder);
            this.kafkaNodePools.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToKafkaNodePools(UsedNodePoolStatus ... items) {
        if (this.kafkaNodePools == null) {
            this.kafkaNodePools = new ArrayList();
        }
        for (UsedNodePoolStatus item : items) {
            UsedNodePoolStatusBuilder builder = new UsedNodePoolStatusBuilder(item);
            this._visitables.get((Object)"kafkaNodePools").add(builder);
            this.kafkaNodePools.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToKafkaNodePools(Collection<UsedNodePoolStatus> items) {
        if (this.kafkaNodePools == null) {
            this.kafkaNodePools = new ArrayList();
        }
        for (UsedNodePoolStatus item : items) {
            UsedNodePoolStatusBuilder builder = new UsedNodePoolStatusBuilder(item);
            this._visitables.get((Object)"kafkaNodePools").add(builder);
            this.kafkaNodePools.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromKafkaNodePools(UsedNodePoolStatus ... items) {
        if (this.kafkaNodePools == null) {
            return (A)((Object)this);
        }
        for (UsedNodePoolStatus item : items) {
            UsedNodePoolStatusBuilder builder = new UsedNodePoolStatusBuilder(item);
            this._visitables.get((Object)"kafkaNodePools").remove((Object)builder);
            this.kafkaNodePools.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromKafkaNodePools(Collection<UsedNodePoolStatus> items) {
        if (this.kafkaNodePools == null) {
            return (A)((Object)this);
        }
        for (UsedNodePoolStatus item : items) {
            UsedNodePoolStatusBuilder builder = new UsedNodePoolStatusBuilder(item);
            this._visitables.get((Object)"kafkaNodePools").remove((Object)builder);
            this.kafkaNodePools.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromKafkaNodePools(Predicate<UsedNodePoolStatusBuilder> predicate) {
        if (this.kafkaNodePools == null) {
            return (A)((Object)this);
        }
        Iterator<UsedNodePoolStatusBuilder> each = this.kafkaNodePools.iterator();
        List visitables = this._visitables.get((Object)"kafkaNodePools");
        while (each.hasNext()) {
            UsedNodePoolStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<UsedNodePoolStatus> buildKafkaNodePools() {
        return this.kafkaNodePools != null ? KafkaStatusFluent.build(this.kafkaNodePools) : null;
    }

    public UsedNodePoolStatus buildKafkaNodePool(int index) {
        return this.kafkaNodePools.get(index).build();
    }

    public UsedNodePoolStatus buildFirstKafkaNodePool() {
        return this.kafkaNodePools.get(0).build();
    }

    public UsedNodePoolStatus buildLastKafkaNodePool() {
        return this.kafkaNodePools.get(this.kafkaNodePools.size() - 1).build();
    }

    public UsedNodePoolStatus buildMatchingKafkaNodePool(Predicate<UsedNodePoolStatusBuilder> predicate) {
        for (UsedNodePoolStatusBuilder item : this.kafkaNodePools) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingKafkaNodePool(Predicate<UsedNodePoolStatusBuilder> predicate) {
        for (UsedNodePoolStatusBuilder item : this.kafkaNodePools) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withKafkaNodePools(List<UsedNodePoolStatus> kafkaNodePools) {
        if (this.kafkaNodePools != null) {
            this._visitables.get((Object)"kafkaNodePools").clear();
        }
        if (kafkaNodePools != null) {
            this.kafkaNodePools = new ArrayList();
            for (UsedNodePoolStatus item : kafkaNodePools) {
                this.addToKafkaNodePools(item);
            }
        } else {
            this.kafkaNodePools = null;
        }
        return (A)((Object)this);
    }

    public A withKafkaNodePools(UsedNodePoolStatus ... kafkaNodePools) {
        if (this.kafkaNodePools != null) {
            this.kafkaNodePools.clear();
            this._visitables.remove((Object)"kafkaNodePools");
        }
        if (kafkaNodePools != null) {
            for (UsedNodePoolStatus item : kafkaNodePools) {
                this.addToKafkaNodePools(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasKafkaNodePools() {
        return this.kafkaNodePools != null && !this.kafkaNodePools.isEmpty();
    }

    public KafkaNodePoolsNested<A> addNewKafkaNodePool() {
        return new KafkaNodePoolsNested(-1, null);
    }

    public KafkaNodePoolsNested<A> addNewKafkaNodePoolLike(UsedNodePoolStatus item) {
        return new KafkaNodePoolsNested(-1, item);
    }

    public KafkaNodePoolsNested<A> setNewKafkaNodePoolLike(int index, UsedNodePoolStatus item) {
        return new KafkaNodePoolsNested(index, item);
    }

    public KafkaNodePoolsNested<A> editKafkaNodePool(int index) {
        if (this.kafkaNodePools.size() <= index) {
            throw new RuntimeException("Can't edit kafkaNodePools. Index exceeds size.");
        }
        return this.setNewKafkaNodePoolLike(index, this.buildKafkaNodePool(index));
    }

    public KafkaNodePoolsNested<A> editFirstKafkaNodePool() {
        if (this.kafkaNodePools.size() == 0) {
            throw new RuntimeException("Can't edit first kafkaNodePools. The list is empty.");
        }
        return this.setNewKafkaNodePoolLike(0, this.buildKafkaNodePool(0));
    }

    public KafkaNodePoolsNested<A> editLastKafkaNodePool() {
        int index = this.kafkaNodePools.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last kafkaNodePools. The list is empty.");
        }
        return this.setNewKafkaNodePoolLike(index, this.buildKafkaNodePool(index));
    }

    public KafkaNodePoolsNested<A> editMatchingKafkaNodePool(Predicate<UsedNodePoolStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.kafkaNodePools.size(); ++i) {
            if (!predicate.test(this.kafkaNodePools.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching kafkaNodePools. No match found.");
        }
        return this.setNewKafkaNodePoolLike(index, this.buildKafkaNodePool(index));
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public A withClusterId(String clusterId) {
        this.clusterId = clusterId;
        return (A)((Object)this);
    }

    public boolean hasClusterId() {
        return this.clusterId != null;
    }

    public String getOperatorLastSuccessfulVersion() {
        return this.operatorLastSuccessfulVersion;
    }

    public A withOperatorLastSuccessfulVersion(String operatorLastSuccessfulVersion) {
        this.operatorLastSuccessfulVersion = operatorLastSuccessfulVersion;
        return (A)((Object)this);
    }

    public boolean hasOperatorLastSuccessfulVersion() {
        return this.operatorLastSuccessfulVersion != null;
    }

    public String getKafkaVersion() {
        return this.kafkaVersion;
    }

    public A withKafkaVersion(String kafkaVersion) {
        this.kafkaVersion = kafkaVersion;
        return (A)((Object)this);
    }

    public boolean hasKafkaVersion() {
        return this.kafkaVersion != null;
    }

    public String getKafkaMetadataVersion() {
        return this.kafkaMetadataVersion;
    }

    public A withKafkaMetadataVersion(String kafkaMetadataVersion) {
        this.kafkaMetadataVersion = kafkaMetadataVersion;
        return (A)((Object)this);
    }

    public boolean hasKafkaMetadataVersion() {
        return this.kafkaMetadataVersion != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaStatusFluent that = (KafkaStatusFluent)((Object)o);
        if (!Objects.equals(this.listeners, that.listeners)) {
            return false;
        }
        if (!Objects.equals(this.kafkaNodePools, that.kafkaNodePools)) {
            return false;
        }
        if (!Objects.equals(this.clusterId, that.clusterId)) {
            return false;
        }
        if (!Objects.equals(this.operatorLastSuccessfulVersion, that.operatorLastSuccessfulVersion)) {
            return false;
        }
        if (!Objects.equals(this.kafkaVersion, that.kafkaVersion)) {
            return false;
        }
        return Objects.equals(this.kafkaMetadataVersion, that.kafkaMetadataVersion);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.listeners, this.kafkaNodePools, this.clusterId, this.operatorLastSuccessfulVersion, this.kafkaVersion, this.kafkaMetadataVersion, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.listeners != null && !this.listeners.isEmpty()) {
            sb.append("listeners:");
            sb.append(this.listeners + ",");
        }
        if (this.kafkaNodePools != null && !this.kafkaNodePools.isEmpty()) {
            sb.append("kafkaNodePools:");
            sb.append(this.kafkaNodePools + ",");
        }
        if (this.clusterId != null) {
            sb.append("clusterId:");
            sb.append(this.clusterId + ",");
        }
        if (this.operatorLastSuccessfulVersion != null) {
            sb.append("operatorLastSuccessfulVersion:");
            sb.append(this.operatorLastSuccessfulVersion + ",");
        }
        if (this.kafkaVersion != null) {
            sb.append("kafkaVersion:");
            sb.append(this.kafkaVersion + ",");
        }
        if (this.kafkaMetadataVersion != null) {
            sb.append("kafkaMetadataVersion:");
            sb.append(this.kafkaMetadataVersion);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ListenersNested<N>
    extends ListenerStatusFluent<ListenersNested<N>>
    implements Nested<N> {
        ListenerStatusBuilder builder;
        int index;

        ListenersNested(int index, ListenerStatus item) {
            this.index = index;
            this.builder = new ListenerStatusBuilder(this, item);
        }

        public N and() {
            return (N)KafkaStatusFluent.this.setToListeners(this.index, this.builder.build());
        }

        public N endListener() {
            return this.and();
        }
    }

    public class KafkaNodePoolsNested<N>
    extends UsedNodePoolStatusFluent<KafkaNodePoolsNested<N>>
    implements Nested<N> {
        UsedNodePoolStatusBuilder builder;
        int index;

        KafkaNodePoolsNested(int index, UsedNodePoolStatus item) {
            this.index = index;
            this.builder = new UsedNodePoolStatusBuilder(this, item);
        }

        public N and() {
            return (N)KafkaStatusFluent.this.setToKafkaNodePools(this.index, this.builder.build());
        }

        public N endKafkaNodePool() {
            return this.and();
        }
    }
}

