/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.storage;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.storage.EphemeralStorage;
import io.strimzi.api.kafka.model.storage.EphemeralStorageBuilder;
import io.strimzi.api.kafka.model.storage.EphemeralStorageFluent;
import io.strimzi.api.kafka.model.storage.JbodStorage;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorage;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorageBuilder;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluent;
import io.strimzi.api.kafka.model.storage.SingleVolumeStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class JbodStorageFluent<A extends JbodStorageFluent<A>>
extends BaseFluent<A> {
    private ArrayList<VisitableBuilder<? extends SingleVolumeStorage, ?>> volumes;

    public JbodStorageFluent() {
    }

    public JbodStorageFluent(JbodStorage instance) {
        JbodStorage jbodStorage = instance = instance != null ? instance : new JbodStorage();
        if (instance != null) {
            this.withVolumes(instance.getVolumes());
        }
    }

    public A addToVolumes(VisitableBuilder<? extends SingleVolumeStorage, ?> builder) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        this._visitables.get((Object)"volumes").add(builder);
        this.volumes.add(builder);
        return (A)((Object)this);
    }

    public A addToVolumes(int index, VisitableBuilder<? extends SingleVolumeStorage, ?> builder) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        if (index < 0 || index >= this.volumes.size()) {
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        } else {
            this._visitables.get((Object)"volumes").add(index, builder);
            this.volumes.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToVolumes(int index, SingleVolumeStorage item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        VisitableBuilder builder = JbodStorageFluent.builder(item);
        if (index < 0 || index >= this.volumes.size()) {
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        } else {
            this._visitables.get((Object)"volumes").add(index, builder);
            this.volumes.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToVolumes(int index, SingleVolumeStorage item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        VisitableBuilder builder = JbodStorageFluent.builder(item);
        if (index < 0 || index >= this.volumes.size()) {
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        } else {
            this._visitables.get((Object)"volumes").set(index, builder);
            this.volumes.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToVolumes(SingleVolumeStorage ... items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        for (SingleVolumeStorage item : items) {
            VisitableBuilder builder = JbodStorageFluent.builder(item);
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToVolumes(Collection<SingleVolumeStorage> items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        for (SingleVolumeStorage item : items) {
            VisitableBuilder builder = JbodStorageFluent.builder(item);
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromVolumes(VisitableBuilder<? extends SingleVolumeStorage, ?> builder) {
        if (this.volumes == null) {
            return (A)((Object)this);
        }
        this._visitables.get((Object)"volumes").remove(builder);
        this.volumes.remove(builder);
        return (A)((Object)this);
    }

    public A removeFromVolumes(SingleVolumeStorage ... items) {
        if (this.volumes == null) {
            return (A)((Object)this);
        }
        for (SingleVolumeStorage item : items) {
            VisitableBuilder builder = JbodStorageFluent.builder(item);
            this._visitables.get((Object)"volumes").remove(builder);
            this.volumes.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromVolumes(Collection<SingleVolumeStorage> items) {
        if (this.volumes == null) {
            return (A)((Object)this);
        }
        for (SingleVolumeStorage item : items) {
            VisitableBuilder builder = JbodStorageFluent.builder(item);
            this._visitables.get((Object)"volumes").remove(builder);
            this.volumes.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromVolumes(Predicate<VisitableBuilder<? extends SingleVolumeStorage, ?>> predicate) {
        if (this.volumes == null) {
            return (A)((Object)this);
        }
        Iterator<VisitableBuilder<SingleVolumeStorage, ?>> each = this.volumes.iterator();
        List visitables = this._visitables.get((Object)"volumes");
        while (each.hasNext()) {
            VisitableBuilder<? extends SingleVolumeStorage, ?> builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<SingleVolumeStorage> buildVolumes() {
        return JbodStorageFluent.build(this.volumes);
    }

    public SingleVolumeStorage buildVolume(int index) {
        return (SingleVolumeStorage)this.volumes.get(index).build();
    }

    public SingleVolumeStorage buildFirstVolume() {
        return (SingleVolumeStorage)this.volumes.get(0).build();
    }

    public SingleVolumeStorage buildLastVolume() {
        return (SingleVolumeStorage)this.volumes.get(this.volumes.size() - 1).build();
    }

    public SingleVolumeStorage buildMatchingVolume(Predicate<VisitableBuilder<? extends SingleVolumeStorage, ?>> predicate) {
        for (VisitableBuilder<? extends SingleVolumeStorage, ?> visitableBuilder : this.volumes) {
            if (!predicate.test(visitableBuilder)) continue;
            return (SingleVolumeStorage)visitableBuilder.build();
        }
        return null;
    }

    public boolean hasMatchingVolume(Predicate<VisitableBuilder<? extends SingleVolumeStorage, ?>> predicate) {
        for (VisitableBuilder<? extends SingleVolumeStorage, ?> visitableBuilder : this.volumes) {
            if (!predicate.test(visitableBuilder)) continue;
            return true;
        }
        return false;
    }

    public A withVolumes(List<SingleVolumeStorage> volumes) {
        if (volumes != null) {
            this.volumes = new ArrayList();
            for (SingleVolumeStorage item : volumes) {
                this.addToVolumes(item);
            }
        } else {
            this.volumes = null;
        }
        return (A)((Object)this);
    }

    public A withVolumes(SingleVolumeStorage ... volumes) {
        if (this.volumes != null) {
            this.volumes.clear();
            this._visitables.remove((Object)"volumes");
        }
        if (volumes != null) {
            for (SingleVolumeStorage item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasVolumes() {
        return this.volumes != null && !this.volumes.isEmpty();
    }

    public PersistentClaimStorageVolumesNested<A> addNewPersistentClaimStorageVolume() {
        return new PersistentClaimStorageVolumesNested(-1, null);
    }

    public PersistentClaimStorageVolumesNested<A> addNewPersistentClaimStorageVolumeLike(PersistentClaimStorage item) {
        return new PersistentClaimStorageVolumesNested(-1, item);
    }

    public PersistentClaimStorageVolumesNested<A> setNewPersistentClaimStorageVolumeLike(int index, PersistentClaimStorage item) {
        return new PersistentClaimStorageVolumesNested(index, item);
    }

    public EphemeralStorageVolumesNested<A> addNewEphemeralStorageVolume() {
        return new EphemeralStorageVolumesNested(-1, null);
    }

    public EphemeralStorageVolumesNested<A> addNewEphemeralStorageVolumeLike(EphemeralStorage item) {
        return new EphemeralStorageVolumesNested(-1, item);
    }

    public EphemeralStorageVolumesNested<A> setNewEphemeralStorageVolumeLike(int index, EphemeralStorage item) {
        return new EphemeralStorageVolumesNested(index, item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JbodStorageFluent that = (JbodStorageFluent)((Object)o);
        return Objects.equals(this.volumes, that.volumes);
    }

    public int hashCode() {
        return Objects.hash(this.volumes, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.volumes != null && !this.volumes.isEmpty()) {
            sb.append("volumes:");
            sb.append(this.volumes);
        }
        sb.append("}");
        return sb.toString();
    }

    protected static <T> VisitableBuilder<T, ?> builder(Object item) {
        switch (item.getClass().getName()) {
            case "io.strimzi.api.kafka.model.storage.PersistentClaimStorage": {
                return new PersistentClaimStorageBuilder((PersistentClaimStorage)item);
            }
            case "io.strimzi.api.kafka.model.storage.EphemeralStorage": {
                return new EphemeralStorageBuilder((EphemeralStorage)item);
            }
        }
        return JbodStorageFluent.builderOf((Object)item);
    }

    public class PersistentClaimStorageVolumesNested<N>
    extends PersistentClaimStorageFluent<PersistentClaimStorageVolumesNested<N>>
    implements Nested<N> {
        PersistentClaimStorageBuilder builder;
        int index;

        PersistentClaimStorageVolumesNested(int index, PersistentClaimStorage item) {
            this.index = index;
            this.builder = new PersistentClaimStorageBuilder(this, item);
        }

        public N and() {
            return (N)JbodStorageFluent.this.setToVolumes(this.index, this.builder.build());
        }

        public N endPersistentClaimStorageVolume() {
            return this.and();
        }
    }

    public class EphemeralStorageVolumesNested<N>
    extends EphemeralStorageFluent<EphemeralStorageVolumesNested<N>>
    implements Nested<N> {
        EphemeralStorageBuilder builder;
        int index;

        EphemeralStorageVolumesNested(int index, EphemeralStorage item) {
            this.index = index;
            this.builder = new EphemeralStorageBuilder(this, item);
        }

        public N and() {
            return (N)JbodStorageFluent.this.setToVolumes(this.index, this.builder.build());
        }

        public N endEphemeralStorageVolume() {
            return this.and();
        }
    }
}

