/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.template.ContainerTemplate;
import io.strimzi.api.kafka.model.template.ContainerTemplateBuilder;
import io.strimzi.api.kafka.model.template.ContainerTemplateFluent;
import io.strimzi.api.kafka.model.template.DeploymentTemplate;
import io.strimzi.api.kafka.model.template.DeploymentTemplateBuilder;
import io.strimzi.api.kafka.model.template.DeploymentTemplateFluent;
import io.strimzi.api.kafka.model.template.InternalServiceTemplate;
import io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder;
import io.strimzi.api.kafka.model.template.InternalServiceTemplateFluent;
import io.strimzi.api.kafka.model.template.KafkaBridgeTemplate;
import io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplate;
import io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplateBuilder;
import io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplateFluent;
import io.strimzi.api.kafka.model.template.PodTemplate;
import io.strimzi.api.kafka.model.template.PodTemplateBuilder;
import io.strimzi.api.kafka.model.template.PodTemplateFluent;
import io.strimzi.api.kafka.model.template.ResourceTemplate;
import io.strimzi.api.kafka.model.template.ResourceTemplateBuilder;
import io.strimzi.api.kafka.model.template.ResourceTemplateFluent;
import java.util.Objects;
import java.util.Optional;

public class KafkaBridgeTemplateFluent<A extends KafkaBridgeTemplateFluent<A>>
extends BaseFluent<A> {
    private DeploymentTemplateBuilder deployment;
    private PodTemplateBuilder pod;
    private InternalServiceTemplateBuilder apiService;
    private PodDisruptionBudgetTemplateBuilder podDisruptionBudget;
    private ContainerTemplateBuilder bridgeContainer;
    private ContainerTemplateBuilder initContainer;
    private ResourceTemplateBuilder clusterRoleBinding;
    private ResourceTemplateBuilder serviceAccount;

    public KafkaBridgeTemplateFluent() {
    }

    public KafkaBridgeTemplateFluent(KafkaBridgeTemplate instance) {
        KafkaBridgeTemplate kafkaBridgeTemplate = instance = instance != null ? instance : new KafkaBridgeTemplate();
        if (instance != null) {
            this.withDeployment(instance.getDeployment());
            this.withPod(instance.getPod());
            this.withApiService(instance.getApiService());
            this.withPodDisruptionBudget(instance.getPodDisruptionBudget());
            this.withBridgeContainer(instance.getBridgeContainer());
            this.withInitContainer(instance.getInitContainer());
            this.withClusterRoleBinding(instance.getClusterRoleBinding());
            this.withServiceAccount(instance.getServiceAccount());
        }
    }

    public DeploymentTemplate buildDeployment() {
        return this.deployment != null ? this.deployment.build() : null;
    }

    public A withDeployment(DeploymentTemplate deployment) {
        this._visitables.get((Object)"deployment").remove((Object)this.deployment);
        if (deployment != null) {
            this.deployment = new DeploymentTemplateBuilder(deployment);
            this._visitables.get((Object)"deployment").add(this.deployment);
        } else {
            this.deployment = null;
            this._visitables.get((Object)"deployment").remove((Object)this.deployment);
        }
        return (A)((Object)this);
    }

    public boolean hasDeployment() {
        return this.deployment != null;
    }

    public DeploymentNested<A> withNewDeployment() {
        return new DeploymentNested(null);
    }

    public DeploymentNested<A> withNewDeploymentLike(DeploymentTemplate item) {
        return new DeploymentNested(item);
    }

    public DeploymentNested<A> editDeployment() {
        return this.withNewDeploymentLike(Optional.ofNullable(this.buildDeployment()).orElse(null));
    }

    public DeploymentNested<A> editOrNewDeployment() {
        return this.withNewDeploymentLike(Optional.ofNullable(this.buildDeployment()).orElse(new DeploymentTemplateBuilder().build()));
    }

    public DeploymentNested<A> editOrNewDeploymentLike(DeploymentTemplate item) {
        return this.withNewDeploymentLike(Optional.ofNullable(this.buildDeployment()).orElse(item));
    }

    public PodTemplate buildPod() {
        return this.pod != null ? this.pod.build() : null;
    }

    public A withPod(PodTemplate pod) {
        this._visitables.get((Object)"pod").remove((Object)this.pod);
        if (pod != null) {
            this.pod = new PodTemplateBuilder(pod);
            this._visitables.get((Object)"pod").add(this.pod);
        } else {
            this.pod = null;
            this._visitables.get((Object)"pod").remove((Object)this.pod);
        }
        return (A)((Object)this);
    }

    public boolean hasPod() {
        return this.pod != null;
    }

    public PodNested<A> withNewPod() {
        return new PodNested(null);
    }

    public PodNested<A> withNewPodLike(PodTemplate item) {
        return new PodNested(item);
    }

    public PodNested<A> editPod() {
        return this.withNewPodLike(Optional.ofNullable(this.buildPod()).orElse(null));
    }

    public PodNested<A> editOrNewPod() {
        return this.withNewPodLike(Optional.ofNullable(this.buildPod()).orElse(new PodTemplateBuilder().build()));
    }

    public PodNested<A> editOrNewPodLike(PodTemplate item) {
        return this.withNewPodLike(Optional.ofNullable(this.buildPod()).orElse(item));
    }

    public InternalServiceTemplate buildApiService() {
        return this.apiService != null ? this.apiService.build() : null;
    }

    public A withApiService(InternalServiceTemplate apiService) {
        this._visitables.get((Object)"apiService").remove((Object)this.apiService);
        if (apiService != null) {
            this.apiService = new InternalServiceTemplateBuilder(apiService);
            this._visitables.get((Object)"apiService").add(this.apiService);
        } else {
            this.apiService = null;
            this._visitables.get((Object)"apiService").remove((Object)this.apiService);
        }
        return (A)((Object)this);
    }

    public boolean hasApiService() {
        return this.apiService != null;
    }

    public ApiServiceNested<A> withNewApiService() {
        return new ApiServiceNested(null);
    }

    public ApiServiceNested<A> withNewApiServiceLike(InternalServiceTemplate item) {
        return new ApiServiceNested(item);
    }

    public ApiServiceNested<A> editApiService() {
        return this.withNewApiServiceLike(Optional.ofNullable(this.buildApiService()).orElse(null));
    }

    public ApiServiceNested<A> editOrNewApiService() {
        return this.withNewApiServiceLike(Optional.ofNullable(this.buildApiService()).orElse(new InternalServiceTemplateBuilder().build()));
    }

    public ApiServiceNested<A> editOrNewApiServiceLike(InternalServiceTemplate item) {
        return this.withNewApiServiceLike(Optional.ofNullable(this.buildApiService()).orElse(item));
    }

    public PodDisruptionBudgetTemplate buildPodDisruptionBudget() {
        return this.podDisruptionBudget != null ? this.podDisruptionBudget.build() : null;
    }

    public A withPodDisruptionBudget(PodDisruptionBudgetTemplate podDisruptionBudget) {
        this._visitables.get((Object)"podDisruptionBudget").remove((Object)this.podDisruptionBudget);
        if (podDisruptionBudget != null) {
            this.podDisruptionBudget = new PodDisruptionBudgetTemplateBuilder(podDisruptionBudget);
            this._visitables.get((Object)"podDisruptionBudget").add(this.podDisruptionBudget);
        } else {
            this.podDisruptionBudget = null;
            this._visitables.get((Object)"podDisruptionBudget").remove((Object)this.podDisruptionBudget);
        }
        return (A)((Object)this);
    }

    public boolean hasPodDisruptionBudget() {
        return this.podDisruptionBudget != null;
    }

    public PodDisruptionBudgetNested<A> withNewPodDisruptionBudget() {
        return new PodDisruptionBudgetNested(null);
    }

    public PodDisruptionBudgetNested<A> withNewPodDisruptionBudgetLike(PodDisruptionBudgetTemplate item) {
        return new PodDisruptionBudgetNested(item);
    }

    public PodDisruptionBudgetNested<A> editPodDisruptionBudget() {
        return this.withNewPodDisruptionBudgetLike(Optional.ofNullable(this.buildPodDisruptionBudget()).orElse(null));
    }

    public PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudget() {
        return this.withNewPodDisruptionBudgetLike(Optional.ofNullable(this.buildPodDisruptionBudget()).orElse(new PodDisruptionBudgetTemplateBuilder().build()));
    }

    public PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudgetLike(PodDisruptionBudgetTemplate item) {
        return this.withNewPodDisruptionBudgetLike(Optional.ofNullable(this.buildPodDisruptionBudget()).orElse(item));
    }

    public ContainerTemplate buildBridgeContainer() {
        return this.bridgeContainer != null ? this.bridgeContainer.build() : null;
    }

    public A withBridgeContainer(ContainerTemplate bridgeContainer) {
        this._visitables.get((Object)"bridgeContainer").remove((Object)this.bridgeContainer);
        if (bridgeContainer != null) {
            this.bridgeContainer = new ContainerTemplateBuilder(bridgeContainer);
            this._visitables.get((Object)"bridgeContainer").add(this.bridgeContainer);
        } else {
            this.bridgeContainer = null;
            this._visitables.get((Object)"bridgeContainer").remove((Object)this.bridgeContainer);
        }
        return (A)((Object)this);
    }

    public boolean hasBridgeContainer() {
        return this.bridgeContainer != null;
    }

    public BridgeContainerNested<A> withNewBridgeContainer() {
        return new BridgeContainerNested(null);
    }

    public BridgeContainerNested<A> withNewBridgeContainerLike(ContainerTemplate item) {
        return new BridgeContainerNested(item);
    }

    public BridgeContainerNested<A> editBridgeContainer() {
        return this.withNewBridgeContainerLike(Optional.ofNullable(this.buildBridgeContainer()).orElse(null));
    }

    public BridgeContainerNested<A> editOrNewBridgeContainer() {
        return this.withNewBridgeContainerLike(Optional.ofNullable(this.buildBridgeContainer()).orElse(new ContainerTemplateBuilder().build()));
    }

    public BridgeContainerNested<A> editOrNewBridgeContainerLike(ContainerTemplate item) {
        return this.withNewBridgeContainerLike(Optional.ofNullable(this.buildBridgeContainer()).orElse(item));
    }

    public ContainerTemplate buildInitContainer() {
        return this.initContainer != null ? this.initContainer.build() : null;
    }

    public A withInitContainer(ContainerTemplate initContainer) {
        this._visitables.get((Object)"initContainer").remove((Object)this.initContainer);
        if (initContainer != null) {
            this.initContainer = new ContainerTemplateBuilder(initContainer);
            this._visitables.get((Object)"initContainer").add(this.initContainer);
        } else {
            this.initContainer = null;
            this._visitables.get((Object)"initContainer").remove((Object)this.initContainer);
        }
        return (A)((Object)this);
    }

    public boolean hasInitContainer() {
        return this.initContainer != null;
    }

    public InitContainerNested<A> withNewInitContainer() {
        return new InitContainerNested(null);
    }

    public InitContainerNested<A> withNewInitContainerLike(ContainerTemplate item) {
        return new InitContainerNested(item);
    }

    public InitContainerNested<A> editInitContainer() {
        return this.withNewInitContainerLike(Optional.ofNullable(this.buildInitContainer()).orElse(null));
    }

    public InitContainerNested<A> editOrNewInitContainer() {
        return this.withNewInitContainerLike(Optional.ofNullable(this.buildInitContainer()).orElse(new ContainerTemplateBuilder().build()));
    }

    public InitContainerNested<A> editOrNewInitContainerLike(ContainerTemplate item) {
        return this.withNewInitContainerLike(Optional.ofNullable(this.buildInitContainer()).orElse(item));
    }

    public ResourceTemplate buildClusterRoleBinding() {
        return this.clusterRoleBinding != null ? this.clusterRoleBinding.build() : null;
    }

    public A withClusterRoleBinding(ResourceTemplate clusterRoleBinding) {
        this._visitables.get((Object)"clusterRoleBinding").remove((Object)this.clusterRoleBinding);
        if (clusterRoleBinding != null) {
            this.clusterRoleBinding = new ResourceTemplateBuilder(clusterRoleBinding);
            this._visitables.get((Object)"clusterRoleBinding").add(this.clusterRoleBinding);
        } else {
            this.clusterRoleBinding = null;
            this._visitables.get((Object)"clusterRoleBinding").remove((Object)this.clusterRoleBinding);
        }
        return (A)((Object)this);
    }

    public boolean hasClusterRoleBinding() {
        return this.clusterRoleBinding != null;
    }

    public ClusterRoleBindingNested<A> withNewClusterRoleBinding() {
        return new ClusterRoleBindingNested(null);
    }

    public ClusterRoleBindingNested<A> withNewClusterRoleBindingLike(ResourceTemplate item) {
        return new ClusterRoleBindingNested(item);
    }

    public ClusterRoleBindingNested<A> editClusterRoleBinding() {
        return this.withNewClusterRoleBindingLike(Optional.ofNullable(this.buildClusterRoleBinding()).orElse(null));
    }

    public ClusterRoleBindingNested<A> editOrNewClusterRoleBinding() {
        return this.withNewClusterRoleBindingLike(Optional.ofNullable(this.buildClusterRoleBinding()).orElse(new ResourceTemplateBuilder().build()));
    }

    public ClusterRoleBindingNested<A> editOrNewClusterRoleBindingLike(ResourceTemplate item) {
        return this.withNewClusterRoleBindingLike(Optional.ofNullable(this.buildClusterRoleBinding()).orElse(item));
    }

    public ResourceTemplate buildServiceAccount() {
        return this.serviceAccount != null ? this.serviceAccount.build() : null;
    }

    public A withServiceAccount(ResourceTemplate serviceAccount) {
        this._visitables.get((Object)"serviceAccount").remove((Object)this.serviceAccount);
        if (serviceAccount != null) {
            this.serviceAccount = new ResourceTemplateBuilder(serviceAccount);
            this._visitables.get((Object)"serviceAccount").add(this.serviceAccount);
        } else {
            this.serviceAccount = null;
            this._visitables.get((Object)"serviceAccount").remove((Object)this.serviceAccount);
        }
        return (A)((Object)this);
    }

    public boolean hasServiceAccount() {
        return this.serviceAccount != null;
    }

    public ServiceAccountNested<A> withNewServiceAccount() {
        return new ServiceAccountNested(null);
    }

    public ServiceAccountNested<A> withNewServiceAccountLike(ResourceTemplate item) {
        return new ServiceAccountNested(item);
    }

    public ServiceAccountNested<A> editServiceAccount() {
        return this.withNewServiceAccountLike(Optional.ofNullable(this.buildServiceAccount()).orElse(null));
    }

    public ServiceAccountNested<A> editOrNewServiceAccount() {
        return this.withNewServiceAccountLike(Optional.ofNullable(this.buildServiceAccount()).orElse(new ResourceTemplateBuilder().build()));
    }

    public ServiceAccountNested<A> editOrNewServiceAccountLike(ResourceTemplate item) {
        return this.withNewServiceAccountLike(Optional.ofNullable(this.buildServiceAccount()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaBridgeTemplateFluent that = (KafkaBridgeTemplateFluent)((Object)o);
        if (!Objects.equals((Object)this.deployment, (Object)that.deployment)) {
            return false;
        }
        if (!Objects.equals((Object)this.pod, (Object)that.pod)) {
            return false;
        }
        if (!Objects.equals((Object)this.apiService, (Object)that.apiService)) {
            return false;
        }
        if (!Objects.equals((Object)this.podDisruptionBudget, (Object)that.podDisruptionBudget)) {
            return false;
        }
        if (!Objects.equals((Object)this.bridgeContainer, (Object)that.bridgeContainer)) {
            return false;
        }
        if (!Objects.equals((Object)this.initContainer, (Object)that.initContainer)) {
            return false;
        }
        if (!Objects.equals((Object)this.clusterRoleBinding, (Object)that.clusterRoleBinding)) {
            return false;
        }
        return Objects.equals((Object)this.serviceAccount, (Object)that.serviceAccount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.deployment, this.pod, this.apiService, this.podDisruptionBudget, this.bridgeContainer, this.initContainer, this.clusterRoleBinding, this.serviceAccount, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.deployment != null) {
            sb.append("deployment:");
            sb.append(this.deployment + ",");
        }
        if (this.pod != null) {
            sb.append("pod:");
            sb.append(this.pod + ",");
        }
        if (this.apiService != null) {
            sb.append("apiService:");
            sb.append(this.apiService + ",");
        }
        if (this.podDisruptionBudget != null) {
            sb.append("podDisruptionBudget:");
            sb.append(this.podDisruptionBudget + ",");
        }
        if (this.bridgeContainer != null) {
            sb.append("bridgeContainer:");
            sb.append(this.bridgeContainer + ",");
        }
        if (this.initContainer != null) {
            sb.append("initContainer:");
            sb.append(this.initContainer + ",");
        }
        if (this.clusterRoleBinding != null) {
            sb.append("clusterRoleBinding:");
            sb.append(this.clusterRoleBinding + ",");
        }
        if (this.serviceAccount != null) {
            sb.append("serviceAccount:");
            sb.append((Object)this.serviceAccount);
        }
        sb.append("}");
        return sb.toString();
    }

    public class DeploymentNested<N>
    extends DeploymentTemplateFluent<DeploymentNested<N>>
    implements Nested<N> {
        DeploymentTemplateBuilder builder;

        DeploymentNested(DeploymentTemplate item) {
            this.builder = new DeploymentTemplateBuilder(this, item);
        }

        public N and() {
            return (N)KafkaBridgeTemplateFluent.this.withDeployment(this.builder.build());
        }

        public N endDeployment() {
            return this.and();
        }
    }

    public class PodNested<N>
    extends PodTemplateFluent<PodNested<N>>
    implements Nested<N> {
        PodTemplateBuilder builder;

        PodNested(PodTemplate item) {
            this.builder = new PodTemplateBuilder(this, item);
        }

        public N and() {
            return (N)KafkaBridgeTemplateFluent.this.withPod(this.builder.build());
        }

        public N endPod() {
            return this.and();
        }
    }

    public class ApiServiceNested<N>
    extends InternalServiceTemplateFluent<ApiServiceNested<N>>
    implements Nested<N> {
        InternalServiceTemplateBuilder builder;

        ApiServiceNested(InternalServiceTemplate item) {
            this.builder = new InternalServiceTemplateBuilder(this, item);
        }

        public N and() {
            return (N)KafkaBridgeTemplateFluent.this.withApiService(this.builder.build());
        }

        public N endApiService() {
            return this.and();
        }
    }

    public class PodDisruptionBudgetNested<N>
    extends PodDisruptionBudgetTemplateFluent<PodDisruptionBudgetNested<N>>
    implements Nested<N> {
        PodDisruptionBudgetTemplateBuilder builder;

        PodDisruptionBudgetNested(PodDisruptionBudgetTemplate item) {
            this.builder = new PodDisruptionBudgetTemplateBuilder(this, item);
        }

        public N and() {
            return (N)KafkaBridgeTemplateFluent.this.withPodDisruptionBudget(this.builder.build());
        }

        public N endPodDisruptionBudget() {
            return this.and();
        }
    }

    public class BridgeContainerNested<N>
    extends ContainerTemplateFluent<BridgeContainerNested<N>>
    implements Nested<N> {
        ContainerTemplateBuilder builder;

        BridgeContainerNested(ContainerTemplate item) {
            this.builder = new ContainerTemplateBuilder(this, item);
        }

        public N and() {
            return (N)KafkaBridgeTemplateFluent.this.withBridgeContainer(this.builder.build());
        }

        public N endBridgeContainer() {
            return this.and();
        }
    }

    public class InitContainerNested<N>
    extends ContainerTemplateFluent<InitContainerNested<N>>
    implements Nested<N> {
        ContainerTemplateBuilder builder;

        InitContainerNested(ContainerTemplate item) {
            this.builder = new ContainerTemplateBuilder(this, item);
        }

        public N and() {
            return (N)KafkaBridgeTemplateFluent.this.withInitContainer(this.builder.build());
        }

        public N endInitContainer() {
            return this.and();
        }
    }

    public class ClusterRoleBindingNested<N>
    extends ResourceTemplateFluent<ClusterRoleBindingNested<N>>
    implements Nested<N> {
        ResourceTemplateBuilder builder;

        ClusterRoleBindingNested(ResourceTemplate item) {
            this.builder = new ResourceTemplateBuilder(this, item);
        }

        public N and() {
            return (N)KafkaBridgeTemplateFluent.this.withClusterRoleBinding(this.builder.build());
        }

        public N endClusterRoleBinding() {
            return this.and();
        }
    }

    public class ServiceAccountNested<N>
    extends ResourceTemplateFluent<ServiceAccountNested<N>>
    implements Nested<N> {
        ResourceTemplateBuilder builder;

        ServiceAccountNested(ResourceTemplate item) {
            this.builder = new ResourceTemplateBuilder(this, item);
        }

        public N and() {
            return (N)KafkaBridgeTemplateFluent.this.withServiceAccount(this.builder.build());
        }

        public N endServiceAccount() {
            return this.and();
        }
    }
}

