/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.template;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.annotations.DeprecatedProperty;
import io.strimzi.api.kafka.model.UnknownPropertyPreserving;
import io.strimzi.api.kafka.model.template.ContainerTemplate;
import io.strimzi.api.kafka.model.template.DeploymentTemplate;
import io.strimzi.api.kafka.model.template.PodTemplate;
import io.strimzi.api.kafka.model.template.ResourceTemplate;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.PresentInVersions;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"deployment", "pod", "service", "container", "serviceAccount"})
public class KafkaExporterTemplate
implements Serializable,
UnknownPropertyPreserving {
    private static final long serialVersionUID = 1L;
    private DeploymentTemplate deployment;
    private PodTemplate pod;
    private ResourceTemplate service;
    private ContainerTemplate container;
    private ResourceTemplate serviceAccount;
    private Map<String, Object> additionalProperties = new HashMap<String, Object>(0);

    @Description(value="Template for Kafka Exporter `Deployment`.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public DeploymentTemplate getDeployment() {
        return this.deployment;
    }

    public void setDeployment(DeploymentTemplate deployment) {
        this.deployment = deployment;
    }

    @Description(value="Template for Kafka Exporter `Pods`.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public PodTemplate getPod() {
        return this.pod;
    }

    public void setPod(PodTemplate pod) {
        this.pod = pod;
    }

    @Description(value="Template for Kafka Exporter `Service`.")
    @DeprecatedProperty(description="The Kafka Exporter service has been removed.")
    @PresentInVersions(value="v1alpha1-v1beta2")
    @Deprecated
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public ResourceTemplate getService() {
        return this.service;
    }

    public void setService(ResourceTemplate service) {
        this.service = service;
    }

    @Description(value="Template for the Kafka Exporter container")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public ContainerTemplate getContainer() {
        return this.container;
    }

    public void setContainer(ContainerTemplate container) {
        this.container = container;
    }

    @Description(value="Template for the Kafka Exporter service account.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public ResourceTemplate getServiceAccount() {
        return this.serviceAccount;
    }

    public void setServiceAccount(ResourceTemplate serviceAccount) {
        this.serviceAccount = serviceAccount;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaExporterTemplate)) {
            return false;
        }
        KafkaExporterTemplate other = (KafkaExporterTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DeploymentTemplate this$deployment = this.getDeployment();
        DeploymentTemplate other$deployment = other.getDeployment();
        if (this$deployment == null ? other$deployment != null : !((Object)this$deployment).equals(other$deployment)) {
            return false;
        }
        PodTemplate this$pod = this.getPod();
        PodTemplate other$pod = other.getPod();
        if (this$pod == null ? other$pod != null : !((Object)this$pod).equals(other$pod)) {
            return false;
        }
        ResourceTemplate this$service = this.getService();
        ResourceTemplate other$service = other.getService();
        if (this$service == null ? other$service != null : !((Object)this$service).equals(other$service)) {
            return false;
        }
        ContainerTemplate this$container = this.getContainer();
        ContainerTemplate other$container = other.getContainer();
        if (this$container == null ? other$container != null : !((Object)this$container).equals(other$container)) {
            return false;
        }
        ResourceTemplate this$serviceAccount = this.getServiceAccount();
        ResourceTemplate other$serviceAccount = other.getServiceAccount();
        if (this$serviceAccount == null ? other$serviceAccount != null : !((Object)this$serviceAccount).equals(other$serviceAccount)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaExporterTemplate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DeploymentTemplate $deployment = this.getDeployment();
        result = result * 59 + ($deployment == null ? 43 : ((Object)$deployment).hashCode());
        PodTemplate $pod = this.getPod();
        result = result * 59 + ($pod == null ? 43 : ((Object)$pod).hashCode());
        ResourceTemplate $service = this.getService();
        result = result * 59 + ($service == null ? 43 : ((Object)$service).hashCode());
        ContainerTemplate $container = this.getContainer();
        result = result * 59 + ($container == null ? 43 : ((Object)$container).hashCode());
        ResourceTemplate $serviceAccount = this.getServiceAccount();
        result = result * 59 + ($serviceAccount == null ? 43 : ((Object)$serviceAccount).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

