/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.platform;

public class KubernetesVersion
implements Comparable<KubernetesVersion> {
    private final int major;
    private final int minor;
    public static final KubernetesVersion V1_15 = new KubernetesVersion(1, 15);
    public static final KubernetesVersion V1_21 = new KubernetesVersion(1, 21);
    public static final KubernetesVersion V1_22 = new KubernetesVersion(1, 22);
    public static final KubernetesVersion V1_23 = new KubernetesVersion(1, 23);
    public static final KubernetesVersion V1_24 = new KubernetesVersion(1, 24);
    public static final KubernetesVersion V1_25 = new KubernetesVersion(1, 25);
    public static final KubernetesVersion V1_26 = new KubernetesVersion(1, 26);
    public static final KubernetesVersion MINIMAL_SUPPORTED_VERSION = V1_21;
    public static final int MINIMAL_SUPPORTED_MAJOR = KubernetesVersion.MINIMAL_SUPPORTED_VERSION.major;
    public static final int MINIMAL_SUPPORTED_MINOR = KubernetesVersion.MINIMAL_SUPPORTED_VERSION.minor;

    public KubernetesVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public int hashCode() {
        return this.major << 16 ^ this.minor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KubernetesVersion that = (KubernetesVersion)o;
        return this.major == that.major && this.minor == that.minor;
    }

    @Override
    public int compareTo(KubernetesVersion o) {
        int cmp = Integer.compare(this.major, o.major);
        if (cmp == 0) {
            cmp = Integer.compare(this.minor, o.minor);
        }
        return cmp;
    }

    public String toString() {
        return this.major + "." + this.minor;
    }
}

