/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.common;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.common.CertAndKeySecretSource;
import io.strimzi.api.kafka.model.common.CertAndKeySecretSourceBuilder;
import io.strimzi.api.kafka.model.common.CertSecretSource;
import io.strimzi.api.kafka.model.common.CertSecretSourceBuilder;
import io.strimzi.api.kafka.model.common.CertSecretSourceFluent;
import io.strimzi.api.kafka.model.common.ClientTls;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ClientTlsFluent<A extends ClientTlsFluent<A>>
extends BaseFluent<A> {
    private ArrayList<CertSecretSourceBuilder> trustedCertificates;

    public ClientTlsFluent() {
    }

    public ClientTlsFluent(ClientTls instance) {
        ClientTls clientTls = instance = instance != null ? instance : new ClientTls();
        if (instance != null) {
            this.withTrustedCertificates(instance.getTrustedCertificates());
        }
    }

    public A addToTrustedCertificates(int index, CertSecretSource item) {
        if (this.trustedCertificates == null) {
            this.trustedCertificates = new ArrayList();
        }
        CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
        if (index < 0 || index >= this.trustedCertificates.size()) {
            this._visitables.get((Object)"trustedCertificates").add(builder);
            this.trustedCertificates.add(builder);
        } else {
            this._visitables.get((Object)"trustedCertificates").add(index, builder);
            this.trustedCertificates.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToTrustedCertificates(int index, CertSecretSource item) {
        if (this.trustedCertificates == null) {
            this.trustedCertificates = new ArrayList();
        }
        CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
        if (index < 0 || index >= this.trustedCertificates.size()) {
            this._visitables.get((Object)"trustedCertificates").add(builder);
            this.trustedCertificates.add(builder);
        } else {
            this._visitables.get((Object)"trustedCertificates").set(index, builder);
            this.trustedCertificates.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToTrustedCertificates(CertSecretSource ... items) {
        if (this.trustedCertificates == null) {
            this.trustedCertificates = new ArrayList();
        }
        for (CertSecretSource item : items) {
            CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
            this._visitables.get((Object)"trustedCertificates").add(builder);
            this.trustedCertificates.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToTrustedCertificates(Collection<CertSecretSource> items) {
        if (this.trustedCertificates == null) {
            this.trustedCertificates = new ArrayList();
        }
        for (CertSecretSource item : items) {
            CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
            this._visitables.get((Object)"trustedCertificates").add(builder);
            this.trustedCertificates.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromTrustedCertificates(CertSecretSource ... items) {
        if (this.trustedCertificates == null) {
            return (A)((Object)this);
        }
        for (CertSecretSource item : items) {
            CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
            this._visitables.get((Object)"trustedCertificates").remove((Object)builder);
            this.trustedCertificates.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTrustedCertificates(Collection<CertSecretSource> items) {
        if (this.trustedCertificates == null) {
            return (A)((Object)this);
        }
        for (CertSecretSource item : items) {
            CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
            this._visitables.get((Object)"trustedCertificates").remove((Object)builder);
            this.trustedCertificates.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromTrustedCertificates(Predicate<CertSecretSourceBuilder> predicate) {
        if (this.trustedCertificates == null) {
            return (A)((Object)this);
        }
        Iterator<CertSecretSourceBuilder> each = this.trustedCertificates.iterator();
        List visitables = this._visitables.get((Object)"trustedCertificates");
        while (each.hasNext()) {
            CertSecretSourceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<CertSecretSource> buildTrustedCertificates() {
        return this.trustedCertificates != null ? ClientTlsFluent.build(this.trustedCertificates) : null;
    }

    public CertSecretSource buildTrustedCertificate(int index) {
        return this.trustedCertificates.get(index).build();
    }

    public CertSecretSource buildFirstTrustedCertificate() {
        return this.trustedCertificates.get(0).build();
    }

    public CertSecretSource buildLastTrustedCertificate() {
        return this.trustedCertificates.get(this.trustedCertificates.size() - 1).build();
    }

    public CertSecretSource buildMatchingTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
        for (CertSecretSourceBuilder item : this.trustedCertificates) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
        for (CertSecretSourceBuilder item : this.trustedCertificates) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTrustedCertificates(List<CertSecretSource> trustedCertificates) {
        if (this.trustedCertificates != null) {
            this._visitables.get((Object)"trustedCertificates").clear();
        }
        if (trustedCertificates != null) {
            this.trustedCertificates = new ArrayList();
            for (CertSecretSource item : trustedCertificates) {
                this.addToTrustedCertificates(item);
            }
        } else {
            this.trustedCertificates = null;
        }
        return (A)((Object)this);
    }

    public A withTrustedCertificates(CertSecretSource ... trustedCertificates) {
        if (this.trustedCertificates != null) {
            this.trustedCertificates.clear();
            this._visitables.remove((Object)"trustedCertificates");
        }
        if (trustedCertificates != null) {
            for (CertSecretSource item : trustedCertificates) {
                this.addToTrustedCertificates(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTrustedCertificates() {
        return this.trustedCertificates != null && !this.trustedCertificates.isEmpty();
    }

    public TrustedCertificatesNested<A> addNewTrustedCertificate() {
        return new TrustedCertificatesNested(-1, null);
    }

    public TrustedCertificatesNested<A> addNewTrustedCertificateLike(CertSecretSource item) {
        return new TrustedCertificatesNested(-1, item);
    }

    public TrustedCertificatesNested<A> setNewTrustedCertificateLike(int index, CertSecretSource item) {
        return new TrustedCertificatesNested(index, item);
    }

    public TrustedCertificatesNested<A> editTrustedCertificate(int index) {
        if (this.trustedCertificates.size() <= index) {
            throw new RuntimeException("Can't edit trustedCertificates. Index exceeds size.");
        }
        return this.setNewTrustedCertificateLike(index, this.buildTrustedCertificate(index));
    }

    public TrustedCertificatesNested<A> editFirstTrustedCertificate() {
        if (this.trustedCertificates.size() == 0) {
            throw new RuntimeException("Can't edit first trustedCertificates. The list is empty.");
        }
        return this.setNewTrustedCertificateLike(0, this.buildTrustedCertificate(0));
    }

    public TrustedCertificatesNested<A> editLastTrustedCertificate() {
        int index = this.trustedCertificates.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last trustedCertificates. The list is empty.");
        }
        return this.setNewTrustedCertificateLike(index, this.buildTrustedCertificate(index));
    }

    public TrustedCertificatesNested<A> editMatchingTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.trustedCertificates.size(); ++i) {
            if (!predicate.test(this.trustedCertificates.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching trustedCertificates. No match found.");
        }
        return this.setNewTrustedCertificateLike(index, this.buildTrustedCertificate(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClientTlsFluent that = (ClientTlsFluent)((Object)o);
        return Objects.equals(this.trustedCertificates, that.trustedCertificates);
    }

    public int hashCode() {
        return Objects.hash(this.trustedCertificates, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.trustedCertificates != null && !this.trustedCertificates.isEmpty()) {
            sb.append("trustedCertificates:");
            sb.append(this.trustedCertificates);
        }
        sb.append("}");
        return sb.toString();
    }

    protected static <T> VisitableBuilder<T, ?> builder(Object item) {
        switch (item.getClass().getName()) {
            case "io.strimzi.api.kafka.model.common.CertAndKeySecretSource": {
                return new CertAndKeySecretSourceBuilder((CertAndKeySecretSource)item);
            }
        }
        return ClientTlsFluent.builderOf((Object)item);
    }

    public class TrustedCertificatesNested<N>
    extends CertSecretSourceFluent<TrustedCertificatesNested<N>>
    implements Nested<N> {
        CertSecretSourceBuilder builder;
        int index;

        TrustedCertificatesNested(int index, CertSecretSource item) {
            this.index = index;
            this.builder = new CertSecretSourceBuilder(this, item);
        }

        public N and() {
            return (N)ClientTlsFluent.this.setToTrustedCertificates(this.index, this.builder.build());
        }

        public N endTrustedCertificate() {
            return this.and();
        }
    }
}

