/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.common;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.common.Probe;
import io.strimzi.api.kafka.model.common.ProbeFluent;

public class ProbeBuilder
extends ProbeFluent<ProbeBuilder>
implements VisitableBuilder<Probe, ProbeBuilder> {
    ProbeFluent<?> fluent;
    Boolean validationEnabled;

    public ProbeBuilder() {
        this(false);
    }

    public ProbeBuilder(Boolean validationEnabled) {
        this(new Probe(), validationEnabled);
    }

    public ProbeBuilder(ProbeFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ProbeBuilder(ProbeFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Probe(), validationEnabled);
    }

    public ProbeBuilder(ProbeFluent<?> fluent, Probe instance) {
        this(fluent, instance, false);
    }

    public ProbeBuilder(ProbeFluent<?> fluent, Probe instance, Boolean validationEnabled) {
        this.fluent = fluent;
        Probe probe = instance = instance != null ? instance : new Probe();
        if (instance != null) {
            fluent.withInitialDelaySeconds(instance.getInitialDelaySeconds());
            fluent.withTimeoutSeconds(instance.getTimeoutSeconds());
            fluent.withInitialDelaySeconds(instance.getInitialDelaySeconds());
            fluent.withTimeoutSeconds(instance.getTimeoutSeconds());
            fluent.withPeriodSeconds(instance.getPeriodSeconds());
            fluent.withSuccessThreshold(instance.getSuccessThreshold());
            fluent.withFailureThreshold(instance.getFailureThreshold());
        }
        this.validationEnabled = validationEnabled;
    }

    public ProbeBuilder(Probe instance) {
        this(instance, (Boolean)false);
    }

    public ProbeBuilder(Probe instance, Boolean validationEnabled) {
        this.fluent = this;
        Probe probe = instance = instance != null ? instance : new Probe();
        if (instance != null) {
            this.withInitialDelaySeconds(instance.getInitialDelaySeconds());
            this.withTimeoutSeconds(instance.getTimeoutSeconds());
            this.withInitialDelaySeconds(instance.getInitialDelaySeconds());
            this.withTimeoutSeconds(instance.getTimeoutSeconds());
            this.withPeriodSeconds(instance.getPeriodSeconds());
            this.withSuccessThreshold(instance.getSuccessThreshold());
            this.withFailureThreshold(instance.getFailureThreshold());
        }
        this.validationEnabled = validationEnabled;
    }

    public Probe build() {
        Probe buildable = new Probe(this.fluent.getInitialDelaySeconds(), this.fluent.getTimeoutSeconds());
        buildable.setPeriodSeconds(this.fluent.getPeriodSeconds());
        buildable.setSuccessThreshold(this.fluent.getSuccessThreshold());
        buildable.setFailureThreshold(this.fluent.getFailureThreshold());
        return buildable;
    }
}

