/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.common.template;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.common.template.DeploymentStrategy;
import io.strimzi.api.kafka.model.common.template.DeploymentTemplate;
import io.strimzi.api.kafka.model.common.template.MetadataTemplate;
import io.strimzi.api.kafka.model.common.template.MetadataTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.MetadataTemplateFluent;
import java.util.Objects;
import java.util.Optional;

public class DeploymentTemplateFluent<A extends DeploymentTemplateFluent<A>>
extends BaseFluent<A> {
    private MetadataTemplateBuilder metadata;
    private DeploymentStrategy deploymentStrategy;

    public DeploymentTemplateFluent() {
    }

    public DeploymentTemplateFluent(DeploymentTemplate instance) {
        DeploymentTemplate deploymentTemplate = instance = instance != null ? instance : new DeploymentTemplate();
        if (instance != null) {
            this.withMetadata(instance.getMetadata());
            this.withDeploymentStrategy(instance.getDeploymentStrategy());
        }
    }

    public MetadataTemplate buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(MetadataTemplate metadata) {
        this._visitables.get((Object)"metadata").remove((Object)this.metadata);
        if (metadata != null) {
            this.metadata = new MetadataTemplateBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get((Object)"metadata").remove((Object)this.metadata);
        }
        return (A)((Object)this);
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(MetadataTemplate item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new MetadataTemplateBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(MetadataTemplate item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public DeploymentStrategy getDeploymentStrategy() {
        return this.deploymentStrategy;
    }

    public A withDeploymentStrategy(DeploymentStrategy deploymentStrategy) {
        this.deploymentStrategy = deploymentStrategy;
        return (A)((Object)this);
    }

    public boolean hasDeploymentStrategy() {
        return this.deploymentStrategy != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentTemplateFluent that = (DeploymentTemplateFluent)((Object)o);
        if (!Objects.equals((Object)this.metadata, (Object)that.metadata)) {
            return false;
        }
        return Objects.equals((Object)this.deploymentStrategy, (Object)that.deploymentStrategy);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.metadata, this.deploymentStrategy, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.deploymentStrategy != null) {
            sb.append("deploymentStrategy:");
            sb.append((Object)this.deploymentStrategy);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MetadataNested<N>
    extends MetadataTemplateFluent<MetadataNested<N>>
    implements Nested<N> {
        MetadataTemplateBuilder builder;

        MetadataNested(MetadataTemplate item) {
            this.builder = new MetadataTemplateBuilder(this, item);
        }

        public N and() {
            return (N)DeploymentTemplateFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }
}

