/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.common.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.common.template.StatefulSetTemplate;
import io.strimzi.api.kafka.model.common.template.StatefulSetTemplateFluent;

public class StatefulSetTemplateBuilder
extends StatefulSetTemplateFluent<StatefulSetTemplateBuilder>
implements VisitableBuilder<StatefulSetTemplate, StatefulSetTemplateBuilder> {
    StatefulSetTemplateFluent<?> fluent;
    Boolean validationEnabled;

    public StatefulSetTemplateBuilder() {
        this(false);
    }

    public StatefulSetTemplateBuilder(Boolean validationEnabled) {
        this(new StatefulSetTemplate(), validationEnabled);
    }

    public StatefulSetTemplateBuilder(StatefulSetTemplateFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public StatefulSetTemplateBuilder(StatefulSetTemplateFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new StatefulSetTemplate(), validationEnabled);
    }

    public StatefulSetTemplateBuilder(StatefulSetTemplateFluent<?> fluent, StatefulSetTemplate instance) {
        this(fluent, instance, false);
    }

    public StatefulSetTemplateBuilder(StatefulSetTemplateFluent<?> fluent, StatefulSetTemplate instance, Boolean validationEnabled) {
        this.fluent = fluent;
        StatefulSetTemplate statefulSetTemplate = instance = instance != null ? instance : new StatefulSetTemplate();
        if (instance != null) {
            fluent.withMetadata(instance.getMetadata());
            fluent.withPodManagementPolicy(instance.getPodManagementPolicy());
        }
        this.validationEnabled = validationEnabled;
    }

    public StatefulSetTemplateBuilder(StatefulSetTemplate instance) {
        this(instance, (Boolean)false);
    }

    public StatefulSetTemplateBuilder(StatefulSetTemplate instance, Boolean validationEnabled) {
        this.fluent = this;
        StatefulSetTemplate statefulSetTemplate = instance = instance != null ? instance : new StatefulSetTemplate();
        if (instance != null) {
            this.withMetadata(instance.getMetadata());
            this.withPodManagementPolicy(instance.getPodManagementPolicy());
        }
        this.validationEnabled = validationEnabled;
    }

    public StatefulSetTemplate build() {
        StatefulSetTemplate buildable = new StatefulSetTemplate();
        buildable.setMetadata(this.fluent.buildMetadata());
        buildable.setPodManagementPolicy(this.fluent.getPodManagementPolicy());
        return buildable;
    }
}

