/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.connect;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.connect.ConnectorPlugin;
import io.strimzi.api.kafka.model.connect.ConnectorPluginFluent;

public class ConnectorPluginBuilder
extends ConnectorPluginFluent<ConnectorPluginBuilder>
implements VisitableBuilder<ConnectorPlugin, ConnectorPluginBuilder> {
    ConnectorPluginFluent<?> fluent;
    Boolean validationEnabled;

    public ConnectorPluginBuilder() {
        this(false);
    }

    public ConnectorPluginBuilder(Boolean validationEnabled) {
        this(new ConnectorPlugin(), validationEnabled);
    }

    public ConnectorPluginBuilder(ConnectorPluginFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ConnectorPluginBuilder(ConnectorPluginFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ConnectorPlugin(), validationEnabled);
    }

    public ConnectorPluginBuilder(ConnectorPluginFluent<?> fluent, ConnectorPlugin instance) {
        this(fluent, instance, false);
    }

    public ConnectorPluginBuilder(ConnectorPluginFluent<?> fluent, ConnectorPlugin instance, Boolean validationEnabled) {
        this.fluent = fluent;
        ConnectorPlugin connectorPlugin = instance = instance != null ? instance : new ConnectorPlugin();
        if (instance != null) {
            fluent.withConnectorClass(instance.getConnectorClass());
            fluent.withType(instance.getType());
            fluent.withVersion(instance.getVersion());
        }
        this.validationEnabled = validationEnabled;
    }

    public ConnectorPluginBuilder(ConnectorPlugin instance) {
        this(instance, (Boolean)false);
    }

    public ConnectorPluginBuilder(ConnectorPlugin instance, Boolean validationEnabled) {
        this.fluent = this;
        ConnectorPlugin connectorPlugin = instance = instance != null ? instance : new ConnectorPlugin();
        if (instance != null) {
            this.withConnectorClass(instance.getConnectorClass());
            this.withType(instance.getType());
            this.withVersion(instance.getVersion());
        }
        this.validationEnabled = validationEnabled;
    }

    public ConnectorPlugin build() {
        ConnectorPlugin buildable = new ConnectorPlugin();
        buildable.setConnectorClass(this.fluent.getConnectorClass());
        buildable.setType(this.fluent.getType());
        buildable.setVersion(this.fluent.getVersion());
        return buildable;
    }
}

