/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.connect.build;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.strimzi.api.kafka.model.connect.build.Artifact;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.Pattern;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class DownloadableArtifact
extends Artifact {
    private static final long serialVersionUID = 1L;
    private String url;
    private String sha512sum;
    private Boolean insecure;

    @Description(value="URL of the artifact which will be downloaded. Strimzi does not do any security scanning of the downloaded artifacts. For security reasons, you should first verify the artifacts manually and configure the checksum verification to make sure the same artifact is used in the automated build. Required for `jar`, `zip`, `tgz` and `other` artifacts. Not applicable to the `maven` artifact type.")
    @Pattern(value="^(https?|ftp)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]$")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Description(value="SHA512 checksum of the artifact. Optional. If specified, the checksum will be verified while building the new container. If not specified, the downloaded artifact will not be verified. Not applicable to the `maven` artifact type. ")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSha512sum() {
        return this.sha512sum;
    }

    public void setSha512sum(String sha512sum) {
        this.sha512sum = sha512sum;
    }

    @Description(value="By default, connections using TLS are verified to check they are secure. The server certificate used must be valid, trusted, and contain the server name. By setting this option to `true`, all TLS verification is disabled and the artifact will be downloaded, even when the server is considered insecure.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getInsecure() {
        return this.insecure;
    }

    public void setInsecure(Boolean insecure) {
        this.insecure = insecure;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DownloadableArtifact)) {
            return false;
        }
        DownloadableArtifact other = (DownloadableArtifact)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$insecure = this.getInsecure();
        Boolean other$insecure = other.getInsecure();
        if (this$insecure == null ? other$insecure != null : !((Object)this$insecure).equals(other$insecure)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$sha512sum = this.getSha512sum();
        String other$sha512sum = other.getSha512sum();
        return !(this$sha512sum == null ? other$sha512sum != null : !this$sha512sum.equals(other$sha512sum));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DownloadableArtifact;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $insecure = this.getInsecure();
        result = result * 59 + ($insecure == null ? 43 : ((Object)$insecure).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $sha512sum = this.getSha512sum();
        result = result * 59 + ($sha512sum == null ? 43 : $sha512sum.hashCode());
        return result;
    }
}

