/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.kafka;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.kafka.KafkaAuthorization;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.DescriptionFile;
import io.strimzi.crdgenerator.annotations.Example;
import java.util.List;

@DescriptionFile
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "authorizerClass", "superUsers", "supportsAdminApi"})
public class KafkaAuthorizationCustom
extends KafkaAuthorization {
    private static final long serialVersionUID = 1L;
    public static final String TYPE_CUSTOM = "custom";
    private String authorizerClass;
    private List<String> superUsers;
    private boolean supportsAdminApi = false;

    @Override
    @Description(value="Must be `custom`")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getType() {
        return TYPE_CUSTOM;
    }

    @Override
    public boolean supportsAdminApi() {
        return this.supportsAdminApi;
    }

    @Description(value="List of super users, which are user principals with unlimited access rights.")
    @Example(value="- CN=my-user\n- CN=my-other-user")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getSuperUsers() {
        return this.superUsers;
    }

    public void setSuperUsers(List<String> superUsers) {
        this.superUsers = superUsers;
    }

    @Description(value="Authorization implementation class, which must be available in classpath")
    public String getAuthorizerClass() {
        return this.authorizerClass;
    }

    public void setAuthorizerClass(String clazz) {
        this.authorizerClass = clazz;
    }

    @Description(value="Indicates whether the custom authorizer supports the APIs for managing ACLs using the Kafka Admin API. Defaults to `false`.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isSupportsAdminApi() {
        return this.supportsAdminApi;
    }

    public void setSupportsAdminApi(boolean supportsAdminApi) {
        this.supportsAdminApi = supportsAdminApi;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaAuthorizationCustom)) {
            return false;
        }
        KafkaAuthorizationCustom other = (KafkaAuthorizationCustom)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSupportsAdminApi() != other.isSupportsAdminApi()) {
            return false;
        }
        String this$authorizerClass = this.getAuthorizerClass();
        String other$authorizerClass = other.getAuthorizerClass();
        if (this$authorizerClass == null ? other$authorizerClass != null : !this$authorizerClass.equals(other$authorizerClass)) {
            return false;
        }
        List<String> this$superUsers = this.getSuperUsers();
        List<String> other$superUsers = other.getSuperUsers();
        return !(this$superUsers == null ? other$superUsers != null : !((Object)this$superUsers).equals(other$superUsers));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KafkaAuthorizationCustom;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSupportsAdminApi() ? 79 : 97);
        String $authorizerClass = this.getAuthorizerClass();
        result = result * 59 + ($authorizerClass == null ? 43 : $authorizerClass.hashCode());
        List<String> $superUsers = this.getSuperUsers();
        result = result * 59 + ($superUsers == null ? 43 : ((Object)$superUsers).hashCode());
        return result;
    }
}

