/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.kafka;

import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.common.CertificateAuthority;
import io.strimzi.api.kafka.model.common.CertificateAuthorityBuilder;
import io.strimzi.api.kafka.model.common.CertificateAuthorityFluent;
import io.strimzi.api.kafka.model.common.SpecFluent;
import io.strimzi.api.kafka.model.jmxtrans.JmxTransSpec;
import io.strimzi.api.kafka.model.jmxtrans.JmxTransSpecBuilder;
import io.strimzi.api.kafka.model.jmxtrans.JmxTransSpecFluent;
import io.strimzi.api.kafka.model.kafka.KafkaClusterSpec;
import io.strimzi.api.kafka.model.kafka.KafkaClusterSpecBuilder;
import io.strimzi.api.kafka.model.kafka.KafkaClusterSpecFluent;
import io.strimzi.api.kafka.model.kafka.KafkaSpec;
import io.strimzi.api.kafka.model.kafka.cruisecontrol.CruiseControlSpec;
import io.strimzi.api.kafka.model.kafka.cruisecontrol.CruiseControlSpecBuilder;
import io.strimzi.api.kafka.model.kafka.cruisecontrol.CruiseControlSpecFluent;
import io.strimzi.api.kafka.model.kafka.entityoperator.EntityOperatorSpec;
import io.strimzi.api.kafka.model.kafka.entityoperator.EntityOperatorSpecBuilder;
import io.strimzi.api.kafka.model.kafka.entityoperator.EntityOperatorSpecFluent;
import io.strimzi.api.kafka.model.kafka.exporter.KafkaExporterSpec;
import io.strimzi.api.kafka.model.kafka.exporter.KafkaExporterSpecBuilder;
import io.strimzi.api.kafka.model.kafka.exporter.KafkaExporterSpecFluent;
import io.strimzi.api.kafka.model.zookeeper.ZookeeperClusterSpec;
import io.strimzi.api.kafka.model.zookeeper.ZookeeperClusterSpecBuilder;
import io.strimzi.api.kafka.model.zookeeper.ZookeeperClusterSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class KafkaSpecFluent<A extends KafkaSpecFluent<A>>
extends SpecFluent<A> {
    private KafkaClusterSpecBuilder kafka;
    private ZookeeperClusterSpecBuilder zookeeper;
    private EntityOperatorSpecBuilder entityOperator;
    private CertificateAuthorityBuilder clusterCa;
    private JmxTransSpecBuilder jmxTrans;
    private KafkaExporterSpecBuilder kafkaExporter;
    private CruiseControlSpecBuilder cruiseControl;
    private CertificateAuthorityBuilder clientsCa;
    private List<String> maintenanceTimeWindows;

    public KafkaSpecFluent() {
    }

    public KafkaSpecFluent(KafkaSpec instance) {
        KafkaSpec kafkaSpec = instance = instance != null ? instance : new KafkaSpec();
        if (instance != null) {
            this.withKafka(instance.getKafka());
            this.withZookeeper(instance.getZookeeper());
            this.withEntityOperator(instance.getEntityOperator());
            this.withClusterCa(instance.getClusterCa());
            this.withJmxTrans(instance.getJmxTrans());
            this.withKafkaExporter(instance.getKafkaExporter());
            this.withCruiseControl(instance.getCruiseControl());
            this.withClientsCa(instance.getClientsCa());
            this.withMaintenanceTimeWindows(instance.getMaintenanceTimeWindows());
        }
    }

    public KafkaClusterSpec buildKafka() {
        return this.kafka != null ? this.kafka.build() : null;
    }

    public A withKafka(KafkaClusterSpec kafka) {
        this._visitables.get((Object)"kafka").remove((Object)this.kafka);
        if (kafka != null) {
            this.kafka = new KafkaClusterSpecBuilder(kafka);
            this._visitables.get((Object)"kafka").add(this.kafka);
        } else {
            this.kafka = null;
            this._visitables.get((Object)"kafka").remove((Object)this.kafka);
        }
        return (A)((Object)this);
    }

    public boolean hasKafka() {
        return this.kafka != null;
    }

    public KafkaNested<A> withNewKafka() {
        return new KafkaNested(null);
    }

    public KafkaNested<A> withNewKafkaLike(KafkaClusterSpec item) {
        return new KafkaNested(item);
    }

    public KafkaNested<A> editKafka() {
        return this.withNewKafkaLike(Optional.ofNullable(this.buildKafka()).orElse(null));
    }

    public KafkaNested<A> editOrNewKafka() {
        return this.withNewKafkaLike(Optional.ofNullable(this.buildKafka()).orElse(new KafkaClusterSpecBuilder().build()));
    }

    public KafkaNested<A> editOrNewKafkaLike(KafkaClusterSpec item) {
        return this.withNewKafkaLike(Optional.ofNullable(this.buildKafka()).orElse(item));
    }

    public ZookeeperClusterSpec buildZookeeper() {
        return this.zookeeper != null ? this.zookeeper.build() : null;
    }

    public A withZookeeper(ZookeeperClusterSpec zookeeper) {
        this._visitables.get((Object)"zookeeper").remove((Object)this.zookeeper);
        if (zookeeper != null) {
            this.zookeeper = new ZookeeperClusterSpecBuilder(zookeeper);
            this._visitables.get((Object)"zookeeper").add(this.zookeeper);
        } else {
            this.zookeeper = null;
            this._visitables.get((Object)"zookeeper").remove((Object)this.zookeeper);
        }
        return (A)((Object)this);
    }

    public boolean hasZookeeper() {
        return this.zookeeper != null;
    }

    public ZookeeperNested<A> withNewZookeeper() {
        return new ZookeeperNested(null);
    }

    public ZookeeperNested<A> withNewZookeeperLike(ZookeeperClusterSpec item) {
        return new ZookeeperNested(item);
    }

    public ZookeeperNested<A> editZookeeper() {
        return this.withNewZookeeperLike(Optional.ofNullable(this.buildZookeeper()).orElse(null));
    }

    public ZookeeperNested<A> editOrNewZookeeper() {
        return this.withNewZookeeperLike(Optional.ofNullable(this.buildZookeeper()).orElse(new ZookeeperClusterSpecBuilder().build()));
    }

    public ZookeeperNested<A> editOrNewZookeeperLike(ZookeeperClusterSpec item) {
        return this.withNewZookeeperLike(Optional.ofNullable(this.buildZookeeper()).orElse(item));
    }

    public EntityOperatorSpec buildEntityOperator() {
        return this.entityOperator != null ? this.entityOperator.build() : null;
    }

    public A withEntityOperator(EntityOperatorSpec entityOperator) {
        this._visitables.get((Object)"entityOperator").remove((Object)this.entityOperator);
        if (entityOperator != null) {
            this.entityOperator = new EntityOperatorSpecBuilder(entityOperator);
            this._visitables.get((Object)"entityOperator").add(this.entityOperator);
        } else {
            this.entityOperator = null;
            this._visitables.get((Object)"entityOperator").remove((Object)this.entityOperator);
        }
        return (A)((Object)this);
    }

    public boolean hasEntityOperator() {
        return this.entityOperator != null;
    }

    public EntityOperatorNested<A> withNewEntityOperator() {
        return new EntityOperatorNested(null);
    }

    public EntityOperatorNested<A> withNewEntityOperatorLike(EntityOperatorSpec item) {
        return new EntityOperatorNested(item);
    }

    public EntityOperatorNested<A> editEntityOperator() {
        return this.withNewEntityOperatorLike(Optional.ofNullable(this.buildEntityOperator()).orElse(null));
    }

    public EntityOperatorNested<A> editOrNewEntityOperator() {
        return this.withNewEntityOperatorLike(Optional.ofNullable(this.buildEntityOperator()).orElse(new EntityOperatorSpecBuilder().build()));
    }

    public EntityOperatorNested<A> editOrNewEntityOperatorLike(EntityOperatorSpec item) {
        return this.withNewEntityOperatorLike(Optional.ofNullable(this.buildEntityOperator()).orElse(item));
    }

    public CertificateAuthority buildClusterCa() {
        return this.clusterCa != null ? this.clusterCa.build() : null;
    }

    public A withClusterCa(CertificateAuthority clusterCa) {
        this._visitables.get((Object)"clusterCa").remove((Object)this.clusterCa);
        if (clusterCa != null) {
            this.clusterCa = new CertificateAuthorityBuilder(clusterCa);
            this._visitables.get((Object)"clusterCa").add(this.clusterCa);
        } else {
            this.clusterCa = null;
            this._visitables.get((Object)"clusterCa").remove((Object)this.clusterCa);
        }
        return (A)((Object)this);
    }

    public boolean hasClusterCa() {
        return this.clusterCa != null;
    }

    public ClusterCaNested<A> withNewClusterCa() {
        return new ClusterCaNested(null);
    }

    public ClusterCaNested<A> withNewClusterCaLike(CertificateAuthority item) {
        return new ClusterCaNested(item);
    }

    public ClusterCaNested<A> editClusterCa() {
        return this.withNewClusterCaLike(Optional.ofNullable(this.buildClusterCa()).orElse(null));
    }

    public ClusterCaNested<A> editOrNewClusterCa() {
        return this.withNewClusterCaLike(Optional.ofNullable(this.buildClusterCa()).orElse(new CertificateAuthorityBuilder().build()));
    }

    public ClusterCaNested<A> editOrNewClusterCaLike(CertificateAuthority item) {
        return this.withNewClusterCaLike(Optional.ofNullable(this.buildClusterCa()).orElse(item));
    }

    public JmxTransSpec buildJmxTrans() {
        return this.jmxTrans != null ? this.jmxTrans.build() : null;
    }

    public A withJmxTrans(JmxTransSpec jmxTrans) {
        this._visitables.get((Object)"jmxTrans").remove((Object)this.jmxTrans);
        if (jmxTrans != null) {
            this.jmxTrans = new JmxTransSpecBuilder(jmxTrans);
            this._visitables.get((Object)"jmxTrans").add(this.jmxTrans);
        } else {
            this.jmxTrans = null;
            this._visitables.get((Object)"jmxTrans").remove((Object)this.jmxTrans);
        }
        return (A)((Object)this);
    }

    public boolean hasJmxTrans() {
        return this.jmxTrans != null;
    }

    public JmxTransNested<A> withNewJmxTrans() {
        return new JmxTransNested(null);
    }

    public JmxTransNested<A> withNewJmxTransLike(JmxTransSpec item) {
        return new JmxTransNested(item);
    }

    public JmxTransNested<A> editJmxTrans() {
        return this.withNewJmxTransLike(Optional.ofNullable(this.buildJmxTrans()).orElse(null));
    }

    public JmxTransNested<A> editOrNewJmxTrans() {
        return this.withNewJmxTransLike(Optional.ofNullable(this.buildJmxTrans()).orElse(new JmxTransSpecBuilder().build()));
    }

    public JmxTransNested<A> editOrNewJmxTransLike(JmxTransSpec item) {
        return this.withNewJmxTransLike(Optional.ofNullable(this.buildJmxTrans()).orElse(item));
    }

    public KafkaExporterSpec buildKafkaExporter() {
        return this.kafkaExporter != null ? this.kafkaExporter.build() : null;
    }

    public A withKafkaExporter(KafkaExporterSpec kafkaExporter) {
        this._visitables.get((Object)"kafkaExporter").remove((Object)this.kafkaExporter);
        if (kafkaExporter != null) {
            this.kafkaExporter = new KafkaExporterSpecBuilder(kafkaExporter);
            this._visitables.get((Object)"kafkaExporter").add(this.kafkaExporter);
        } else {
            this.kafkaExporter = null;
            this._visitables.get((Object)"kafkaExporter").remove((Object)this.kafkaExporter);
        }
        return (A)((Object)this);
    }

    public boolean hasKafkaExporter() {
        return this.kafkaExporter != null;
    }

    public KafkaExporterNested<A> withNewKafkaExporter() {
        return new KafkaExporterNested(null);
    }

    public KafkaExporterNested<A> withNewKafkaExporterLike(KafkaExporterSpec item) {
        return new KafkaExporterNested(item);
    }

    public KafkaExporterNested<A> editKafkaExporter() {
        return this.withNewKafkaExporterLike(Optional.ofNullable(this.buildKafkaExporter()).orElse(null));
    }

    public KafkaExporterNested<A> editOrNewKafkaExporter() {
        return this.withNewKafkaExporterLike(Optional.ofNullable(this.buildKafkaExporter()).orElse(new KafkaExporterSpecBuilder().build()));
    }

    public KafkaExporterNested<A> editOrNewKafkaExporterLike(KafkaExporterSpec item) {
        return this.withNewKafkaExporterLike(Optional.ofNullable(this.buildKafkaExporter()).orElse(item));
    }

    public CruiseControlSpec buildCruiseControl() {
        return this.cruiseControl != null ? this.cruiseControl.build() : null;
    }

    public A withCruiseControl(CruiseControlSpec cruiseControl) {
        this._visitables.get((Object)"cruiseControl").remove((Object)this.cruiseControl);
        if (cruiseControl != null) {
            this.cruiseControl = new CruiseControlSpecBuilder(cruiseControl);
            this._visitables.get((Object)"cruiseControl").add(this.cruiseControl);
        } else {
            this.cruiseControl = null;
            this._visitables.get((Object)"cruiseControl").remove((Object)this.cruiseControl);
        }
        return (A)((Object)this);
    }

    public boolean hasCruiseControl() {
        return this.cruiseControl != null;
    }

    public CruiseControlNested<A> withNewCruiseControl() {
        return new CruiseControlNested(null);
    }

    public CruiseControlNested<A> withNewCruiseControlLike(CruiseControlSpec item) {
        return new CruiseControlNested(item);
    }

    public CruiseControlNested<A> editCruiseControl() {
        return this.withNewCruiseControlLike(Optional.ofNullable(this.buildCruiseControl()).orElse(null));
    }

    public CruiseControlNested<A> editOrNewCruiseControl() {
        return this.withNewCruiseControlLike(Optional.ofNullable(this.buildCruiseControl()).orElse(new CruiseControlSpecBuilder().build()));
    }

    public CruiseControlNested<A> editOrNewCruiseControlLike(CruiseControlSpec item) {
        return this.withNewCruiseControlLike(Optional.ofNullable(this.buildCruiseControl()).orElse(item));
    }

    public CertificateAuthority buildClientsCa() {
        return this.clientsCa != null ? this.clientsCa.build() : null;
    }

    public A withClientsCa(CertificateAuthority clientsCa) {
        this._visitables.get((Object)"clientsCa").remove((Object)this.clientsCa);
        if (clientsCa != null) {
            this.clientsCa = new CertificateAuthorityBuilder(clientsCa);
            this._visitables.get((Object)"clientsCa").add(this.clientsCa);
        } else {
            this.clientsCa = null;
            this._visitables.get((Object)"clientsCa").remove((Object)this.clientsCa);
        }
        return (A)((Object)this);
    }

    public boolean hasClientsCa() {
        return this.clientsCa != null;
    }

    public ClientsCaNested<A> withNewClientsCa() {
        return new ClientsCaNested(null);
    }

    public ClientsCaNested<A> withNewClientsCaLike(CertificateAuthority item) {
        return new ClientsCaNested(item);
    }

    public ClientsCaNested<A> editClientsCa() {
        return this.withNewClientsCaLike(Optional.ofNullable(this.buildClientsCa()).orElse(null));
    }

    public ClientsCaNested<A> editOrNewClientsCa() {
        return this.withNewClientsCaLike(Optional.ofNullable(this.buildClientsCa()).orElse(new CertificateAuthorityBuilder().build()));
    }

    public ClientsCaNested<A> editOrNewClientsCaLike(CertificateAuthority item) {
        return this.withNewClientsCaLike(Optional.ofNullable(this.buildClientsCa()).orElse(item));
    }

    public A addToMaintenanceTimeWindows(int index, String item) {
        if (this.maintenanceTimeWindows == null) {
            this.maintenanceTimeWindows = new ArrayList<String>();
        }
        this.maintenanceTimeWindows.add(index, item);
        return (A)((Object)this);
    }

    public A setToMaintenanceTimeWindows(int index, String item) {
        if (this.maintenanceTimeWindows == null) {
            this.maintenanceTimeWindows = new ArrayList<String>();
        }
        this.maintenanceTimeWindows.set(index, item);
        return (A)((Object)this);
    }

    public A addToMaintenanceTimeWindows(String ... items) {
        if (this.maintenanceTimeWindows == null) {
            this.maintenanceTimeWindows = new ArrayList<String>();
        }
        for (String item : items) {
            this.maintenanceTimeWindows.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToMaintenanceTimeWindows(Collection<String> items) {
        if (this.maintenanceTimeWindows == null) {
            this.maintenanceTimeWindows = new ArrayList<String>();
        }
        for (String item : items) {
            this.maintenanceTimeWindows.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromMaintenanceTimeWindows(String ... items) {
        if (this.maintenanceTimeWindows == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.maintenanceTimeWindows.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromMaintenanceTimeWindows(Collection<String> items) {
        if (this.maintenanceTimeWindows == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.maintenanceTimeWindows.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getMaintenanceTimeWindows() {
        return this.maintenanceTimeWindows;
    }

    public String getMaintenanceTimeWindow(int index) {
        return this.maintenanceTimeWindows.get(index);
    }

    public String getFirstMaintenanceTimeWindow() {
        return this.maintenanceTimeWindows.get(0);
    }

    public String getLastMaintenanceTimeWindow() {
        return this.maintenanceTimeWindows.get(this.maintenanceTimeWindows.size() - 1);
    }

    public String getMatchingMaintenanceTimeWindow(Predicate<String> predicate) {
        for (String item : this.maintenanceTimeWindows) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingMaintenanceTimeWindow(Predicate<String> predicate) {
        for (String item : this.maintenanceTimeWindows) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withMaintenanceTimeWindows(List<String> maintenanceTimeWindows) {
        if (maintenanceTimeWindows != null) {
            this.maintenanceTimeWindows = new ArrayList<String>();
            for (String item : maintenanceTimeWindows) {
                this.addToMaintenanceTimeWindows(item);
            }
        } else {
            this.maintenanceTimeWindows = null;
        }
        return (A)((Object)this);
    }

    public A withMaintenanceTimeWindows(String ... maintenanceTimeWindows) {
        if (this.maintenanceTimeWindows != null) {
            this.maintenanceTimeWindows.clear();
            this._visitables.remove((Object)"maintenanceTimeWindows");
        }
        if (maintenanceTimeWindows != null) {
            for (String item : maintenanceTimeWindows) {
                this.addToMaintenanceTimeWindows(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasMaintenanceTimeWindows() {
        return this.maintenanceTimeWindows != null && !this.maintenanceTimeWindows.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaSpecFluent that = (KafkaSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.kafka, (Object)that.kafka)) {
            return false;
        }
        if (!Objects.equals((Object)this.zookeeper, (Object)that.zookeeper)) {
            return false;
        }
        if (!Objects.equals((Object)this.entityOperator, (Object)that.entityOperator)) {
            return false;
        }
        if (!Objects.equals((Object)this.clusterCa, (Object)that.clusterCa)) {
            return false;
        }
        if (!Objects.equals((Object)this.jmxTrans, (Object)that.jmxTrans)) {
            return false;
        }
        if (!Objects.equals((Object)this.kafkaExporter, (Object)that.kafkaExporter)) {
            return false;
        }
        if (!Objects.equals((Object)this.cruiseControl, (Object)that.cruiseControl)) {
            return false;
        }
        if (!Objects.equals((Object)this.clientsCa, (Object)that.clientsCa)) {
            return false;
        }
        return Objects.equals(this.maintenanceTimeWindows, that.maintenanceTimeWindows);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.kafka, this.zookeeper, this.entityOperator, this.clusterCa, this.jmxTrans, this.kafkaExporter, this.cruiseControl, this.clientsCa, this.maintenanceTimeWindows, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.kafka != null) {
            sb.append("kafka:");
            sb.append(this.kafka + ",");
        }
        if (this.zookeeper != null) {
            sb.append("zookeeper:");
            sb.append(this.zookeeper + ",");
        }
        if (this.entityOperator != null) {
            sb.append("entityOperator:");
            sb.append(this.entityOperator + ",");
        }
        if (this.clusterCa != null) {
            sb.append("clusterCa:");
            sb.append(this.clusterCa + ",");
        }
        if (this.jmxTrans != null) {
            sb.append("jmxTrans:");
            sb.append(this.jmxTrans + ",");
        }
        if (this.kafkaExporter != null) {
            sb.append("kafkaExporter:");
            sb.append(this.kafkaExporter + ",");
        }
        if (this.cruiseControl != null) {
            sb.append("cruiseControl:");
            sb.append(this.cruiseControl + ",");
        }
        if (this.clientsCa != null) {
            sb.append("clientsCa:");
            sb.append(this.clientsCa + ",");
        }
        if (this.maintenanceTimeWindows != null && !this.maintenanceTimeWindows.isEmpty()) {
            sb.append("maintenanceTimeWindows:");
            sb.append(this.maintenanceTimeWindows);
        }
        sb.append("}");
        return sb.toString();
    }

    public class KafkaNested<N>
    extends KafkaClusterSpecFluent<KafkaNested<N>>
    implements Nested<N> {
        KafkaClusterSpecBuilder builder;

        KafkaNested(KafkaClusterSpec item) {
            this.builder = new KafkaClusterSpecBuilder(this, item);
        }

        public N and() {
            return (N)KafkaSpecFluent.this.withKafka(this.builder.build());
        }

        public N endKafka() {
            return this.and();
        }
    }

    public class ZookeeperNested<N>
    extends ZookeeperClusterSpecFluent<ZookeeperNested<N>>
    implements Nested<N> {
        ZookeeperClusterSpecBuilder builder;

        ZookeeperNested(ZookeeperClusterSpec item) {
            this.builder = new ZookeeperClusterSpecBuilder(this, item);
        }

        public N and() {
            return (N)KafkaSpecFluent.this.withZookeeper(this.builder.build());
        }

        public N endZookeeper() {
            return this.and();
        }
    }

    public class EntityOperatorNested<N>
    extends EntityOperatorSpecFluent<EntityOperatorNested<N>>
    implements Nested<N> {
        EntityOperatorSpecBuilder builder;

        EntityOperatorNested(EntityOperatorSpec item) {
            this.builder = new EntityOperatorSpecBuilder(this, item);
        }

        public N and() {
            return (N)KafkaSpecFluent.this.withEntityOperator(this.builder.build());
        }

        public N endEntityOperator() {
            return this.and();
        }
    }

    public class ClusterCaNested<N>
    extends CertificateAuthorityFluent<ClusterCaNested<N>>
    implements Nested<N> {
        CertificateAuthorityBuilder builder;

        ClusterCaNested(CertificateAuthority item) {
            this.builder = new CertificateAuthorityBuilder(this, item);
        }

        public N and() {
            return (N)KafkaSpecFluent.this.withClusterCa(this.builder.build());
        }

        public N endClusterCa() {
            return this.and();
        }
    }

    public class JmxTransNested<N>
    extends JmxTransSpecFluent<JmxTransNested<N>>
    implements Nested<N> {
        JmxTransSpecBuilder builder;

        JmxTransNested(JmxTransSpec item) {
            this.builder = new JmxTransSpecBuilder(this, item);
        }

        public N and() {
            return (N)KafkaSpecFluent.this.withJmxTrans(this.builder.build());
        }

        public N endJmxTrans() {
            return this.and();
        }
    }

    public class KafkaExporterNested<N>
    extends KafkaExporterSpecFluent<KafkaExporterNested<N>>
    implements Nested<N> {
        KafkaExporterSpecBuilder builder;

        KafkaExporterNested(KafkaExporterSpec item) {
            this.builder = new KafkaExporterSpecBuilder(this, item);
        }

        public N and() {
            return (N)KafkaSpecFluent.this.withKafkaExporter(this.builder.build());
        }

        public N endKafkaExporter() {
            return this.and();
        }
    }

    public class CruiseControlNested<N>
    extends CruiseControlSpecFluent<CruiseControlNested<N>>
    implements Nested<N> {
        CruiseControlSpecBuilder builder;

        CruiseControlNested(CruiseControlSpec item) {
            this.builder = new CruiseControlSpecBuilder(this, item);
        }

        public N and() {
            return (N)KafkaSpecFluent.this.withCruiseControl(this.builder.build());
        }

        public N endCruiseControl() {
            return this.and();
        }
    }

    public class ClientsCaNested<N>
    extends CertificateAuthorityFluent<ClientsCaNested<N>>
    implements Nested<N> {
        CertificateAuthorityBuilder builder;

        ClientsCaNested(CertificateAuthority item) {
            this.builder = new CertificateAuthorityBuilder(this, item);
        }

        public N and() {
            return (N)KafkaSpecFluent.this.withClientsCa(this.builder.build());
        }

        public N endClientsCa() {
            return this.and();
        }
    }
}

