/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.kafka;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.strimzi.api.kafka.model.kafka.EphemeralStorage;
import io.strimzi.api.kafka.model.kafka.PersistentClaimStorage;
import io.strimzi.api.kafka.model.kafka.Storage;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.Minimum;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=EphemeralStorage.class, name="ephemeral"), @JsonSubTypes.Type(value=PersistentClaimStorage.class, name="persistent-claim")})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class SingleVolumeStorage
extends Storage {
    private static final long serialVersionUID = 1L;
    private Integer id;

    @Override
    @Description(value="Storage type, must be either 'ephemeral' or 'persistent-claim'.")
    public abstract String getType();

    @Description(value="Storage identification number. It is mandatory only for storage volumes defined in a storage of type 'jbod'")
    @Minimum(value=0)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SingleVolumeStorage)) {
            return false;
        }
        SingleVolumeStorage other = (SingleVolumeStorage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SingleVolumeStorage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

