/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.kafka.cruisecontrol;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.common.UnknownPropertyPreserving;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.Pattern;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"brokers", "cpu", "inboundNetwork", "outboundNetwork"})
public class BrokerCapacityOverride
implements UnknownPropertyPreserving,
Serializable {
    private static final long serialVersionUID = 1L;
    private List<Integer> brokers;
    private String cpu;
    private String inboundNetwork;
    private String outboundNetwork;
    private Map<String, Object> additionalProperties = new HashMap<String, Object>(0);

    @JsonInclude(content=JsonInclude.Include.NON_NULL, value=JsonInclude.Include.NON_EMPTY)
    @Pattern(value="^\\[[0-9,]*\\]$")
    @Description(value="List of Kafka brokers (broker identifiers).")
    @JsonProperty(required=true)
    public List<Integer> getBrokers() {
        return this.brokers;
    }

    public void setBrokers(List<Integer> brokers) {
        this.brokers = brokers;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Pattern(value="^[0-9]+([.][0-9]{0,3}|[m]?)$")
    @Description(value="Broker capacity for CPU resource in cores or millicores. For example, 1, 1.500, 1500m. For more information on valid CPU resource units see https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/#meaning-of-cpu")
    public String getCpu() {
        return this.cpu;
    }

    public void setCpu(String cpu) {
        this.cpu = cpu;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Pattern(value="^[0-9]+([KMG]i?)?B/s$")
    @Description(value="Broker capacity for inbound network throughput in bytes per second. Use an integer value with standard Kubernetes byte units (K, M, G) or their bibyte (power of two) equivalents (Ki, Mi, Gi) per second. For example, 10000KiB/s.")
    public String getInboundNetwork() {
        return this.inboundNetwork;
    }

    public void setInboundNetwork(String inboundNetwork) {
        this.inboundNetwork = inboundNetwork;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Pattern(value="^[0-9]+([KMG]i?)?B/s$")
    @Description(value="Broker capacity for outbound network throughput in bytes per second. Use an integer value with standard Kubernetes byte units (K, M, G) or their bibyte (power of two) equivalents (Ki, Mi, Gi) per second. For example, 10000KiB/s.")
    public String getOutboundNetwork() {
        return this.outboundNetwork;
    }

    public void setOutboundNetwork(String outboundNetwork) {
        this.outboundNetwork = outboundNetwork;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BrokerCapacityOverride)) {
            return false;
        }
        BrokerCapacityOverride other = (BrokerCapacityOverride)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Integer> this$brokers = this.getBrokers();
        List<Integer> other$brokers = other.getBrokers();
        if (this$brokers == null ? other$brokers != null : !((Object)this$brokers).equals(other$brokers)) {
            return false;
        }
        String this$cpu = this.getCpu();
        String other$cpu = other.getCpu();
        if (this$cpu == null ? other$cpu != null : !this$cpu.equals(other$cpu)) {
            return false;
        }
        String this$inboundNetwork = this.getInboundNetwork();
        String other$inboundNetwork = other.getInboundNetwork();
        if (this$inboundNetwork == null ? other$inboundNetwork != null : !this$inboundNetwork.equals(other$inboundNetwork)) {
            return false;
        }
        String this$outboundNetwork = this.getOutboundNetwork();
        String other$outboundNetwork = other.getOutboundNetwork();
        if (this$outboundNetwork == null ? other$outboundNetwork != null : !this$outboundNetwork.equals(other$outboundNetwork)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BrokerCapacityOverride;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Integer> $brokers = this.getBrokers();
        result = result * 59 + ($brokers == null ? 43 : ((Object)$brokers).hashCode());
        String $cpu = this.getCpu();
        result = result * 59 + ($cpu == null ? 43 : $cpu.hashCode());
        String $inboundNetwork = this.getInboundNetwork();
        result = result * 59 + ($inboundNetwork == null ? 43 : $inboundNetwork.hashCode());
        String $outboundNetwork = this.getOutboundNetwork();
        result = result * 59 + ($outboundNetwork == null ? 43 : $outboundNetwork.hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

