/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.kafka.entityoperator;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.strimzi.api.kafka.model.common.ExternalLogging;
import io.strimzi.api.kafka.model.common.ExternalLoggingBuilder;
import io.strimzi.api.kafka.model.common.ExternalLoggingFluent;
import io.strimzi.api.kafka.model.common.InlineLogging;
import io.strimzi.api.kafka.model.common.InlineLoggingBuilder;
import io.strimzi.api.kafka.model.common.InlineLoggingFluent;
import io.strimzi.api.kafka.model.common.JvmOptions;
import io.strimzi.api.kafka.model.common.JvmOptionsBuilder;
import io.strimzi.api.kafka.model.common.JvmOptionsFluent;
import io.strimzi.api.kafka.model.common.Logging;
import io.strimzi.api.kafka.model.common.Probe;
import io.strimzi.api.kafka.model.common.ProbeBuilder;
import io.strimzi.api.kafka.model.common.ProbeFluent;
import io.strimzi.api.kafka.model.kafka.entityoperator.EntityTopicOperatorSpec;
import java.util.Objects;
import java.util.Optional;

public class EntityTopicOperatorSpecFluent<A extends EntityTopicOperatorSpecFluent<A>>
extends BaseFluent<A> {
    private String watchedNamespace;
    private String image;
    private int reconciliationIntervalSeconds;
    private int zookeeperSessionTimeoutSeconds;
    private int topicMetadataMaxAttempts;
    private ProbeBuilder startupProbe;
    private ProbeBuilder livenessProbe;
    private ProbeBuilder readinessProbe;
    private ResourceRequirements resources;
    private VisitableBuilder<? extends Logging, ?> logging;
    private JvmOptionsBuilder jvmOptions;

    public EntityTopicOperatorSpecFluent() {
    }

    public EntityTopicOperatorSpecFluent(EntityTopicOperatorSpec instance) {
        EntityTopicOperatorSpec entityTopicOperatorSpec = instance = instance != null ? instance : new EntityTopicOperatorSpec();
        if (instance != null) {
            this.withWatchedNamespace(instance.getWatchedNamespace());
            this.withImage(instance.getImage());
            this.withReconciliationIntervalSeconds(instance.getReconciliationIntervalSeconds());
            this.withZookeeperSessionTimeoutSeconds(instance.getZookeeperSessionTimeoutSeconds());
            this.withTopicMetadataMaxAttempts(instance.getTopicMetadataMaxAttempts());
            this.withStartupProbe(instance.getStartupProbe());
            this.withLivenessProbe(instance.getLivenessProbe());
            this.withReadinessProbe(instance.getReadinessProbe());
            this.withResources(instance.getResources());
            this.withLogging(instance.getLogging());
            this.withJvmOptions(instance.getJvmOptions());
        }
    }

    public String getWatchedNamespace() {
        return this.watchedNamespace;
    }

    public A withWatchedNamespace(String watchedNamespace) {
        this.watchedNamespace = watchedNamespace;
        return (A)((Object)this);
    }

    public boolean hasWatchedNamespace() {
        return this.watchedNamespace != null;
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image = image;
        return (A)((Object)this);
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public int getReconciliationIntervalSeconds() {
        return this.reconciliationIntervalSeconds;
    }

    public A withReconciliationIntervalSeconds(int reconciliationIntervalSeconds) {
        this.reconciliationIntervalSeconds = reconciliationIntervalSeconds;
        return (A)((Object)this);
    }

    public boolean hasReconciliationIntervalSeconds() {
        return true;
    }

    public int getZookeeperSessionTimeoutSeconds() {
        return this.zookeeperSessionTimeoutSeconds;
    }

    public A withZookeeperSessionTimeoutSeconds(int zookeeperSessionTimeoutSeconds) {
        this.zookeeperSessionTimeoutSeconds = zookeeperSessionTimeoutSeconds;
        return (A)((Object)this);
    }

    public boolean hasZookeeperSessionTimeoutSeconds() {
        return true;
    }

    public int getTopicMetadataMaxAttempts() {
        return this.topicMetadataMaxAttempts;
    }

    public A withTopicMetadataMaxAttempts(int topicMetadataMaxAttempts) {
        this.topicMetadataMaxAttempts = topicMetadataMaxAttempts;
        return (A)((Object)this);
    }

    public boolean hasTopicMetadataMaxAttempts() {
        return true;
    }

    public Probe buildStartupProbe() {
        return this.startupProbe != null ? this.startupProbe.build() : null;
    }

    public A withStartupProbe(Probe startupProbe) {
        this._visitables.get((Object)"startupProbe").remove((Object)this.startupProbe);
        if (startupProbe != null) {
            this.startupProbe = new ProbeBuilder(startupProbe);
            this._visitables.get((Object)"startupProbe").add(this.startupProbe);
        } else {
            this.startupProbe = null;
            this._visitables.get((Object)"startupProbe").remove((Object)this.startupProbe);
        }
        return (A)((Object)this);
    }

    public boolean hasStartupProbe() {
        return this.startupProbe != null;
    }

    public A withNewStartupProbe(int initialDelaySeconds, int timeoutSeconds) {
        return this.withStartupProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    public StartupProbeNested<A> withNewStartupProbe() {
        return new StartupProbeNested(null);
    }

    public StartupProbeNested<A> withNewStartupProbeLike(Probe item) {
        return new StartupProbeNested(item);
    }

    public StartupProbeNested<A> editStartupProbe() {
        return this.withNewStartupProbeLike(Optional.ofNullable(this.buildStartupProbe()).orElse(null));
    }

    public StartupProbeNested<A> editOrNewStartupProbe() {
        return this.withNewStartupProbeLike(Optional.ofNullable(this.buildStartupProbe()).orElse(new ProbeBuilder().build()));
    }

    public StartupProbeNested<A> editOrNewStartupProbeLike(Probe item) {
        return this.withNewStartupProbeLike(Optional.ofNullable(this.buildStartupProbe()).orElse(item));
    }

    public Probe buildLivenessProbe() {
        return this.livenessProbe != null ? this.livenessProbe.build() : null;
    }

    public A withLivenessProbe(Probe livenessProbe) {
        this._visitables.get((Object)"livenessProbe").remove((Object)this.livenessProbe);
        if (livenessProbe != null) {
            this.livenessProbe = new ProbeBuilder(livenessProbe);
            this._visitables.get((Object)"livenessProbe").add(this.livenessProbe);
        } else {
            this.livenessProbe = null;
            this._visitables.get((Object)"livenessProbe").remove((Object)this.livenessProbe);
        }
        return (A)((Object)this);
    }

    public boolean hasLivenessProbe() {
        return this.livenessProbe != null;
    }

    public A withNewLivenessProbe(int initialDelaySeconds, int timeoutSeconds) {
        return this.withLivenessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    public LivenessProbeNested<A> withNewLivenessProbe() {
        return new LivenessProbeNested(null);
    }

    public LivenessProbeNested<A> withNewLivenessProbeLike(Probe item) {
        return new LivenessProbeNested(item);
    }

    public LivenessProbeNested<A> editLivenessProbe() {
        return this.withNewLivenessProbeLike(Optional.ofNullable(this.buildLivenessProbe()).orElse(null));
    }

    public LivenessProbeNested<A> editOrNewLivenessProbe() {
        return this.withNewLivenessProbeLike(Optional.ofNullable(this.buildLivenessProbe()).orElse(new ProbeBuilder().build()));
    }

    public LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item) {
        return this.withNewLivenessProbeLike(Optional.ofNullable(this.buildLivenessProbe()).orElse(item));
    }

    public Probe buildReadinessProbe() {
        return this.readinessProbe != null ? this.readinessProbe.build() : null;
    }

    public A withReadinessProbe(Probe readinessProbe) {
        this._visitables.get((Object)"readinessProbe").remove((Object)this.readinessProbe);
        if (readinessProbe != null) {
            this.readinessProbe = new ProbeBuilder(readinessProbe);
            this._visitables.get((Object)"readinessProbe").add(this.readinessProbe);
        } else {
            this.readinessProbe = null;
            this._visitables.get((Object)"readinessProbe").remove((Object)this.readinessProbe);
        }
        return (A)((Object)this);
    }

    public boolean hasReadinessProbe() {
        return this.readinessProbe != null;
    }

    public A withNewReadinessProbe(int initialDelaySeconds, int timeoutSeconds) {
        return this.withReadinessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    public ReadinessProbeNested<A> withNewReadinessProbe() {
        return new ReadinessProbeNested(null);
    }

    public ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item) {
        return new ReadinessProbeNested(item);
    }

    public ReadinessProbeNested<A> editReadinessProbe() {
        return this.withNewReadinessProbeLike(Optional.ofNullable(this.buildReadinessProbe()).orElse(null));
    }

    public ReadinessProbeNested<A> editOrNewReadinessProbe() {
        return this.withNewReadinessProbeLike(Optional.ofNullable(this.buildReadinessProbe()).orElse(new ProbeBuilder().build()));
    }

    public ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item) {
        return this.withNewReadinessProbeLike(Optional.ofNullable(this.buildReadinessProbe()).orElse(item));
    }

    public ResourceRequirements getResources() {
        return this.resources;
    }

    public A withResources(ResourceRequirements resources) {
        this.resources = resources;
        return (A)((Object)this);
    }

    public boolean hasResources() {
        return this.resources != null;
    }

    public Logging buildLogging() {
        return this.logging != null ? (Logging)this.logging.build() : null;
    }

    public A withLogging(Logging logging) {
        if (logging == null) {
            this.logging = null;
            this._visitables.remove((Object)"logging");
            return (A)((Object)this);
        }
        VisitableBuilder builder = EntityTopicOperatorSpecFluent.builder(logging);
        this._visitables.get((Object)"logging").clear();
        this._visitables.get((Object)"logging").add(builder);
        this.logging = builder;
        return (A)((Object)this);
    }

    public boolean hasLogging() {
        return this.logging != null;
    }

    public InlineLoggingNested<A> withNewInlineLogging() {
        return new InlineLoggingNested(null);
    }

    public InlineLoggingNested<A> withNewInlineLoggingLike(InlineLogging item) {
        return new InlineLoggingNested(item);
    }

    public ExternalLoggingNested<A> withNewExternalLogging() {
        return new ExternalLoggingNested(null);
    }

    public ExternalLoggingNested<A> withNewExternalLoggingLike(ExternalLogging item) {
        return new ExternalLoggingNested(item);
    }

    public JvmOptions buildJvmOptions() {
        return this.jvmOptions != null ? this.jvmOptions.build() : null;
    }

    public A withJvmOptions(JvmOptions jvmOptions) {
        this._visitables.get((Object)"jvmOptions").remove((Object)this.jvmOptions);
        if (jvmOptions != null) {
            this.jvmOptions = new JvmOptionsBuilder(jvmOptions);
            this._visitables.get((Object)"jvmOptions").add(this.jvmOptions);
        } else {
            this.jvmOptions = null;
            this._visitables.get((Object)"jvmOptions").remove((Object)this.jvmOptions);
        }
        return (A)((Object)this);
    }

    public boolean hasJvmOptions() {
        return this.jvmOptions != null;
    }

    public JvmOptionsNested<A> withNewJvmOptions() {
        return new JvmOptionsNested(null);
    }

    public JvmOptionsNested<A> withNewJvmOptionsLike(JvmOptions item) {
        return new JvmOptionsNested(item);
    }

    public JvmOptionsNested<A> editJvmOptions() {
        return this.withNewJvmOptionsLike(Optional.ofNullable(this.buildJvmOptions()).orElse(null));
    }

    public JvmOptionsNested<A> editOrNewJvmOptions() {
        return this.withNewJvmOptionsLike(Optional.ofNullable(this.buildJvmOptions()).orElse(new JvmOptionsBuilder().build()));
    }

    public JvmOptionsNested<A> editOrNewJvmOptionsLike(JvmOptions item) {
        return this.withNewJvmOptionsLike(Optional.ofNullable(this.buildJvmOptions()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EntityTopicOperatorSpecFluent that = (EntityTopicOperatorSpecFluent)((Object)o);
        if (!Objects.equals(this.watchedNamespace, that.watchedNamespace)) {
            return false;
        }
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (this.reconciliationIntervalSeconds != that.reconciliationIntervalSeconds) {
            return false;
        }
        if (this.zookeeperSessionTimeoutSeconds != that.zookeeperSessionTimeoutSeconds) {
            return false;
        }
        if (this.topicMetadataMaxAttempts != that.topicMetadataMaxAttempts) {
            return false;
        }
        if (!Objects.equals((Object)this.startupProbe, (Object)that.startupProbe)) {
            return false;
        }
        if (!Objects.equals((Object)this.livenessProbe, (Object)that.livenessProbe)) {
            return false;
        }
        if (!Objects.equals((Object)this.readinessProbe, (Object)that.readinessProbe)) {
            return false;
        }
        if (!Objects.equals(this.resources, that.resources)) {
            return false;
        }
        if (!Objects.equals(this.logging, that.logging)) {
            return false;
        }
        return Objects.equals((Object)this.jvmOptions, (Object)that.jvmOptions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.watchedNamespace, this.image, this.reconciliationIntervalSeconds, this.zookeeperSessionTimeoutSeconds, this.topicMetadataMaxAttempts, this.startupProbe, this.livenessProbe, this.readinessProbe, this.resources, this.logging, this.jvmOptions, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.watchedNamespace != null) {
            sb.append("watchedNamespace:");
            sb.append(this.watchedNamespace + ",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        sb.append("reconciliationIntervalSeconds:");
        sb.append(this.reconciliationIntervalSeconds + ",");
        sb.append("zookeeperSessionTimeoutSeconds:");
        sb.append(this.zookeeperSessionTimeoutSeconds + ",");
        sb.append("topicMetadataMaxAttempts:");
        sb.append(this.topicMetadataMaxAttempts + ",");
        if (this.startupProbe != null) {
            sb.append("startupProbe:");
            sb.append(this.startupProbe + ",");
        }
        if (this.livenessProbe != null) {
            sb.append("livenessProbe:");
            sb.append(this.livenessProbe + ",");
        }
        if (this.readinessProbe != null) {
            sb.append("readinessProbe:");
            sb.append(this.readinessProbe + ",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.logging != null) {
            sb.append("logging:");
            sb.append(this.logging + ",");
        }
        if (this.jvmOptions != null) {
            sb.append("jvmOptions:");
            sb.append((Object)this.jvmOptions);
        }
        sb.append("}");
        return sb.toString();
    }

    protected static <T> VisitableBuilder<T, ?> builder(Object item) {
        switch (item.getClass().getName()) {
            case "io.strimzi.api.kafka.model.common.InlineLogging": {
                return new InlineLoggingBuilder((InlineLogging)item);
            }
            case "io.strimzi.api.kafka.model.common.ExternalLogging": {
                return new ExternalLoggingBuilder((ExternalLogging)item);
            }
        }
        return EntityTopicOperatorSpecFluent.builderOf((Object)item);
    }

    public class StartupProbeNested<N>
    extends ProbeFluent<StartupProbeNested<N>>
    implements Nested<N> {
        ProbeBuilder builder;

        StartupProbeNested(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        public N and() {
            return (N)EntityTopicOperatorSpecFluent.this.withStartupProbe(this.builder.build());
        }

        public N endStartupProbe() {
            return this.and();
        }
    }

    public class LivenessProbeNested<N>
    extends ProbeFluent<LivenessProbeNested<N>>
    implements Nested<N> {
        ProbeBuilder builder;

        LivenessProbeNested(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        public N and() {
            return (N)EntityTopicOperatorSpecFluent.this.withLivenessProbe(this.builder.build());
        }

        public N endLivenessProbe() {
            return this.and();
        }
    }

    public class ReadinessProbeNested<N>
    extends ProbeFluent<ReadinessProbeNested<N>>
    implements Nested<N> {
        ProbeBuilder builder;

        ReadinessProbeNested(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        public N and() {
            return (N)EntityTopicOperatorSpecFluent.this.withReadinessProbe(this.builder.build());
        }

        public N endReadinessProbe() {
            return this.and();
        }
    }

    public class InlineLoggingNested<N>
    extends InlineLoggingFluent<InlineLoggingNested<N>>
    implements Nested<N> {
        InlineLoggingBuilder builder;

        InlineLoggingNested(InlineLogging item) {
            this.builder = new InlineLoggingBuilder(this, item);
        }

        public N and() {
            return (N)EntityTopicOperatorSpecFluent.this.withLogging(this.builder.build());
        }

        public N endInlineLogging() {
            return this.and();
        }
    }

    public class ExternalLoggingNested<N>
    extends ExternalLoggingFluent<ExternalLoggingNested<N>>
    implements Nested<N> {
        ExternalLoggingBuilder builder;

        ExternalLoggingNested(ExternalLogging item) {
            this.builder = new ExternalLoggingBuilder(this, item);
        }

        public N and() {
            return (N)EntityTopicOperatorSpecFluent.this.withLogging(this.builder.build());
        }

        public N endExternalLogging() {
            return this.and();
        }
    }

    public class JvmOptionsNested<N>
    extends JvmOptionsFluent<JvmOptionsNested<N>>
    implements Nested<N> {
        JvmOptionsBuilder builder;

        JvmOptionsNested(JvmOptions item) {
            this.builder = new JvmOptionsBuilder(this, item);
        }

        public N and() {
            return (N)EntityTopicOperatorSpecFluent.this.withJvmOptions(this.builder.build());
        }

        public N endJvmOptions() {
            return this.and();
        }
    }
}

